#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

global tnpath

# set tnpath
# examples of tnpath: 
#   /home/dennis/tn (unix) 
#   c:/user/dennis/tn (ms windows) 
set tnpath ~/tn

source $tnpath/gid/global.tcl

set tn_switch 0
set tn_window_offset +50+50
set directory_start [pwd]

# create main window

eval destroy [winfo child .]
wm title . "Tochnog-GID"
wm geometry . 200x20+0+0

#  tngidmbar

frame .tngidmbar -relief raised -bd 2
frame .dummy -width 10c -height 5c

pack .tngidmbar .dummy -side top -fill x

menubutton .tngidmbar.file -text File -menu .tngidmbar.file.menu
menubutton .tngidmbar.edit -text Edit -menu .tngidmbar.edit.menu
menubutton .tngidmbar.search -text Search -menu .tngidmbar.search.menu
menubutton .tngidmbar.help -text Help -menu .tngidmbar.help.menu

pack .tngidmbar.file .tngidmbar.edit -side left
pack .tngidmbar.help -side right
pack .tngidmbar.search -side right

# tngidmbar file 

set m .tngidmbar.file.menu
menu $m
$m add command -label "Open/Save/View" -command { file_file }
$m add command -label "Save append.dat" -command { 
  file_write append.dat initia_and_data
}
$m add command -label "Quit" -command { destroy . }

# tngidmbar edit 

set m .tngidmbar.edit.menu
menu $m
$m add command -label "Initia" -command { edit_initia }
$m add command -label "Data" -command { edit_data }

# tngidmbar search 

set m .tngidmbar.search.menu
menu $m
$m add command -label "Data" -command { search_data }
$m add command -label "File" -command { search_file }

# tngidmbar help 

set m .tngidmbar.help.menu
menu $m
$m add command -label "About" -command {
  help "Tochnog-GID is developed and copyrighted by Dennis Roddeman. The Gnu Public License applies."
}
$m add command -label "Menu bar" -command { 
  help "File.\n  Open/Save/View: open, save or view file.\n\nEdit.\n  Initia: edit initia part.\n  Data: edit data part.\n\nSearch.\n  Data: Search for data items containing ...\n  Files: Search for file in test directory containing ...\n"
}
$m add command -label "Limitations" -command {
  help "Tochnog-GID uses files tngid.* for communication with Tochnog. You should not use such file names yourself."
}

#   include tcl files

  source $tnpath/gid/file.tcl
  source $tnpath/gid/edit_initia.tcl
  source $tnpath/gid/edit_data.tcl
  source $tnpath/gid/search_data.tcl
  source $tnpath/gid/search_file.tcl
  source $tnpath/gid/help.tcl
  source $tnpath/gid/initia.tcl
  source $tnpath/gid/run.tcl
  source $tnpath/gid/miscel.tcl

#  initialise
  initia_initialise
  run
  data_initialise

#

tk_menuBar .tngidmbar .tngidmbar.edit .tngidmbar.help
focus .tngidmbar
