/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmtdefaults.c	2.32  11/03/99
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * gmtdefaults will list the users default settings for the GMT-SYSTEM or
 * (by using the -D option), get the GMT-SYSTEM's default settings.
 *
 * Author:	Paul Wessel
 * Date:	1-MAY-1991
 * Version:	2.0
 * Modified:	12-JUN-1998, for GMT 3.1
 */
 
#include "gmt.h"

main (int argc, char **argv)
{
	int i, get;
	
	BOOLEAN error = FALSE, get_sys_defaults = FALSE, get_user_defaults = FALSE;
	
	char *path;
	
	GMT_stdout = stdout;	GMT_stdin = stdin;

	for (i = 1; !error && i < argc; i++) {
		if (argv[i][0] != '-') continue;
		switch (argv[i][1]) {
			case '\0':
				error += GMT_get_common_args (argv[i], 0, 0, 0, 0);
				break;
			case 'D':	/* Get GMT defaults settings */
				get_sys_defaults = TRUE;
				switch (argv[i][2]) {
					case 'S':	/* SI version */
					case 's':
						get = 1;
						break;
					case 'U':	/* US version */
					case 'u':
						get = 2;
						break;
					default:	/* Version chosen in gmt.conf */
						get = 0;
						break;
				}
				break;
			case 'L':	/* List the user's current GMT defaults settings */
				get_user_defaults = TRUE;
				break;
			default:
				error = TRUE;
                                GMT_default_error (argv[i][1]);
                                exit (EXIT_FAILURE);
				break;
		}
	}
	
	if (argc == 1 || GMT_quick) {
		fprintf (stderr, "gmtdefaults %s - List GMT-SYSTEM default parameters\n\n", GMT_VERSION);
		fprintf (stderr, "usage: gmtdefaults [-D[s|u] | -L]\n\n");
		if (GMT_quick) exit (EXIT_FAILURE);
		fprintf (stderr, "	-D prints the default settings for the GMT system\n");
		fprintf (stderr, "	   Append s to see the SI version of defaults\n");
		fprintf (stderr, "	   Append u to see the US version of defaults\n");
		fprintf (stderr, "	-L prints the users current GMT default settings\n");
		exit (EXIT_FAILURE);
	}
	
	if ((get_user_defaults + get_sys_defaults) != 1) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR: Must specify one of -D or -L\n", GMT_program);
		error++;
	}
	
	if (error) exit (EXIT_FAILURE);
	
	if (get_user_defaults) {
		GMT_getdefaults (CNULL);
	}
	else {
		path = GMT_getdefpath (get);
		GMT_getdefaults (path);
		GMT_free (path);
	}
	
	GMT_savedefaults (CNULL);

	exit (EXIT_SUCCESS);
}
