/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if !defined( _GPERIODIC_H )
#define _GPERIODIC_H 

/*
 * object to hold element data, as initialized from the static
 * table_data.cc, or from the provided file...
 *
 */
class table_entry {
public:
  table_entry() 
	  : name((char*)NULL)
		, symbol((char*)NULL)
    , number((char*)NULL)
    , weight((char*)NULL)
    , melting((char*)NULL)
    , boiling((char*)NULL)
    , pauling((char*)NULL)
    , x(0)
    , y(0)
    , button((GtkWidget*)NULL)
    , tooltip((GtkTooltips*)NULL)
		{
	};

  virtual ~table_entry() {
    delete [] name;
    delete [] symbol;
    delete [] number;
    delete [] weight;
    delete [] melting;
    delete [] boiling;
    delete [] pauling;
    // g_free(button);
    // g_free(tooltip);
	};

  char* name;     // element name
  char* symbol;   // element symbol
  char* number;   // atomic number
  char* weight;   // atomic weight
  char* melting;  // melting point (might not be at sea level)
  char* boiling;  // boiling piont (might not be at sea level)
	char* pauling;  // pauling negativity number
  int   x;        // x position in the table
  int   y;        // y position in the table
  GtkWidget   *button;  // associated gtk button
  GtkTooltips *tooltip; // associated gtk tooltip
};

void main_window_exit(GtkWidget*,gpointer);
int load_table(const char*);
int init_table_en(void);
int init_table_fr(void);
int init_table_pt(void);
int init_table_es(void);
int init_table_de(void);
void display_element_dialog(GtkWidget*,gpointer);
void dialog_close(GtkWidget*,gpointer);
void dialog_destroy(GtkWidget*,gpointer);
void menu_file_exit(gpointer,guint,GtkWidget*);
void menu_help_about(gpointer,guint,GtkWidget*);
void show_usage(void);
char* dupstr( const char* s );

// debugging macro, does nothing unless _DEBUG is defined...
#if defined( _DEBUG )
#  define _DBG(a) (a)
#else
#  define _DBG(a)
#endif

#define	VERSION = "1.0.4"

// these are for the foreign language support...
// I am not familliar with real ways to do internaltionalization,
// and someone sent me translations for french, so this is the way
// I'm going to handle it...
int set_language(const char*);
extern char **strings;
extern char **strings_en;
extern char **strings_fr;
extern char **strings_pt;
extern char **strings_es;
extern char **strings_de;

void init_strings(void);

#define STR_BASE_INDEX                  0
#define STR_BOILING_POINT               (STR_BASE_INDEX + 0)
#define STR_ERROR_BUTTON_WAS_NULL       (STR_BASE_INDEX + 1)
#define STR_FRENCH_ADAPTATION           (STR_BASE_INDEX + 2)
#define STR_MELTING_POINT               (STR_BASE_INDEX + 3)
#define STR_MENU_PATH_FILE              (STR_BASE_INDEX + 4)
#define STR_MENU_PATH_FILE_QUIT         (STR_BASE_INDEX + 5)
#define STR_MENU_PATH_HELP              (STR_BASE_INDEX + 6)
#define STR_MENU_PATH_HELP_ABOUT        (STR_BASE_INDEX + 7)
#define STR_NAME                        (STR_BASE_INDEX + 8)
#define STR_NO_SYMBOL_FOR_INDEX         (STR_BASE_INDEX + 9)
#define STR_NUMBER                      (STR_BASE_INDEX + 10)
#define STR_OK                          (STR_BASE_INDEX + 11)
#define STR_PAULING_NEGATIVITY_NUMBER   (STR_BASE_INDEX + 12)
#define STR_SYMBOL                      (STR_BASE_INDEX + 13)
#define STR_WEIGHT                      (STR_BASE_INDEX + 14)
#define STR_SPANISH_ADAPTATION          (STR_BASE_INDEX + 15)
#define STR_GERMAN_ADAPTATION           (STR_BASE_INDEX + 16)
#define STR_TOOLTIPS_FORMAT_STRING      (STR_BASE_INDEX + 17)
#define STR_PORTUG_ADAPTATION           (STR_BASE_INDEX + 18)

#define STRINGS_NUM_STRINGS 19


#endif

