/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <linux/cdrom.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>



int eject(char *device)
{
  int fd;
  int status;

  fd = open(device,O_RDONLY|O_NONBLOCK );
  status = ioctl(fd, CDROMEJECT);
  close(fd);
  return status;
}


int main(int argc, char **argv)
{
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  int rc;

  //s'ajit pas de faire un buffer overflow, alors dans le doute, je limite!
  if (strlen(argv[1]) > 200) exit(-1);

  fp = fopen("/etc/fstab", "r");
  if (fp == NULL) {
    fprintf(stderr, "%s: unable to open /etc/fstab: %s\n", argv[0], strerror(errno));
    exit(1);
  }
  
  while (fgets(line, sizeof(line), fp) != 0)
    {
      rc = sscanf(line, "%1023s %1023s", s1, s2);
      if (rc >= 2 && strcmp(s2, argv[1]) == 0)
	{
	  fclose(fp);
	  eject(s1);
	  exit(0);
	}
    }
  fclose(fp);
  exit(-1);
}
