/*
 * whois.h: header for whois.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: whois.h,v 1.4 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _WHOIS_H_
#define _WHOIS_H_

#include "irc_std.h"

typedef	struct	WhoisStuffStru
{
	char	*nick;
	char	*user;
	char	*host;
	char	*channel;
	char	*channels;
	char	*name;
	char	*server;
	char	*server_stuff;
	char	*away;
	int	oper;
	int	chop;
	int	not_on;
}	WhoisStuff;

/* Moved into here, because some weird CC's can't do (void *) */
typedef	struct	WhoisQueueStru
{
	char	*nick;			/* nickname of whois'ed person(s) */
	char	*text;			/* additional text */
	int	type;			/* Type of WHOIS queue entry */
	/*
	 * called with func((WhoisStuff *)stuff,(char *) nick, (char *) text) 
	 */
	void	(*func)();
	struct	WhoisQueueStru	*next;/* next element in queue */
}	WhoisQueue;


extern	void	add_to_whois_queue _((char *, void (*)(), char *, ...));
extern	void	add_ison_to_whois _((char *, void (*)()));
extern	void	add_userhost_to_whois _((char *, void (*)()));
extern	void	whois_name _((char *, char **));
extern	void	whowas_name _((char *, char **));
extern	void	whois_channels _((char *, char **));
extern	void	whois_server _((char *, char **));
extern	void	whois_oper _((char *, char **));
extern	void	whois_lastcom _((char *, char **));
extern	void	whois_nickname _((WhoisStuff *, char *, char *));
extern	void	whois_ignore_msgs _((WhoisStuff *, char *, char *));
extern	void	whois_ignore_notices _((WhoisStuff *, char *, char *));
extern	void	whois_ignore_walls _((WhoisStuff *, char *, char *));
extern	void	whois_ignore_invites _((WhoisStuff *, char *, char *));
extern	void	whois_notify _((WhoisStuff *, char *, char *));
extern	void	whois_new_wallops _((WhoisStuff *, char *, char *));
extern	void	clean_whois_queue _((void));
extern	void	set_beep_on_msg _((char *));
extern	int	beep_on_level;
extern  void    userhost_cmd_returned _((WhoisStuff *, char *, char *));
extern	void	user_is_away _((char *, char **));
extern	void	userhost_returned _((char *, char **));
extern	void	ison_returned _((char *, char **));
extern	void	whois_chop _((char *, char **));
extern	void	end_of_whois _((char *, char **));
extern	void	whoreply _((char *, char **));
extern	void	convert_to_whois _((void));
extern	void	no_such_nickname _((char *, char **));
extern	void	got_my_userhost _((WhoisStuff *, char *, char *));

extern	char	*redirect_format;

#define	WHOIS_WHOIS	0
#define	WHOIS_ISON	1
#define	WHOIS_USERHOST	2
#define WHOIS_WHOWAS	3

#define	USERHOST_USERHOST ((void (*)()) 1)

#endif /* _WHOIS_H_ */
