/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998,1999 Bert Vermeulen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define MAX_SUFFIX_LEN   256

enum entry_status {
     STATUS_UNKNOWN,
     IS_SERVER,
     HAS_SUFFIXES,
     HAS_NO_SUFFIXES,
     HAS_CHILDREN,
     HAS_NO_CHILDREN
};

struct node_entry {
     enum entry_status status;
     char *dn;
     /* cache values here */
};



GtkWidget *create_mainwin_browsemode(void);
void add_all_servers(void);
GtkWidget *gnode_to_tree(GNode *node, GtkWidget *tree);
gboolean gnode_to_tree_callback(GNode *node, gpointer tree);
void remove_server_node_tree(struct ldapserver *server);

void attach_children_to_node(GtkWidget *item);
void attach_children_to_tree(GtkWidget *item);
void attach_server_suffixes(GtkWidget *item);
void descend_onelevel(GNode *node);

gboolean button_press_on_tree_item(GtkWidget *tree_item, GdkEventButton *event);
void refresh_server(GtkWidget *widget, GtkWidget *tree_item);
void refresh_subtree(GtkWidget *widget, GtkWidget *tree_item);
void delete_browse_entry(GtkWidget *widget, GtkWidget *tree_item);
void delete_browse_warning_popup(GtkWidget *tree_item);

void server_item_selected(GtkWidget *treeroot, GtkWidget *item);

void edit_right_pane_values(GtkWidget *treeroot, GtkWidget *tree_item);
void edit_right_pane_novalues(GtkWidget *widget, GtkWidget *tree_item);
void edit_right_pane(GtkWidget *tree_item, int show_values);

void refresh_right_pane(GtkWidget *dummy);
void clear_right_pane(void);
GNode *node_by_cur_dn(void);
void set_server_callback(GNode *node, gpointer *server);
gboolean set_node_callback(GNode *node, gpointer *data);

struct ldapserver *server_by_node(GNode *node);
char *dn_by_node(GNode *node);
struct node_entry *new_node_entry(char *dn);

GSList *get_suffix(struct ldapserver *server);

void cleanup_browse_mode(void);
void free_browse_all(void);
gboolean node_entry_free_callback(GNode *node, gpointer dummy);
void node_entry_destroy(GNode *node, gpointer dummy);

void dump_subtree(GtkWidget *widget, GtkWidget *tree_item);
void dump_subtree_ok_callback(GtkWidget *button, GtkWidget *filesel);
void dump_subtree_filesel_destroy(GtkWidget *button, GtkWidget *filesel);
void add_dn_to_gslist(GNode *node, gpointer *bases);
