/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998,1999 Bert Vermeulen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "mainwin.h"
#include "configfile.h"
#include "common.h"
#include "browse.h"
#include "prefs.h"
#include "query.h"
#include "util.h"
#include "logo.xpm"
#include "COPYING.h"
#include "debug.h"

GtkWidget *mainwin = NULL;
GtkWidget *serverlist_combo = NULL;
GtkWidget *main_clist = NULL;
GtkWidget *main_vbox = NULL;
GtkWidget *mode_vbox = NULL;
GtkWidget *statusbar;
int cur_mode = SEARCH_MODE;

extern struct resultset *cur_resultset;
extern struct gq_config config;


void fill_serverlist_combo(void)
{
     GList *serverlist;
     struct ldapserver *server;

     serverlist = NULL;
     server = config.ldapservers;
     while(server) {
	  serverlist = g_list_append(serverlist, server->name);
	  server = server->next;
     }

     if(!serverlist)
	  /* all servers were deleted -- pass an empty string to the combo */
	  serverlist = g_list_append(serverlist, "");

     gtk_combo_set_popdown_strings(GTK_COMBO(serverlist_combo), serverlist);

     g_list_free(serverlist);

}


void gq_exit(GtkWidget *widget, gpointer *data)
{

     cleanup();
     gtk_main_quit();

}


void cleanup(void)
{
     struct ldapserver *server, *nextserver;

     /* free malloc'd ldapservers */
     server = config.ldapservers;
     while(server) {
	  nextserver = server->next;
	  if(server->connection)
	       ldap_unbind(server->connection);
	  FREE(server, "struct ldapserver");
	  server = nextserver;
     }

     if(cur_resultset)
	  free_resultset(cur_resultset);

     cleanup_browse_mode();

#ifdef DEBUG
     report_num_mallocs();
#endif

}


void searchtype_changed_callback(gpointer *selection)
{
     char *data = (char *) selection;

     if(!strcmp(data, LABEL_ST_SEARCH))
	  config.searchtype = ST_SEARCH;
     else if(!strcmp(data, LABEL_ST_FILTER))
	  config.searchtype = ST_FILTER;

}


void servername_changed_callback(GtkEntry *entry)
{

     config.cur_servername = gtk_entry_get_text(entry);

}


void findbutton_pressed_callback(GtkWidget *entry)
{
     gchar *entry_text;

     entry_text = gtk_entry_get_text(GTK_ENTRY(entry));

     set_busycursor();

     query(entry_text);

     set_normalcursor();

     gtk_widget_grab_focus(entry);
     gtk_widget_grab_default(entry);
     gtk_entry_select_region(GTK_ENTRY(entry),0,strlen(entry_text));

}


void create_mainwin(void)
{
     GtkWidget *menubar;
     GtkWidget *File, *menuFile, *Preferences, *Quit;
     GtkWidget *Mode, *menuMode, *Search, *Browse;
     GtkWidget *menuHelp, *Help, *License, *About;
     GtkWidget *focusbox;
     GtkAccelGroup *accel_group;

     mainwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
     gtk_window_set_default_size(GTK_WINDOW(mainwin), 770, 450);
     gtk_container_border_width(GTK_CONTAINER(mainwin), 4);
     gtk_signal_connect(GTK_OBJECT(mainwin), "destroy",
			GTK_SIGNAL_FUNC(gq_exit),
			NULL);
     gtk_window_set_title(GTK_WINDOW(mainwin), PACKAGE);
     gtk_window_set_policy(GTK_WINDOW(mainwin), TRUE, TRUE, FALSE);

     main_vbox = gtk_vbox_new(FALSE, 2);
     gtk_object_set_data(GTK_OBJECT(mainwin), "main_vbox", main_vbox);
     gtk_widget_show(main_vbox);
     gtk_container_add(GTK_CONTAINER(mainwin), main_vbox);

     accel_group = gtk_accel_group_new();
     gtk_accel_group_attach(accel_group, GTK_OBJECT(mainwin));

     menubar = gtk_menu_bar_new();
     gtk_widget_show(menubar);
     gtk_box_pack_start(GTK_BOX(main_vbox), menubar, FALSE, TRUE, 1);

     /* File menu */
     File = gtk_menu_item_new_with_label("File");
     gtk_widget_show(File);
     gtk_container_add(GTK_CONTAINER(menubar), File);

     menuFile = gtk_menu_new();
     gtk_menu_item_set_submenu(GTK_MENU_ITEM(File), menuFile);

     /* File | Preferences */
     Preferences = gtk_menu_item_new_with_label("Preferences");
     gtk_widget_show(Preferences);
     gtk_container_add(GTK_CONTAINER(menuFile), Preferences);
     gtk_signal_connect(GTK_OBJECT(Preferences), "activate",
			GTK_SIGNAL_FUNC(create_prefs_window),
			NULL);
     gtk_widget_add_accelerator(Preferences, "activate", accel_group, 'P',
				GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

     /* File | Quit */
     Quit = gtk_menu_item_new_with_label("Quit");
     gtk_widget_show(Quit);
     gtk_container_add(GTK_CONTAINER(menuFile), Quit);
     gtk_signal_connect_object(GTK_OBJECT(Quit), "activate",
			       GTK_SIGNAL_FUNC(gtk_widget_destroy),
			       GTK_OBJECT(mainwin));


     /* Mode menu */
     Mode = gtk_menu_item_new_with_label("Mode");
     gtk_widget_show(Mode);
     gtk_container_add(GTK_CONTAINER(menubar), Mode);

     menuMode = gtk_menu_new();
     gtk_menu_item_set_submenu(GTK_MENU_ITEM(Mode), menuMode);

     /* Mode | Search */
     Search = gtk_menu_item_new_with_label("Search");
     gtk_widget_show(Search);
     gtk_container_add(GTK_CONTAINER(menuMode), Search);
     gtk_signal_connect_object(GTK_OBJECT(Search), "activate",
			       GTK_SIGNAL_FUNC(mode_search_selected),
			       GTK_OBJECT(mainwin));
     gtk_widget_add_accelerator(Search, "activate", accel_group, 'S',
				GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

     /* Mode | Browse */
     Browse = gtk_menu_item_new_with_label("Browse");
     gtk_widget_show(Browse);
     gtk_container_add(GTK_CONTAINER(menuMode), Browse);
     gtk_signal_connect_object(GTK_OBJECT(Browse), "activate",
			       GTK_SIGNAL_FUNC(mode_browse_selected),
			       GTK_OBJECT(mainwin));
     gtk_widget_add_accelerator(Browse, "activate", accel_group, 'B',
				GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
     /* ctrl-B is used by text widgets, so the searchterm textbox that
	always has focus in search mode blocks the above accelerator...*/
     gtk_signal_connect(GTK_OBJECT(mainwin), "key_press_event",
			GTK_SIGNAL_FUNC(ctrl_b_hack),
			(gpointer) Browse);

     /* Help menu */
     Help = gtk_menu_item_new_with_label("Help");
     gtk_widget_show(Help);
     gtk_container_add(GTK_CONTAINER(menubar), Help);
     gtk_menu_item_right_justify(GTK_MENU_ITEM(Help));

     menuHelp = gtk_menu_new();
     gtk_menu_item_set_submenu(GTK_MENU_ITEM(Help), menuHelp);

     /* Help | License */
     License = gtk_menu_item_new_with_label("License");
     gtk_widget_show(License);
     gtk_container_add(GTK_CONTAINER(menuHelp), License);
     gtk_signal_connect(GTK_OBJECT(License), "activate",
			GTK_SIGNAL_FUNC(create_license_window), NULL);

     /* Help | About */
     About = gtk_menu_item_new_with_label("About");
     gtk_widget_show(About);
     gtk_container_add(GTK_CONTAINER(menuHelp), About);
     gtk_signal_connect(GTK_OBJECT(About), "activate",
			GTK_SIGNAL_FUNC(create_about_window), NULL);

     cur_mode = SEARCH_MODE;
     mode_vbox = create_mainwin_searchmode();

     gtk_box_pack_start(GTK_BOX(main_vbox), mode_vbox, TRUE, TRUE, 0);
     focusbox = gtk_object_get_data(GTK_OBJECT(mode_vbox), "focus");
     gtk_widget_grab_focus(focusbox);

     statusbar = gtk_statusbar_new();
     gtk_object_set_data(GTK_OBJECT(mainwin), "statusbar", statusbar);
     gtk_widget_show(statusbar);
     gtk_box_pack_end(GTK_BOX(main_vbox), statusbar, FALSE, FALSE, 5);
     gtk_widget_set_sensitive(statusbar, TRUE);

     gtk_widget_show(mainwin);

}


void mode_search_selected(GtkWidget *widget, GtkWidget *mainwin)
{
     GtkWidget *focusbox;

     if(cur_mode != SEARCH_MODE) {
	  cleanup_browse_mode();

	  gtk_widget_destroy(mode_vbox);

	  statusbar_msg("");

	  mode_vbox = create_mainwin_searchmode();
	  gtk_box_pack_start(GTK_BOX(main_vbox), mode_vbox, TRUE, TRUE, 0);
	  focusbox = gtk_object_get_data(GTK_OBJECT(mode_vbox), "focus");
	  gtk_widget_grab_focus(focusbox);

	  cur_mode = SEARCH_MODE;
     }

}


void mode_browse_selected(GtkWidget *widget, GtkWidget *mainwin)
{
     GtkWidget *focusbox;

     if(cur_mode != BROWSE_MODE) {
	  /* clean up search mode */

	  if(cur_resultset) {
	       free_resultset(cur_resultset);
	       cur_resultset = NULL;
	  }

	  if(main_clist) {
	       gtk_clist_clear(GTK_CLIST(main_clist));
	       gtk_widget_destroy(main_clist);
	       main_clist = NULL;
	  }

	  gtk_widget_destroy(mode_vbox);

	  statusbar_msg("");

	  mode_vbox = create_mainwin_browsemode();
	  gtk_box_pack_start(GTK_BOX(main_vbox), mode_vbox, TRUE, TRUE, 0);
	  focusbox = gtk_object_get_data(GTK_OBJECT(mode_vbox), "focus");
	  gtk_widget_grab_focus(focusbox);

	  cur_mode = BROWSE_MODE;
     }

}


GtkWidget *create_mainwin_searchmode(void)
{
     GtkWidget *searchmode_vbox, *hbox1, *scrwin;
     GtkWidget *searchtype_om, *searchtype_menu, *searchtype_mi;
     GtkWidget *stinput;
     GtkWidget *servcombo;
     GtkWidget *findbutton;
     GSList *group;

     searchmode_vbox = gtk_vbox_new(FALSE, 0);
     gtk_widget_show(searchmode_vbox);

     hbox1 = gtk_hbox_new(FALSE, 0);
     gtk_widget_show(hbox1);
     gtk_box_pack_start(GTK_BOX(searchmode_vbox), hbox1, FALSE, FALSE, 3);

     /* search/filter dropdown box */
     searchtype_menu = gtk_menu_new();
     searchtype_om = gtk_option_menu_new();

     searchtype_mi = gtk_radio_menu_item_new_with_label(NULL, LABEL_ST_SEARCH);
     group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(searchtype_mi));
     gtk_signal_connect_object(GTK_OBJECT(searchtype_mi), "activate",
			       GTK_SIGNAL_FUNC(searchtype_changed_callback),
			       (gpointer) LABEL_ST_SEARCH);
     gtk_menu_append(GTK_MENU(searchtype_menu), searchtype_mi);
     gtk_widget_show(searchtype_mi);

     searchtype_mi = gtk_radio_menu_item_new_with_label(group, LABEL_ST_FILTER);
     gtk_signal_connect_object(GTK_OBJECT(searchtype_mi), "activate",
			       GTK_SIGNAL_FUNC(searchtype_changed_callback),
			       (gpointer) LABEL_ST_FILTER);
     gtk_menu_append(GTK_MENU(searchtype_menu), searchtype_mi);
     gtk_widget_show(searchtype_mi);

     gtk_option_menu_set_menu(GTK_OPTION_MENU(searchtype_om), searchtype_menu);
     gtk_box_pack_start(GTK_BOX(hbox1), searchtype_om, FALSE, FALSE, 0);
     gtk_widget_show(searchtype_om);

     /* searchterm entry box */
     stinput = gtk_entry_new();
     gtk_widget_show(stinput);
     gtk_signal_connect_object(GTK_OBJECT(stinput), "activate",
			       GTK_SIGNAL_FUNC(findbutton_pressed_callback),
			       (gpointer) stinput);
     gtk_box_pack_start(GTK_BOX(hbox1), stinput, TRUE, TRUE, 6);
     GTK_WIDGET_SET_FLAGS(stinput, GTK_CAN_FOCUS);
     GTK_WIDGET_SET_FLAGS(stinput, GTK_CAN_DEFAULT);
     GTK_WIDGET_SET_FLAGS(stinput, GTK_RECEIVES_DEFAULT);
     gtk_widget_grab_default(stinput);
     gtk_object_set_data(GTK_OBJECT(searchmode_vbox), "focus", stinput);

     /* LDAP server combo box */
     servcombo = gtk_combo_new();
     serverlist_combo = servcombo;
     fill_serverlist_combo();

     gtk_box_pack_start(GTK_BOX(hbox1), servcombo, FALSE, TRUE, 0);
     gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(servcombo)->entry), FALSE);
     gtk_signal_connect(GTK_OBJECT(GTK_COMBO(servcombo)->entry), "changed",
			GTK_SIGNAL_FUNC(servername_changed_callback),
			GTK_ENTRY(GTK_COMBO(servcombo)->entry));
     GTK_WIDGET_UNSET_FLAGS(GTK_ENTRY(GTK_COMBO(servcombo)->entry),
			    GTK_CAN_FOCUS);
     /* gtkcombo.h says don't touch this but... */
     GTK_WIDGET_UNSET_FLAGS(GTK_BUTTON(GTK_COMBO(servcombo)->button),
			    GTK_CAN_FOCUS);
     gtk_widget_show(servcombo);

     /* find button */
     findbutton = gtk_button_new_with_label(" Find ");
     GTK_WIDGET_UNSET_FLAGS(findbutton, GTK_CAN_FOCUS);
     gtk_widget_show(findbutton);
     gtk_box_pack_start(GTK_BOX(hbox1), findbutton, FALSE, TRUE, 6);
     gtk_container_border_width(GTK_CONTAINER (findbutton), 0);
     gtk_signal_connect_object(GTK_OBJECT(findbutton), "pressed",
			       GTK_SIGNAL_FUNC(findbutton_pressed_callback),
			       GTK_OBJECT(stinput));

     /* dummy clist, gets replaced on first search */
     scrwin = gtk_scrolled_window_new(NULL, NULL);
     gtk_widget_show(scrwin);
     gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrwin),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
     main_clist = gtk_clist_new(1);
     gtk_object_set_data(GTK_OBJECT(main_clist), "scrwin", scrwin);
     gtk_clist_set_column_title(GTK_CLIST(main_clist), 0, "");
     gtk_clist_column_titles_show(GTK_CLIST(main_clist));
     gtk_widget_show(main_clist);
     gtk_clist_column_titles_passive(GTK_CLIST(main_clist));

     gtk_container_add(GTK_CONTAINER(scrwin), main_clist);
     gtk_box_pack_start(GTK_BOX(searchmode_vbox), scrwin, TRUE, TRUE, 0);

     return(searchmode_vbox);
}


void create_license_window(void)
{
     GtkWidget *window, *vbox1, *hbox, *vbox2, *text;
     GtkWidget *vscroll, *ok_button;
     GtkStyle *license_style;

     window = gtk_dialog_new();
     gtk_object_set_data(GTK_OBJECT(window), "close_func",
			 close_license_window);
     gtk_widget_set_usize(window, 540, 400);
     gtk_window_set_title(GTK_WINDOW(window), "License");

     vbox1 = GTK_DIALOG(window)->vbox;
     gtk_container_border_width(GTK_CONTAINER(vbox1), 20);
     gtk_widget_show(vbox1);

     hbox = gtk_hbox_new(FALSE, 0);
     gtk_widget_show(hbox);
     gtk_box_pack_start(GTK_BOX(vbox1), hbox, TRUE, TRUE, 0);

     license_style = gtk_style_new();
     license_style->font = gdk_font_load("fixed");
     gtk_object_set_data(GTK_OBJECT(window), "style", license_style);

     text = gtk_text_new(NULL, NULL);
     gtk_widget_set_style(text, license_style);
     gtk_text_set_point(GTK_TEXT(text), 0);
     gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		     license, strlen(license));
     gtk_widget_show(text);
     gtk_text_set_editable(GTK_TEXT(text), FALSE);
     gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 00);

     vscroll = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
     gtk_box_pack_start(GTK_BOX(hbox), vscroll, FALSE, FALSE, 0);
     gtk_widget_show(vscroll);

     vbox2 = GTK_DIALOG(window)->action_area;
     gtk_widget_show(vbox2);
     ok_button = gtk_button_new_with_label("    OK    ");
     gtk_widget_show(ok_button);
     gtk_box_pack_start(GTK_BOX(vbox2), ok_button,
			FALSE, FALSE, 0);
     GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
     gtk_widget_grab_default(ok_button);
     gtk_signal_connect_object(GTK_OBJECT(window), "delete_event",
			       (GtkSignalFunc) close_license_window,
			       GTK_OBJECT(window));
     gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
			       (GtkSignalFunc) close_license_window,
			       GTK_OBJECT(window));
     gtk_signal_connect_object(GTK_OBJECT(window), "key_press_event",
			       (GtkSignalFunc) func_on_esc,
			       (gpointer) window);


     gtk_widget_show(window);

}


void close_license_window(GtkWidget *window)
{
     GtkStyle *style;

     style = gtk_object_get_data(GTK_OBJECT(window), "style");
     gtk_style_unref(style);
     gtk_widget_destroy(window);

}


GtkWidget *create_about_window(void)
{
     GtkWidget *about_window;
     GtkWidget *dialog_vbox2, *hbox;
     GtkWidget *about_label;
     GtkWidget *dialog_action_area2;
     GtkWidget *about_ok_button;
     GtkWidget *pixmap;
     GdkPixmap *gq_icon;
     GdkBitmap *gq_icon_mask;
     char title[32], about_text[256];

     about_window = gtk_dialog_new();
     gtk_widget_realize(GTK_WIDGET(about_window));
     gtk_container_border_width(GTK_CONTAINER(about_window), 12);
     sprintf(title, "About %s", PACKAGE);
     gtk_window_set_title(GTK_WINDOW(about_window), title);
     gtk_window_set_policy(GTK_WINDOW(about_window), FALSE, FALSE, FALSE);

     dialog_vbox2 = GTK_DIALOG(about_window)->vbox;
     gtk_widget_show(dialog_vbox2);

     hbox = gtk_hbox_new(FALSE, 0);
     gtk_widget_show(hbox);
     gtk_box_pack_start(GTK_BOX(dialog_vbox2), hbox, TRUE, TRUE, 10);

     gq_icon = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(about_window)->window,
					    &gq_icon_mask,
					    &about_window->style->white,
					    logo_xpm);
     pixmap = gtk_pixmap_new(gq_icon, gq_icon_mask);
     gtk_widget_show(pixmap);
     gtk_box_pack_start(GTK_BOX(hbox), pixmap, TRUE, TRUE, 10);

     sprintf(about_text, "%s\n\n\n%s", PACKAGEVERSION, about_blurb);
     about_label = gtk_label_new(about_text);
     gtk_widget_show(about_label);
     gtk_box_pack_start(GTK_BOX(hbox), about_label, FALSE, FALSE, 4);

     dialog_action_area2 = GTK_DIALOG(about_window)->action_area;
     gtk_container_border_width(GTK_CONTAINER(dialog_action_area2), 10);
     gtk_widget_show(dialog_action_area2);

     about_ok_button = gtk_button_new_with_label("    OK    ");
     gtk_widget_show(about_ok_button);
     gtk_box_pack_start(GTK_BOX(dialog_action_area2), about_ok_button,
			TRUE, FALSE, 0);
     GTK_WIDGET_SET_FLAGS(about_ok_button, GTK_CAN_DEFAULT);
     gtk_widget_grab_default(about_ok_button);
     gtk_container_border_width(GTK_CONTAINER(about_ok_button), 7);
     gtk_signal_connect_object(GTK_OBJECT(about_ok_button), "clicked",
			       GTK_SIGNAL_FUNC(gtk_widget_destroy),
			       GTK_OBJECT(about_window));

     gtk_signal_connect_object(GTK_OBJECT(about_window), "key_press_event",
			       GTK_SIGNAL_FUNC(close_on_esc), (gpointer) about_window);

     gtk_widget_show(about_window);

     return(about_window);
}


gboolean ctrl_b_hack(GtkWidget *widget, GdkEventKey *event, gpointer obj)
{

     if(event && event->type == GDK_KEY_PRESS &&
	event->state & GDK_CONTROL_MASK &&
	event->keyval == GDK_b) {
	  gtk_signal_emit_by_name(GTK_OBJECT(obj), "activate");
	  gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
     }

     return(TRUE);
}

