/**************************************************************************** 
** File: ah.c
**
** Author: Mike Borella
**
** Dump AH payload
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "config.h"
#include "ah.h"
#include "ip.h" /* for header number dependencies - fix later */
#include "tcp.h"
#include "udp.h"
#include "icmp.h"
#include "esp.h"
#include "addrtoname.h"

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_ah()
**
** Parse AH packet and dump fields.
**
**----------------------------------------------------------------------------
*/

void dump_ah(u_char *bp, int length)
{
  u_char *ep = bp + length;
  AHHdr *ah;
  int len;

  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  ah = (AHHdr *) bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        AH Header\n");
  printf("-----------------------------------------------------------------\n");
  
  printf("Next header:            %d\n", ah->next_header);

  /*
   * Calculate length of AH in bytes, not wacky 32-bit words /w offset
   */

  len = (ah->length+2)*4;
  printf("Length:                 %d\n", len);
  printf("SPI:                    %d\n", ntohl(ah->spi));
  printf("Sequence number:        %d\n", ntohl(ah->seqno));

  printf("Authentication data:    ");
  print_char2hex(bp + 12, len - 12);

  bp = bp + len;
  length = length - len;
  switch (ah->next_header) 
    {
    case TCP_NEXT_HEADER:
      dump_tcp(bp, length);
      break;
      
    case UDP_NEXT_HEADER:
      dump_udp(bp, length);
      break;
      
    case ICMP_NEXT_HEADER:
      dump_icmp(bp);
      break; 
      
    case IP_NEXT_HEADER:
      dump_ip(bp, length);
      break; 
      
    case ESP_NEXT_HEADER:
      dump_esp(bp, length);
      break;
      
    case AH_NEXT_HEADER:
      dump_ah(bp, length);
      break;
      
    default:
      break;
    }

}
