/**************************************************************************** 
** File: dhcp.h
**
** Author: Mike Borella
**
** Comments: Structure of DHCP packets
**
*****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define DHCP_BOOTREQUEST 1
#define DHCP_BOOTREPLY  2

#define BOOTP_COOKIE 0x63825363


#define DHCP_OPT_PAD              0
#define DHCP_OPT_NETMASK          1
#define DHCP_OPT_TIMEOFFSET       2
#define DHCP_OPT_ROUTER           3
#define DHCP_OPT_TIMESERVER       4
#define DHCP_OPT_NAMESERVER       5
#define DHCP_OPT_DNS              6
#define DHCP_OPT_LOGSERVER        7
#define DHCP_OPT_COOKIESERVER     8
#define DHCP_OPT_LPRSERVER        9
#define DHCP_OPT_IMPRESSSERVER    10
#define DHCP_OPT_RESLOCSERVER     11
#define DHCP_OPT_HOSTNAME         12
#define DHCP_OPT_BOOTFILESIZE     13
#define DHCP_OPT_MERITDUMP        14
#define DHCP_OPT_DOMAINNAME       15
#define DHCP_OPT_SWAPSERVER       16
#define DHCP_OPT_ROOTPATH         17
#define DHCP_OPT_EXTSPATH         18
#define DHCP_OPT_IPFORWARD        19
#define DHCP_OPT_NONLOCALSR       20
#define DHCP_OPT_POLICYFILTER     21
#define DHCP_OPT_MAXREASSEMBLE    22
#define DHCP_OPT_IPTTL            23
#define DHCP_OPT_PATHMTUAGING     24
#define DHCP_OPT_PATHMTUPLATEAU   25
#define DHCP_OPT_INTERFACEMTU     26
#define DHCP_OPT_SUBNETSLOCAL     27
#define DHCP_OPT_BCASTADDRESS     28
#define DHCP_OPT_MASKDISCOVERY    29
#define DHCP_OPT_MASKSUPPLIER     30
#define DHCP_OPT_ROUTERDISCOVERY  31
#define DHCP_OPT_ROUTERSOLIC      32
#define DHCP_OPT_STATICROUTE      33
#define DHCP_OPT_TRAILERENCAPS    34
#define DHCP_OPT_ARPTIMEOUT       35
#define DHCP_OPT_ETHERNETENCAPS   36
#define DHCP_OPT_TCPTTL           37
#define DHCP_OPT_TCPKEEPALIVEINT  38
#define DHCP_OPT_TCPKEEPALIVEGRBG 39
#define DHCP_OPT_NISDOMAIN        40
#define DHCP_OPT_NISSERVERS       41
#define DHCP_OPT_NTPSERVERS       42
#define DHCP_OPT_VENDORSPECIFIC   43
#define DHCP_OPT_NETBIOSNAMESERV  44
#define DHCP_OPT_NETBIOSDGDIST    45
#define DHCP_OPT_NETBIOSNODETYPE  46
#define DHCP_OPT_NETBIOSSCOPE     47
#define DHCP_OPT_X11FONTS         48
#define DHCP_OPT_X11DISPLAYMNGR   49
#define DHCP_OPT_REQUESTEDIPADDR  50
#define DHCP_OPT_IPADDRLEASE      51
#define DHCP_OPT_OVERLOAD         52
#define DHCP_OPT_MESSAGETYPE      53
#define DHCP_OPT_SERVERID         54
#define DHCP_OPT_PARAMREQLIST     55
#define DHCP_OPT_MESSAGE          56
#define DHCP_OPT_MAXDHCPMSGSIZE   57
#define DHCP_OPT_RENEWALTIME      58
#define DHCP_OPT_REBINDINGTIME    59
#define DHCP_OPT_VENDORCLASSID    60
#define DHCP_OPT_CLIENTID         61

#define DHCP_OPT_NISPLUSDOMAIN    64
#define DHCP_OPT_NISPLUSSERVERS   65
#define DHCP_OPT_TFTPSERVER       66
#define DHCP_OPT_BOOTFILE         67
#define DHCP_OPT_MOBILEIPHOME     68
#define DHCP_OPT_SMTPSERVER       69
#define DHCP_OPT_POP3SERVER       70
#define DHCP_OPT_NNTPSERVER       71
#define DHCP_OPT_WWWSERVER        72
#define DHCP_OPT_FINGERSERVER     73
#define DHCP_OPT_IRCSERVER        74
#define DHCP_OPT_STSERVER         75
#define DHCP_OPT_STDASERVER       76

#define DHCP_OPT_END              255

#define DHCP_MAX_HOSTNAME         64

/*
 * DHCP header
 */

typedef struct _DHCPHdr
{
#if defined(WORDS_BIGENDIAN)
  u_int8_t hops;
  u_int8_t hlen;
  u_int8_t htype;
  u_int8_t op;
#else
  u_int8_t op;
  u_int8_t htype;
  u_int8_t hlen;
  u_int8_t hops;
#endif
  u_int32_t xid;
  u_int16_t secs;
  u_int16_t flags;
  u_int32_t ciaddr;
  u_int32_t yiaddr;
  u_int32_t siaddr;
  u_int32_t giaddr;
  char chaddr [16];
  char sname [64];
  char file [128];
} DHCPHdr;

void dump_dhcp(u_char *bp, int length);
