/**************************************************************************** 
** File: payload.c
**
** Author: Mike Borella
**
** Comments: Dump packet payload
**
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include "config.h"
#include "payload.h"

#define BUF_SIZE 128

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_payload()
**
** Dump printable portions of packet payload
**
**----------------------------------------------------------------------------
*/

void dump_payload(u_char *bp, int length)
{
  u_char *ep = bp + length;
  char *buf_ptr, *buf_end;
  int col;
  int i;
  char hexbuf[BUF_SIZE], charbuf[BUF_SIZE];


  /*
   * Make sure we don't run off the end of the packet
   */

  if (ep > packet_end) 
    ep = packet_end;

  printf("-----------------------------------------------------------------\n");

  buf_ptr = bp;
  buf_end = ep;

  do
    {
      col = 0;
      memset(hexbuf, 0, BUF_SIZE);
      memset(charbuf, 0, BUF_SIZE);

      for(i=0;i<16;i++)
	{
	  if(buf_ptr < buf_end)
            {
	      snprintf(hexbuf+(i*3), BUF_SIZE-1,"%.2X ",buf_ptr[0] & 0xFF);
	      
	      if(*buf_ptr > 0x1F && *buf_ptr < 0x7E)
		snprintf(charbuf+i+col, BUF_SIZE-1,"%c",buf_ptr[0]);
	      else
		snprintf(charbuf+i+col, BUF_SIZE-1, ".");
	      
	      buf_ptr++;
            }
	}
      printf("%-48s %s\n",hexbuf,charbuf);
    }
  while(buf_ptr < buf_end);
}
