/*
 sample.c : sample plugin for irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "sample.h"

/* Text formats, can be overridden by themes */
static FORMAT_REC formats[] =
{
    /* ---- */
    { NULL, "Sample plugin", 0 },

    { "start", "Sample plugin loaded", 0 },
    { "stop", "Sample plugin unloaded", 0 },

    { NULL, NULL }
};

enum
{
    PLUGTXT_START,
    PLUGTXT_STOP
};

static PLUGIN_REC *plug;

static gint sample_func(gchar *args)
{
    PLUGIN_DATA *data = plug->data;

    printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, data->sampletext);
    printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE,
              "Arguments: %s (in channel %s)", args, cur_channel->name);

    return FALSE;
}

gchar *plugin_description(void)
{
    return "Just a sample plugin";
}

gint plugin_version(void)
{
    return PLUGIN_LAYER_VERSION;
}

/* If we call plugin_deinit() in this code, it doesn't necessarily point to
   _THIS_ module's plugin_deinit() but instead some other module's.. So,
   we create static deinit() function which should be used..

   Actually this isn't needed in this module since it never calls
   plugin_deinit(), but this is a sample module after all... */
static void deinit(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    if (data->gui == IRSSI_GUI_GTK || data->gui == IRSSI_GUI_GNOME)
    {
	/* deinitialize gtk part of the plugin */
	plugin_sample_gtk_deinit(plugin);
    }

    if (data->loaded)
	printformat_plugin(NULL, NULL, MSGLEVEL_CLIENTNOTICE, plugin, PLUGTXT_STOP);
    plugin_sample_setup_deinit(plugin);

    if (data->sampletext != NULL) g_free(data->sampletext);
    g_free(data);
}


void plugin_deinit(PLUGIN_REC *plugin)
{
    deinit(plugin);
}

gboolean plugin_init(gint gui, PLUGIN_REC *plugin, gchar *args)
{
    PLUGIN_DATA *data;

    /* create PLUGIN_DATA record */
    plug = plugin;
    plugin->data = data = g_new0(PLUGIN_DATA, 1);
    data->plugin = plugin;
    data->gui = gui;

    /* load plugin settings */
    plugin_sample_setup_init(plugin);
    if (args != NULL && *args != '\0')
    {
        g_free(data->sampletext);
        data->sampletext = g_strdup(args);
    }

    /* initialize plugin specific text formats for printformat_plugin() */
    printformat_plugin_init(plugin, formats);

    /* bind /sample */
    plugin_bind(plugin, "command sample", (SIGNAL_FUNC) sample_func, FALSE);

    if (gui == IRSSI_GUI_GTK || gui == IRSSI_GUI_GNOME)
    {
	/* load gtk part of the plugin */
	if (!plugin_sample_gtk_init(plugin))
	{
	    deinit(plugin);
	    return FALSE;
	}
    }

    /* print the plugin initialized message */
    printformat_plugin(NULL, NULL, MSGLEVEL_CLIENTNOTICE, plugin, PLUGTXT_START);

    data->loaded = TRUE;
    return TRUE;
}
