/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "proc.h"
#include "defines.h"

extern int nb_leds;
extern led leds[NBLEDS_MAX];

void led_print(int n);
void led_set_properties(int n, int iid, int cid);
void led_new_properties(int n, int iid, int cid);
void led_update_objects(int n);
void led_update_value(int n, u_int64_t newvalue, int check);
void led_update_state(int n, int lit);
void led_update_img(int n);
void led_create_objects();
GtkWidget *led_create_widget(int n);
void led_destroy_widget(int n);
GtkWidget *led_get_widget(int n);
void led_config_load(int n);
void led_config_save(int n);

void leds_create_widget();
void leds_destroy_widget();
void leds_config_load();
void leds_config_save();
