/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#ifdef unicos
#include <sys/types.h>
#endif
#include "main.h"

#ifndef RAND_MAX
#define RAND_MAX 2147483647
#endif
#if defined __GNUC__ && defined __GNUC_MINOR__ && __GNUC__ > 1 && __GNUC_MINOR__ > 8
typedef socklen_t UNSIGNED_ARG_INT;
#else
typedef int UNSIGNED_ARG_INT;
#endif


extern void check_bandwidth(size_t);
extern void timing(int, double *, char *);
extern int determine_bit_rate(int, unsigned char *);
extern int check_accepted_hosts(char **, int);


void receive_udps(int strnum, double *ci)
{
#ifdef HAVE_INET6
   struct sockaddr_in6 *sin = &(*statstr)->sin;
   int ret=0;
#else
   struct sockaddr_in *sin = &(*statstr)->sin;
   struct hostent *hp;
#endif
   char reset_timing_ = 1;
   register ssize_t num=0, check=0;
   int sinlen = (*statstr)->sinlen;
   int strlength = (*statstr)->bsize;
   int refused = 0;
   unsigned char str[BIG_BUFSIZE];
   unsigned char *strptr=NULL;
   int length=0;
   
   /*
    * Receive data UDP.
    */
   for (num=1, *ci=0.0; num || refused; *ci+=(double)num) {
      if ((num = recvfrom(s, (void *)str, strlength, 0, (struct sockaddr *)sin, (UNSIGNED_ARG_INT *)&sinlen)) < 0) {
         if (slfp) fprintf(slfp, "** recvfrom: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_RECEIVE_ERR);
      }
      if (*_CLIENTHOSTNAME_ || reset_timing_) {
         if (*_CLIENTHOSTNAME_ || (slfp && !(*(statstr+strnum))->first)) {
#ifdef HAVE_INET6
            if (!(*statstr)->multicast) {
               if ((ret = getnameinfo((struct sockaddr *)sin, sinlen, \
                  (*(statstr+strnum))->REMOTEHOSTNAME, SONAME*sizeof(char), NULL, 0, 0))) {
                  if (!inet_ntop(sin->sin6_family, sin->sin6_addr.s6_addr, (*(statstr+strnum))->REMOTEHOSTNAME, INET6_ADDRSTRLEN)) {
                     if (slfp) fprintf(slfp, "Cannot convert binary address string.\n");
                     break;
                  }
                  else strcpy((*(statstr+strnum))->REMOTEIP, (*(statstr+strnum))->REMOTEHOSTNAME);
               }
               else if (!inet_ntop(sin->sin6_family, sin->sin6_addr.s6_addr, (*(statstr+strnum))->REMOTEIP, INET6_ADDRSTRLEN)) {
                  if (slfp) fprintf(slfp, "Cannot convert binary address string.\n");
                  break;
               }
               if (*_CLIENTHOSTNAME_ && !check_accepted_hosts(_CLIENTHOSTNAME_, strnum)) {
                  if (slfp) fprintf(slfp, "\b** Connection to %s (%s) refused.\n", \
                  (*(statstr+strnum))->REMOTEHOSTNAME, (*(statstr+strnum))->REMOTEIP);
                  num = 0;
                  refused = 1;
                  continue;
               }
               else refused=0;
            }
            else {
               strcpy((*(statstr+strnum))->REMOTEHOSTNAME, (*statstr)->_MULTICASTGROUP_);
            }
#else
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
            if (!(*statstr)->multicast) {
#endif
               if ((hp = gethostbyaddr((char *)&sin->sin_addr, sizeof(sin->sin_addr), AF_INET)) == 0) {
                  strcpy((*(statstr+strnum))->REMOTEHOSTNAME, inet_ntoa(sin->sin_addr));
                  strcpy((*(statstr+strnum))->REMOTEIP, (*(statstr+strnum))->REMOTEHOSTNAME);
               }
               else {
                  strcpy((*(statstr+strnum))->REMOTEHOSTNAME, hp->h_name);
                  strcpy((*(statstr+strnum))->REMOTEIP, inet_ntoa(sin->sin_addr));
               }
               if (*_CLIENTHOSTNAME_ && !check_accepted_hosts(_CLIENTHOSTNAME_, strnum)) {
                  if (slfp) fprintf(slfp, "\b** Connection to %s (%s) refused.\n", \
                  (*(statstr+strnum))->REMOTEHOSTNAME, (*(statstr+strnum))->REMOTEIP);
                  num = 0;
                  refused = 1;
                  continue;
               }
               else refused=0;
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
            }
            else {
               strcpy((*(statstr+strnum))->REMOTEHOSTNAME, (*statstr)->_MULTICASTGROUP_);
            }
#endif
#endif

            if (slfp && !(*(statstr+strnum))->first) {
               timing(strnum, ci, NULL);
               (*(statstr+strnum))->first = BIT_ONE;
               if (slfp) fprintf(slfp, "* Receiving datagrams from %s.\n\r", \
                         (*(statstr+strnum))->REMOTEHOSTNAME);
            }
         }
         else if (slfp && ((*(statstr+strnum))->first & BIT_ONE)) {
            timing(strnum, ci, NULL);
            reset_timing_ = 0;
#ifdef USE_POSIX_THREAD
            CHILDNUM++;
#else
            (*statstr)->no_clients++;
#endif
         }
      }
#ifdef Linux
      if ((*statstr)->show_bytes) fprintf(slfp, "\r* Bytes: %.0f.", *ci);
#endif
      if (!(*statstr)->testbsize) {
         for (check=0, strptr=str, length=num; length; length-=check, strptr += check) {
            if ((check = write(1, strptr, length)) < 0) {
               if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_OUTPUT_ERR);
            }
         }
      }
   }
   (*(statstr+strnum))->first = BIT_TWO; 
}


void send_udps(int ft, double *ci)
{
#ifdef HAVE_INET6
   struct sockaddr_in6 *sin = (struct sockaddr_in6 *)(*statstr)->adin->ai_addr;
#else
   struct sockaddr_in *sin = &(*statstr)->sin;
#endif
   int num=0, nn=0;
   double sum=0;
   unsigned long i=0;
   double count=0, max=(*statstr)->testbsize;
   int sinlen=(*statstr)->sinlen;
   int strlength=(*statstr)->bsize;
   int rand_count=0;
   char *tbuffer=NULL, *tmp=NULL;
   unsigned char str[BUFSIZE];

   if (max) {
      if ((*statstr)->rename) (*statstr)->_RECURS_ = 1;

      /*
       * Select either a random string or a
       * string which bytes are set to zero.
       */
      MEM_CHECK((tbuffer = (char *)calloc(strlength, sizeof(char))));
      if ((*statstr)->_RECURS_) {
         srand(strlength);
         for (tmp=tbuffer, rand_count=0; rand_count < strlength; rand_count++, tmp++) {
            *tmp = 1 + (int) (255.0 * rand() / (RAND_MAX + 1.0));
         }
      }

      for (count=0.0; count < max; count+=(double)nn, check_bandwidth(nn)) {
         if (max - count < (double)strlength) strlength = (int)(max - count);
         if ((nn = sendto(s, tbuffer, strlength, 0, (struct sockaddr *)sin, sinlen)) < 0) {
            if (slfp) fprintf(slfp, "\n\r** sendto: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_WRITETONET_ERR);
         }
         if ((*statstr)->rename) {
            for (tmp=tbuffer, rand_count=0; rand_count < strlength; rand_count++, tmp++) {
               *tmp = 1 + (int) (255.0 * rand() / (RAND_MAX + 1.0));
            }
         }
      }
      sendto(s, tbuffer, 0, 0, (struct sockaddr *)sin, sinlen);
      free(tbuffer);
   }
   else {
      /*
       * Send data via UDP.
       */
#if defined HAVE_FASYNC
      (*statstr)->new_line = 1;
      (*statstr)->key_pressed = 0;
#endif
      for ((*statstr)->first=1, num=1; num; count+=(double)nn, check_bandwidth(nn), i++) {
#if defined HAVE_FASYNC
         if (!(*statstr)->key_pressed) {
#endif
            if ((num = read(ft, str, strlength)) < 0) {
               if (slfp) fprintf(slfp, "\n\r** read: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_READ_DISK_ERR);
            }
            if ((*statstr)->first && (*statstr)->autobitrate) {
               if (determine_bit_rate(num, str)) {
                  if ((*statstr)->verbose && slfp) {
#ifdef HAVE_FASYNC
                     if ((*statstr)->new_line) fputc('\n', slfp);
#endif
                     fprintf(slfp, "\r* Bandwidth set to %lu.", (*statstr)->_BANDWIDTH_);
#ifdef HAVE_FASYNC
                     (*statstr)->new_line = 0;
#endif
                  }
               }
            }
            if ((*statstr)->file_skipped) {
               *ci = count;
               return;
            }
            if ((*statstr)->throw_away && !(i % ((*statstr)->throw_away))) {
               i = 0; nn = num; continue;
            }
            if ((*statstr)->autobitrate && !num) {
               nn = 0;
               continue;
            }
            if ((nn = sendto(s, (void *)str, num, 0, (struct sockaddr *)sin, sinlen)) < 0) {
               if (slfp) fprintf(slfp, "\n\r** sendto: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_WRITETONET_ERR);
            }
            if ((*statstr)->show_percent) {
               sum += (double)nn;
               fprintf(slfp, "\r[% 3d%%]", (int)(((double) sum / (double) (*statstr)->mul) * 100.0));
            }
#if defined HAVE_FASYNC
         }
         else {
            (*statstr)->key_pressed = 0;
            nn = 0;
         }
#endif
      }
   }
   *ci = count;
}
