/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*********************
**********************  Includes
*********************/

#include <config.h>

#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

#include "debug.h"
#include "message-send.h"
#include "queue-item-send.h"

/*********************
**********************  Defines / Enumerated types
*********************/

/*********************
**********************  Macros
*********************/

/*********************
**********************  Structures / Typedefs
*********************/

/*********************
**********************  Private Function Prototypes
*********************/

static gint queue_item_send_run (QueueItem* item);

static gchar* queue_item_send_describe (const StatusItem* item);

/*********************
**********************  Variables
*********************/

/***********
************  Extern
***********/

/***********
************  Public
***********/

/***********
************  Private
***********/

/*********************
**********************  BEGINNING OF SOURCE
*********************/

/************
*************  PUBLIC ROUTINES
************/

/*****
******
*****/

PanObject*
queue_item_send_new (server_data *sdata, Message *msg)
{
	QueueItemSend *item = g_new0 (QueueItemSend, 1);

	queue_item_constructor (QUEUE_ITEM(item),
		queue_item_destructor,
		queue_item_send_describe,
		queue_item_send_run, sdata, TRUE, TRUE);

	item->smtp_socket = NULL;
	item->msg = msg;

	return PAN_OBJECT(item);
}

/*****
******
*****/

static gchar*
queue_item_send_describe (const StatusItem* item)
{
	return g_strdup (_("Sending Message"));
}


static gint
queue_item_send_run (QueueItem* item)
{
	return message_send (
		STATUS_ITEM(item),
		QUEUE_ITEM(item)->sock, 
		QUEUE_ITEM_SEND(item)->msg);
}
