/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TEXT_H__
#define __TEXT_H__

#include "message.h"
#include "pan-callback.h"

extern gboolean show_all_headers_in_body;
extern article_data* current_article;

extern GtkWidget* text_create (void);
extern void text_select_all (void);
extern gboolean rot13_enabled;
extern void text_refresh (void);

/**
 * called whenever the text window's show-all-headers-in-body state changes.
 *
 * @param call_object the text widget
 * @param call_arg a boolean-turned-pointer telling whether show-all is on/off
 */
extern PanCallback* text_show_all_headers_changed;


/**
 * This will display the message in the appropriate place
 * if it exists in acache.  If it's not in the acache, this
 * method does nothing.
 * @param Message THIS MESSAGE IS FREED BY text_update().
 */
extern void text_update (Message *msg);

extern void text_set_from_message_id (
	const server_data *sdata,
	group_data *gdata,
	const gchar* message_id,
	MessageWindowType type,
	gboolean needs_window);

extern void text_set_show_all_headers_in_body (gboolean on);

extern void text_page_down (void);
extern void text_page_up (void);

#endif /* __TEXT_H__ */
