#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

#include "next_group.xpm"
#include "prev_group.xpm"
#include "next_unseen.xpm"
#include "prev_unseen.xpm"

#include "npstringarray.h"
#include "npfile.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

#include "peruser.xpm"

extern GtkWidget *toplevel_window;
extern NP_Collections *collections_p;

NP_Collections::NP_Collections( int argc, char **argv )
{
   collections_p = this;
   tree_widget = NULL;
   selected_item = NULL;
   undelete_window = NULL;
   button = summary_pid = compose_pid = launcher_pid = 0;
   search_position = -1;
   search_line = 0;
   summary_file = feedback_file = NULL;
   master_group_list = NULL;
   feedback_id = -1;
   undelete_selection = -1;

   message_window = message_label = message_button = NULL;
   *search_text ='\0';

   tree_nodes = NULL;
   total_nodes = child_pid = callbacks_disabled = search_shown = 0;

   gtk_init( &argc, &argv );

   signal( SIGCHLD, SIGCHLD_handler );
   signal( SIGUSR1, SIGUSR1_handler );
   signal( SIGUSR2, SIGUSR2_handler );
   signal( SIGPIPE, SIGPIPE_handler );
   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );
   signal( SIGSEGV, signal_handler );

   home = getenv( "HOME" );
   char buffer[ 1024 ], second_buffer[ 1024 ];

   snprintf( buffer, sizeof buffer, 
             "rm -f %s/.*:lock %s/.peruser_spool/.*:lock", home, home );
   system( buffer );

   snprintf( buffer, sizeof buffer, "%s/.npcollections:pid", home );
   FILE *file;
   if (( file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( second_buffer, sizeof second_buffer, file ) == NULL )
         exit( 0 );

      fclose( file );
      
      pid_t pid = atoi( second_buffer );
      if ( !( pid > 0 && kill( pid, SIGUSR2 ) && errno == ESRCH ))
         exit( 0 );
   }

   if (( file = fopen( buffer, "w" )) == NULL )
   {
      perror( "fopen" );
      exit( 1 );
   }
   fprintf( file, "%d", getpid() );
   fclose( file );

   // window

   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   toplevel_window = window;
   gtk_window_set_policy( GTK_WINDOW( window ), TRUE, TRUE, TRUE );

   accel_group = gtk_accel_group_new();
   gtk_window_add_accel_group( GTK_WINDOW( window ), accel_group );

   gtk_widget_realize( window );
   gtk_window_set_title( GTK_WINDOW( window ), "News Peruser Collections" );
   gtk_container_border_width( GTK_CONTAINER( window ), 0 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( exit_button_callback ), this );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( exit_button_callback ), NULL );

   // tree styles

   read_col.pixel = 0;
   read_col.red = 0x3300;
   read_col.green = 0x3300;
   read_col.blue = 0x3300;

   empty_col.pixel = 0;
   empty_col.red = 0x9900;
   empty_col.green = 0x9900;
   empty_col.blue = 0x9900;

   unread_style = gtk_style_copy( GTK_WIDGET( window )->style );
   gdk_font_unref( unread_style->font );
   unread_style->font = 
      gdk_font_load( "-*-helvetica-bold-r-*-*-*-110-*-*-*-*-*-*" );
   if ( unread_style->font == NULL )
      unread_style->font = gdk_font_load( "fixed" );

   empty_style = gtk_style_copy( GTK_WIDGET( window )->style );
   gdk_font_unref( empty_style->font );
   empty_style->font = 
      gdk_font_load( "-*-helvetica-medium-r-*-*-*-110-*-*-*-*-*-*" );
   if ( empty_style->font == NULL )
      empty_style->font = gdk_font_load( "fixed" );

   empty_style->fg[ GTK_STATE_NORMAL ] = empty_col;

   read_style = gtk_style_copy( GTK_WIDGET( window )->style );
   gdk_font_unref( read_style->font );
   read_style->font = 
      gdk_font_load( "-*-helvetica-medium-r-*-*-*-110-*-*-*-*-*-*" );
   if ( read_style->font == NULL )
      read_style->font = gdk_font_load( "fixed" );

   read_style->fg[ GTK_STATE_NORMAL ] = read_col;

   small_style = gtk_style_copy( read_style );

   // vbox

   GtkWidget *vbox = gtk_vbox_new( FALSE, 10 );
   gtk_widget_show( vbox );
   gtk_container_border_width( GTK_CONTAINER( vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( window ), vbox );

   // bottom toolbar frame

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_box_pack_end( GTK_BOX( vbox ), frame, FALSE, FALSE, 0 );

   // bottom toolbar boxes

   GtkWidget *bottom_vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( bottom_vbox );
   gtk_container_border_width( GTK_CONTAINER( bottom_vbox ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), bottom_vbox );

   // frame

   frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_box_pack_end( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );

   // table

   GtkWidget *table = gtk_table_new( 10, 100, FALSE );
   gtk_widget_show( table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );

   // top toolbar frame

   GtkWidget *top_toolbar_frame = gtk_frame_new( NULL );
   gtk_widget_show( top_toolbar_frame );
   gtk_box_pack_end( GTK_BOX( vbox ), top_toolbar_frame, FALSE, FALSE, 0 );

   // top_vbox

   GtkWidget *top_vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( top_vbox );
   gtk_container_add( GTK_CONTAINER( top_toolbar_frame ), top_vbox );

   // top inner hbox 

   GtkWidget *hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( top_vbox ), hbox, FALSE, FALSE, 10 );

   // pixmaps

   GtkStyle *style = gtk_widget_get_default_style();
   GdkBitmap *mask;
   GdkPixmap *pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    peruser_xpm );
   pixmapwid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( pixmapwid );
   gtk_box_pack_start( GTK_BOX( hbox ), pixmapwid, FALSE, FALSE, 10 );

   // version label

   GtkWidget *label = gtk_label_new( "Copyright 1995-1999 James Bailie" );
   gtk_widget_show( label );
   gtk_widget_set_style( label, small_style );
   gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 20 );

   // second inner hbox

   hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_show( hbox );
   gtk_container_border_width( GTK_CONTAINER( hbox ), 10 );
   gtk_box_pack_start( GTK_BOX( top_vbox ), hbox, FALSE, FALSE, 0 );

   // toolbar

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_box_pack_start( GTK_BOX( hbox ), toolbar, FALSE, FALSE, 0 );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Exit ",
                            "Exit program.", NULL, NULL,
                            GTK_SIGNAL_FUNC( exit_button_callback ), this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Help ",
                            "View some text describing how to use News "
                            "Peruser.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( help_button_callback ), this );


   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   // font button and menu 

   menu = gtk_menu_new();

   first_item = gtk_menu_item_new_with_label( " Small " );
   gtk_widget_show( first_item );
   gtk_object_set_data( GTK_OBJECT( first_item ), "font", ( gpointer)0 );
   gtk_signal_connect( GTK_OBJECT( first_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), first_item );

   second_item = gtk_menu_item_new_with_label( " Medium " );
   gtk_widget_show( second_item );
   gtk_object_set_data( GTK_OBJECT( second_item ), "font", ( gpointer)1 );
   gtk_signal_connect( GTK_OBJECT( second_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), second_item );

   third_item = gtk_menu_item_new_with_label( " Large " );
   gtk_widget_show( third_item );
   gtk_object_set_data( GTK_OBJECT( third_item ), "font" , ( gpointer)2 );
   gtk_signal_connect( GTK_OBJECT( third_item ), "activate",
                       GTK_SIGNAL_FUNC( font_menu_callback ), this );
   gtk_menu_append( GTK_MENU( menu ), third_item );

   font_button = gtk_button_new_with_label( " Fonts " );
   gtk_widget_show( font_button );
   gtk_object_set_data( GTK_OBJECT( font_button ), "object", this );
   gtk_signal_connect_object( GTK_OBJECT( font_button ), "clicked",
                              GTK_SIGNAL_FUNC( fonts_button_callback ),
                              GTK_OBJECT( menu ));

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ), 
                               GTK_TOOLBAR_CHILD_WIDGET,
                               font_button, NULL,
                            "Change the size of the fonts used in the tree.",
                            NULL, NULL, NULL, NULL,
                            GTK_TOOLBAR( toolbar )->num_children );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Undelete ",
                            "Undelete selected deleted messages.",
                            NULL, NULL, 
                            GTK_SIGNAL_FUNC( undelete_button_callback ), this );
   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Helpers ",
                            "Run the helper program launcher.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( launcher_button_callback ), this );
   // scroll

   scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );
   adjustment = 
      gtk_scrolled_window_get_vadjustment( GTK_SCROLLED_WINDOW( scroll ));
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll ),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC );
   gtk_table_attach_defaults( GTK_TABLE( table ), scroll, 0, 10, 2, 100 );

   // bottom toolbar

   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_box_pack_start( GTK_BOX( bottom_vbox ), toolbar, FALSE, FALSE, 0 );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Configure ",
                            "Launch the News Peruser Configuration program.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( configure_button_callback ),
                            this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Pack ",
                            "Remove all of the seen messages from "
                            "newsgroups, determined by the current tree "
                            "selection.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( pack_button_callback ),
                            this );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Expire ",
                            "Remove all of the messages older than the "
                            "configured expiration period, from newsgroups "
                            "determined by the tree selection.", NULL, NULL,
                            GTK_SIGNAL_FUNC( expire_button_callback ),
                            this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Search ",
                            "Search all of the messages of newsgroups "
                            "determined by the current tree selection, "
                            "for matches"
                            " of a specified regular expression",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( search_button_callback ), this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Transfer ",
                            "Transfer messages to and/or from selected "
                            "newsgroups and the appropriate server or "
                            "program.", NULL, NULL,
                            GTK_SIGNAL_FUNC( transfer_button_callback ),
                            this );

   // bottom hbox 

   GtkWidget *bottom_hbox = gtk_hbox_new( FALSE, 0 );
   gtk_widget_set_usize( bottom_hbox, 380, 27 );
   gtk_widget_show( bottom_hbox );
   gtk_box_pack_start( GTK_BOX( bottom_vbox ), bottom_hbox, FALSE, FALSE, 5 );

   tooltips = gtk_tooltips_new();

   left_button = gtk_button_new();
   gtk_widget_show( left_button );
   gtk_signal_connect( GTK_OBJECT( left_button ), "clicked",
                       GTK_SIGNAL_FUNC( left_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( bottom_hbox ), left_button, TRUE, TRUE, 0 );
   gtk_tooltips_set_tip( tooltips, left_button,
                         "Step the selection backward to the"
                         " previous non-empty group in the tree,"
                         " if there is one.", NULL );

   pixmap = gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                          &style->bg[ GTK_STATE_NORMAL ],
                                          prev_group_xpm );
   prev_article_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_article_wid );
   gtk_container_add( GTK_CONTAINER( left_button ), prev_article_wid );

   down_button = gtk_button_new();
   gtk_widget_show( down_button );
   gtk_signal_connect( GTK_OBJECT( down_button ), "clicked",
                       GTK_SIGNAL_FUNC( down_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( bottom_hbox ), down_button, TRUE, TRUE, 0 );
   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    prev_unseen_xpm );
   prev_unread_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( prev_unread_wid );
   gtk_container_add( GTK_CONTAINER( down_button ), prev_unread_wid );
   gtk_tooltips_set_tip( tooltips, down_button,
                         "Step the selection backward to the previous "
                         "group in the tree with unseen articles, "
                         "if there is one.",
                         NULL );

   up_button = gtk_button_new();
   gtk_widget_show( up_button );
   gtk_signal_connect( GTK_OBJECT( up_button ), "clicked",
                       GTK_SIGNAL_FUNC( up_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( bottom_hbox ), up_button, TRUE, TRUE, 0 );

   pixmap =
      gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                    &style->bg[ GTK_STATE_NORMAL ],
                                    next_unseen_xpm );
   next_unread_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_unread_wid );
   gtk_container_add( GTK_CONTAINER( up_button ), next_unread_wid );
   gtk_tooltips_set_tip( tooltips, up_button,
                         "Step the selection forward to the next group "
                         "with unseen messages in the tree, if there is one.",
                         NULL );

   right_button = gtk_button_new();
   gtk_widget_show( right_button );
   gtk_signal_connect( GTK_OBJECT( right_button ), "clicked",
                       GTK_SIGNAL_FUNC( right_button_callback ), this );
   gtk_box_pack_start( GTK_BOX( bottom_hbox ), right_button, TRUE, TRUE, 0 );

   pixmap = gdk_pixmap_create_from_xpm_d( window->window, &mask,
                                          &style->bg[ GTK_STATE_NORMAL ],
                                          next_group_xpm );
   next_article_wid = gtk_pixmap_new( pixmap, mask );
   gtk_widget_show( next_article_wid );
   gtk_container_add( GTK_CONTAINER( right_button ), next_article_wid );
   gtk_tooltips_set_tip( tooltips, right_button,
                         "Step the selection forward to the next non-empty"
                         " group in the tree, if there is one.", NULL );

   set_size();

   item = first_item;
   FILE *font_file;
   snprintf( buffer, sizeof buffer, "%s/.npcollections:font", home );
   if (( font_file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( buffer, sizeof buffer, font_file ) != NULL )
      {
         switch( atoi( buffer ))
         {
            case 0:
               item = first_item;
               break;

            case 1:
               item = second_item;
               break;

            case 2:
               item = third_item;
               break;
         }
      }

      fclose( font_file );
   }

   font_menu_callback( item, this );
   gtk_widget_show( window );

   return;
}
