#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

NP_Collections *collections_p;

void SIGUSR1_handler( int signo )
{
   collections_p->update_tree();

   int total = collections_p->children.get_total();
   if ( total < 0 )
   {
      collections_p->children.print_error();
      return;
   }

   for( int i = 0; i < total; ++i )
   {
      char *p = ( char *)collections_p->children[ i ];
      pid_t pid;
      if ( p == NULL )
      {
         collections_p->children.print_error();
         continue;
      }

      pid = ( pid_t)atoi( p );

      if ( pid )
         kill( pid, SIGUSR1 );
   }

   if ( collections_p->undelete_window != NULL )
      undelete_refresh( collections_p );

   signal( SIGUSR1, SIGUSR1_handler );

   return;
}
