/*
 * Header file diskmbr.h - assorted structure definitions and macros
 * describing standard PC partition table

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _DISKMBR_H
#define _DISKMBR_H

#define MBR_MAGIC		0xAA55

#define PARTITION_UNUSED	0x00
#define PARTITION_ACTIVE	0x80

#define PARTITION_COUNT		4

#define MBR_SECTOR(x)		((x)&0x3F)
#define MBR_CYLINDER(x)		((x)>>8|((x)<<2&0x300))

struct disk_partition {
	unsigned char	status;
	unsigned char	s_head;
	unsigned char	s_cyl_sec[2];
	unsigned char	type;
	unsigned char	e_head;
	unsigned char	e_cyl_sec[2];
	unsigned char	boot_sec[4];
	unsigned char	size[4];
};

struct disk_master_boot_record {
	char			pad[0x1BE];
	struct disk_partition	partition[PARTITION_COUNT];
	unsigned char		magic[2];
};

#endif	/* _DISKMBR_H */
