/* This file defines the setup for the filetypes supported by
 * stdfiletrack.c as well as the filetype support database itself. */

#ifndef FILETYPES_H
#define FILETYPES_H

#include <gtk/gtk.h>

typedef struct 
{
	GtkWidget *sampler;       /* this is a hbox containing all the widgets below */

	GtkWidget *w_suffix;
	GtkWidget *w_tracktype;   /* currently one of data,audio */
   	GtkWidget *w_precache;    /* precache file before writing ? */   
	GtkWidget *w_filter;      /* currently one of bigEndian,littleEndian */
	GtkWidget *w_filtername;  /* filter program like "sox [...]" */
	GtkWidget *w_detectsize;  /* program returning nothing but the tracksize in bytes on stdout */
	GtkWidget *w_sizealg;     /* function calculating the track size */
	
	char suffix[32];          /* the suffix identifying this filetype */
	char tracktype[32];       /* the fields containing the real values after apply */
        int  precache;            /* precache file ? */
	char filter[32];
	char filtername[1024];
	char detectsize[1024];
	char sizealg[1024];
	
} filetypes_filetypeentry;      /* maybe detectsize should also provide some magics to Gnometoaster internal functions */

void filetypes_init();
/* create a new filetype registry entry */
filetypes_filetypeentry *filetypes_entrycreate(char *suffix,
					       char *tracktype,
					       int  precache,
					       char *filter,
					       char *filtername,
					       char *detectsize,
					       char *sizealg);
/* register a filetype */
void filetypes_register(filetypes_filetypeentry*);
/* unregister a filetype entry from the database */
void filetypes_unregister(filetypes_filetypeentry*);
/* get a registry entry for a given suffix */
filetypes_filetypeentry *filetypes_getfiletypehandler(char *suffix);
/* update a filetype entry externally */
void filetypes_modify(filetypes_filetypeentry *entry,
		      char *suffix,     /* NULL == don't modify */
		      char *tracktype,
		      int  precache,    /* -1   == don't modify */
		      char *filter,
		      char *filtername,
		      char *detectsize,
		      char *sizealg);
/* the following defines are convenience calls to filetypes_getfiletypehandler,
 * referring to specific parts of the filetypeentry structure */
#define filetypes_gettracktype(suffix)  (char*)&filetypes_getfiletypehandler(suffix)->tracktype
#define filetypes_getfilter(suffix)     (char*)&filetypes_getfiletypehandler(suffix)->filter
#define filetypes_getfiltername(suffix) (char*)&filetypes_getfiletypehandler(suffix)->filtername
#define filetypes_getdetectsize(suffix) (char*)&filetypes_getfiletypehandler(suffix)->detectsize
#define filetypes_getsizealg(suffix)    (char*)&filetypes_getfiletypehandler(suffix)->sizealg
#define filetypes_getprecache(suffix)   filetypes_getfiletypehandler(suffix)->precache
#endif // FILETYPES_H
