#
#  $Id: debug.py,v 1.3 1999/08/09 21:59:13 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Debugging aids.
"""

__version__ = '$Id: debug.py,v 1.3 1999/08/09 21:59:13 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import sys, string, time

def dump_raw(s, f=sys.stdout):
    """Dump a string in hex/ascii format, not unlike what 'pilot-file' does."""
    x = 0
    while 1:
	t = s[:16]
	s = s[16:]
	if not t: break
	
	f.write('%04x:' % x)

	for c in t:
	    f.write(' %02x' % ord(c))

	if len(t) < 16:
	    f.write('   ' * (16 - len(t)))

	f.write('   ')

	for c in t:
	    if ord(c) >= 0x20 and ord(c) <= 0x7e:
		f.write(c)
	    else:
		f.write('.')

	f.write('\n')
	x = x + 16


def dump_info(i, f=sys.stdout):
    """Dump a database info structure.
    """
    f.write('name: "%s"\n' % i.get('name',''))

    flags = (i.get('flagResource') and 0x0001 or 0) | \
	    (i.get('flagReadOnly') and 0x0002 or 0) | \
	    (i.get('flagAppInfoDirty') and 0x0004 or 0) | \
	    (i.get('flagBackup') and 0x0008 or 0) | \
	    (i.get('flagOpen') and 0x8000 or 0) | \
	    (i.get('flagNewer') and 0x0010 or 0) | \
	    (i.get('flagReset') and 0x0020 or 0) | \
	    (i.get('flagExcludeFromSync') and 0x0080 or 0)
    
    f.write('flags: 0x%04x' % flags)
    for x in map(lambda x: x[0][4:],
		 filter(lambda x: x[0][:4] == 'flag' and x[1], i.items())):
	f.write(' %s' % x)
    f.write('\n')

    f.write('creation_time: %s\n' % \
	    time.strftime('%Y-%m-%d %H:%M:%S',
			  time.localtime(i.get('createDate',0))))
    f.write('modified_time: %s\n' % \
	    time.strftime('%Y-%m-%d %H:%M:%S',
			  time.localtime(i.get('modifyDate',0))))
    f.write('backup_time: %s\n' % \
	    time.strftime('%Y-%m-%d %H:%M:%S',
			  time.localtime(i.get('backupDate',0))))
    
    f.write('modification_number: %s\n' % i.get('modnum'))

    f.write("type: '%s', creator: '%s'\n" % (i.get('type',''),
					     i.get('creator','')))
    
    
