/* screenop.c - screen/display bits for dcd
 * (C) 1999 David E. Smith (dave@technopagan.org)
 * Released under GNU GPL, see `COPYING' for details.
 */

#include "screenop.h"
#include "version.h"
#include "libcdplay.h"
#include "dcd.h"
#include "cdindex.h"
#include <unistd.h>
#include <stdio.h>


void disk_directory(void) {
  u_char ct = cd_current_track();
  u_char trackz = cd_last_track();
  int disc_length = cd_disc_length();
  int cdi_stat = cdi_status();
  int i;

  printf ("Track  Time  (%i tracks / %2i:%02i)",
          trackz, disc_length/60, disc_length%60);
  if (cdi_stat == CDI_OK) printf (" (ID %s)", cd_discid());
  printf ("\n");
  for (i=1; i<=trackz; i++) {
    int track_length = cd_track_length(i);
    printf ("%s %2i  %2i:%02i", (i==ct ? "*" : " "),
            i, (track_length/60),
            (track_length%60));
    if (cdi_stat == CDI_OK)
      printf ("  %s", cdi_trackname(i));
    if ((cd_data_track(i)) & (cdi_stat == CDI_NONE)) printf (" (Data)");
    if (cdi_stat == CDI_NONE) printf ("\n"); /* tracknames include \n */
  } /* for */
}

void print_status(void) {
  int disc_length, track_length, current_track, last_track, disc_status;
  disc_length = cd_disc_length();
  last_track = cd_last_track();
  current_track = cd_current_track();
  disc_status = cd_hw_status();
  if (FALSE == cd_active()) {
    printf ("Not playing (%i tracks, %i:%02i)\n", last_track,
             disc_length/60, disc_length%60);
    return;
  }
  track_length = cd_track_length(current_track);
  printf ("Playing track %i (of %i), length %i:%02i (of %i:%02i)",
           current_track, last_track, track_length/60, track_length%60,
           disc_length/60, disc_length%60);
  printf ("\n");
}

void print_help (void) {
  printf ("%s\n", VERSION);
  printf ("Usage: %s [options] [tracklist]\n", PROGNAME);
  printf ("The following options cause %s to exit immediately:\n", PROGNAME);
  printf ("         d   dir      lists the CD directory\n");
  printf ("         e   eject    opens the CD tray\n");
  printf ("         h   help     displays this message\n");
  printf ("         i   info     minimal info on the current CD\n");
  printf ("         p   pause    pause/resume the CD\n");
  printf ("         s   stop     stops the CD player\n");
  printf ("         v   version  displays the software revision/patchlevel\n");
  printf ("         f   forward  play the next track on CD\n");
  printf ("         b   back     play the previous track on CD\n");
  printf ("\n");
  printf ("These options are for using the CD Index (http://www.cdindex.org/):\n");
  printf ("         c   connect   toggles network availability status\n");
  printf ("         x   cdindex   display discid for current CD\n");
  printf ("         u   url       display request URL for current CD\n");
  printf ("\n");
  printf ("These options are for programming %s like a CD player:\n", PROGNAME);
  printf ("         l   loop    loop the listed tracks (or CD if none given)\n");  
  printf ("         r   random  plays random track from the CD\n");
  printf ("         q   quit    Don't detach from console until finished\n");
} /* help */

void print_discid (void) {
  printf ("%s\n", cd_discid());
}

void print_disc_url (void) {
  printf ("http://www.cdindex.org/cgi-bin/cdi/get.pl?id=");
  print_discid();
}

void print_sub_url (void) {
  printf ("%s\n", cd_subid());
}

void dcd_version (void) {
  printf ("%s\n", VERSION);
  printf ("Compiled on %s with the following options:\n", __DATE__);
  printf ("CD-ROM device is %s\n", CDROM_DEVICE);
  if (EXTRA_SLEEP_TIME > 0)
    printf ("Sleep time: %i seconds\n", EXTRA_SLEEP_TIME);
  printf ("CD Index cache directory: $HOME/%s\n", CDINDEX_HOME);
  printf ("Network status default: %s\n",
           NETWORK_CAPABLE ? "Enabled" : "Disabled");
}
