/* Gtick  -  A Gtk+ Metronome
 *
 *   about.c: About box code
 *
 * Copyright (c) 1999, Alex Roberts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtk.h>
#include <glib.h>

#include <stdio.h>

#include <sys/ioctl.h>
#ifdef FREEBSD
#include <machine/soundcard.h>
#else
#include <linux/soundcard.h>
#endif

#include "gtick.h"

void closewindow_cb (GtkWidget *w, GtkWidget *window)
{
	gtk_widget_destroy (window);
}

void gtAboutBox ()
{
GtkWidget *window;
GtkWidget *label;
GtkWidget *box1;
GtkWidget *button;
GtkWidget *separator;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	gtk_signal_connect (GTK_OBJECT (window), "destroy",
			 		 GTK_SIGNAL_FUNC (gtk_widget_destroy),
					 window);

	gtk_window_set_title (GTK_WINDOW (window),"About gTick");
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	
	
	box1 = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (window), box1);
	gtk_widget_show (box1);
	
	label = gtk_label_new (TITLE);
	gtk_box_pack_start (GTK_BOX (box1), label, TRUE, TRUE, 0);
	gtk_widget_show (label);
	
	label = gtk_label_new ("Copyright (c) 1999, Alex Roberts");
	gtk_box_pack_start (GTK_BOX (box1), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	label = gtk_label_new ("http://bsenet.cjb.net/gtick");
	gtk_box_pack_start (GTK_BOX (box1), label, TRUE, TRUE, 10);
	gtk_widget_show (label);
	
	label = gtk_label_new ("Email bug reports, comments, etc to:");
	gtk_box_pack_start (GTK_BOX (box1), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	label = gtk_label_new ("bse@dial.pipex.com");
	gtk_box_pack_start (GTK_BOX (box1), label, TRUE, TRUE, 0);
	gtk_widget_show (label);
	
	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (box1), separator, TRUE, TRUE, 0);
	gtk_widget_show (separator);
	
	button = gtk_button_new_with_label ("Ok");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
					GTK_SIGNAL_FUNC (closewindow_cb),
					GTK_OBJECT(window));
	gtk_box_pack_start (GTK_BOX (box1), button, TRUE, TRUE, 5);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);
	
	
	gtk_widget_show (window);
}