/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "xmms.h"
#include "libxmms/util.h"

GtkWidget *prefswin, *prefswin_notebook;
GtkWidget *prefswin_audio_vbox;
GtkWidget *prefswin_audio_iframe, *prefswin_audio_ivbox, *prefswin_audio_ilist,
         *prefswin_audio_ihbox, *prefswin_audio_ihbbox;
GtkWidget *prefswin_audio_iconfig, *prefswin_audio_iabout, *prefswin_audio_ie_cbox;
GtkWidget *prefswin_audio_oframe, *prefswin_audio_ovbox, *prefswin_audio_olist,
         *prefswin_audio_ohbox;
GtkWidget *prefswin_audio_oconfig, *prefswin_audio_oabout;

GtkWidget *prefswin_egplugins_vbox;
GtkWidget *prefswin_egplugins_eframe, *prefswin_egplugins_evbox, *prefswin_egplugins_euse_cbox;
GtkWidget *prefswin_egplugins_elist, *prefswin_egplugins_ehbox;
GtkWidget *prefswin_egplugins_econfig, *prefswin_egplugins_eabout;
GtkWidget *prefswin_egplugins_gframe, *prefswin_egplugins_gvbox, *prefswin_egplugins_guse_cbox;
GtkWidget *prefswin_egplugins_glist, *prefswin_egplugins_ghbox;
GtkWidget *prefswin_egplugins_gconfig, *prefswin_egplugins_gabout;

GtkWidget *prefswin_vplugins_box,*prefswin_vplugins_vbox;
GtkWidget *prefswin_vplugins_frame, *prefswin_vplugins_vbox, *prefswin_vplugins_use_cbox;
GtkWidget *prefswin_vplugins_list, *prefswin_vplugins_hbox;
GtkWidget *prefswin_vplugins_config, *prefswin_vplugins_about;

GtkWidget *prefswin_options_frame, *prefswin_options_vbox, *prefswin_options_table;
GtkWidget *prefswin_options_ami, *prefswin_options_asc;
GtkWidget *prefswin_options_cus, *prefswin_options_cts;
GtkWidget *prefswin_options_snp, *prefswin_options_sw_box;
GtkWidget *prefswin_options_sw, *prefswin_options_sd_entry;
GtkWidget *prefswin_options_sd_label;
GtkWidget *prefswin_options_swp, *prefswin_options_dim;
GtkWidget *prefswin_options_pl_pos, *prefswin_options_fsc;
GtkWidget *prefswin_options_oro, *prefswin_options_giol;
GtkWidget *prefswin_options_s_jtf, *prefswin_options_sts;
GtkWidget *prefswin_options_giod, *prefswin_options_gi_box;
GtkWidget *prefswin_options_gi_label, *prefswin_options_edl;
GtkWidget *prefswin_options_rt;
GtkWidget *prefswin_options_pbs, *prefswin_options_pbs_box;
GtkWidget *prefswin_options_pbs_entry, *prefswin_options_pbs_label;
GtkWidget *prefswin_options_ubsd;
GtkWidget *prefswin_options_edga;
GtkWidget *prefswin_options_font_frame, *prefswin_options_font_hbox;
GtkWidget *prefswin_options_font_entry, *prefswin_options_font_browse;
GtkWidget *prefswin_options_fontsel;
GtkWidget *prefswin_vbox, *prefswin_hbox, *prefswin_ok, *prefswin_cancel,
         *prefswin_apply;
GtkWidget *prefswin_options_mouse_box, *prefswin_options_mouse_label,
	*prefswin_options_mouse_spin;
GtkObject *prefswin_options_mouse_entry;
gint	temp_mouse_change;
gboolean updating_ilist = FALSE, updating_glist = FALSE, updating_vlist = FALSE;

extern MenuRow *mainwin_menurow;

extern PButton *playlistwin_shade, *playlistwin_close, *equalizerwin_close;
extern PButton *mainwin_menubtn, *mainwin_minimize, *mainwin_shade, *mainwin_close;
extern TextBox *mainwin_info;
extern gboolean mainwin_focus, equalizerwin_focus, playlistwin_focus;

static gboolean is_opening = FALSE;

void add_input_plugins(void);
void add_general_plugins(void);
void add_vis_plugins(void);

gint prefswin_delete_event(GtkWidget * widget, GdkEvent * event, gpointer data)
{
	gtk_widget_hide(prefswin);
	return (TRUE);
}

void prefswin_ilist_clicked(GtkWidget * w, gpointer data)
{
	InputPlugin *ip;
	gint index;
	GList *iplist;

	if (GTK_CLIST(prefswin_audio_ilist)->selection)
	{
		iplist = get_input_list();
		index = (gint) GTK_CLIST(prefswin_audio_ilist)->selection->data;
		ip = g_list_nth(iplist, index)->data;

		gtk_widget_set_sensitive(prefswin_audio_ie_cbox, 1);
		updating_ilist = TRUE;
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_audio_ie_cbox), (g_list_find(disabled_iplugins, ip) ? FALSE : TRUE));
		updating_ilist = FALSE;

		if (ip->configure != NULL)
			gtk_widget_set_sensitive(prefswin_audio_iconfig, 1);
		else
			gtk_widget_set_sensitive(prefswin_audio_iconfig, 0);

		if (ip->about != NULL)
			gtk_widget_set_sensitive(prefswin_audio_iabout, 1);
		else
			gtk_widget_set_sensitive(prefswin_audio_iabout, 0);
	}
	else
	{
		gtk_widget_set_sensitive(prefswin_audio_iconfig, 0);
		gtk_widget_set_sensitive(prefswin_audio_iabout, 0);
	}
}

void prefswin_iconfigure(GtkWidget * w, gpointer data)
{
	if (GTK_CLIST(prefswin_audio_ilist)->selection)
		input_configure((gint) GTK_CLIST(prefswin_audio_ilist)->selection->data);
}

void prefswin_iabout(GtkWidget * w, gpointer data)
{
	if (GTK_CLIST(prefswin_audio_ilist)->selection)
		input_about((gint) GTK_CLIST(prefswin_audio_ilist)->selection->data);
}

void prefswin_oconfigure(GtkWidget * w, gpointer data)
{
	output_configure();
}

void prefswin_oabout(GtkWidget * w, gpointer data)
{
	output_about();
}

void prefswin_econfigure(GtkWidget * w, gpointer data)
{
	effect_configure();
}

void prefswin_eabout(GtkWidget * w, gpointer data)
{
	effect_about();
}

void prefswin_gconfigure(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(prefswin_egplugins_glist)->selection->data;

	general_configure(sel);
}

void prefswin_gabout(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(prefswin_egplugins_glist)->selection->data;

	general_about(sel);
}

void prefswin_glist_clicked(GtkWidget * w, gpointer data)
{
	GeneralPlugin *gp;
	gint index;
	GList *gplist;

	if (GTK_CLIST(prefswin_egplugins_glist)->selection)
	{
		gplist = get_general_list();
		index = (gint) GTK_CLIST(prefswin_egplugins_glist)->selection->data;
		gp = g_list_nth(gplist, index)->data;

		gtk_widget_set_sensitive(prefswin_egplugins_guse_cbox, 1);
		updating_glist = TRUE;
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_egplugins_guse_cbox), general_enabled(index));
		updating_glist = FALSE;

		if (gp && gp->configure)
			gtk_widget_set_sensitive(prefswin_egplugins_gconfig, 1);
		else
			gtk_widget_set_sensitive(prefswin_egplugins_gconfig, 0);

		if (gp && gp->about)
			gtk_widget_set_sensitive(prefswin_egplugins_gabout, 1);
		else
			gtk_widget_set_sensitive(prefswin_egplugins_gabout, 0);
	}
	else
	{
		gtk_widget_set_sensitive(prefswin_egplugins_gconfig, FALSE);
		gtk_widget_set_sensitive(prefswin_egplugins_gabout, FALSE);
	}
}

void prefswin_vconfigure(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(prefswin_vplugins_list)->selection->data;

	vis_configure(sel);
}

void prefswin_vabout(GtkWidget * w, gpointer data)
{
	gint sel = (gint) GTK_CLIST(prefswin_vplugins_list)->selection->data;

	vis_about(sel);
}

void prefswin_vlist_clicked(GtkWidget * w, gpointer data)
{
	VisPlugin *vp;
	gint index;
	GList *vplist;

	if (GTK_CLIST(prefswin_vplugins_list)->selection)
	{
		vplist = get_vis_list();
		index = (gint) GTK_CLIST(prefswin_vplugins_list)->selection->data;
		vp = g_list_nth(vplist, index)->data;

		gtk_widget_set_sensitive(prefswin_vplugins_use_cbox, 1);
		updating_vlist = TRUE;
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_vplugins_use_cbox), vis_enabled(index));
		updating_vlist = FALSE;

		if (vp && vp->configure)
			gtk_widget_set_sensitive(prefswin_vplugins_config, 1);
		else
			gtk_widget_set_sensitive(prefswin_vplugins_config, 0);

		if (vp && vp->about)
			gtk_widget_set_sensitive(prefswin_vplugins_about, 1);
		else
			gtk_widget_set_sensitive(prefswin_vplugins_about, 0);
	}
	else
	{
		gtk_widget_set_sensitive(prefswin_vplugins_config, FALSE);
		gtk_widget_set_sensitive(prefswin_vplugins_about, FALSE);
	}
}


void prefswin_rt_callback(GtkWidget * w, gpointer data)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) && !is_opening)
	{
		xmms_show_message("Warning",
				  "Realtime priority is a way for XMMS to make sure it always\n\
get as much CPU time as needed for decoding audio files without\n\
any \"skips\".\n\n\
This requires that XMMS is run with root priveleges and\n\
may, although it's very unusal, lock up your computer.\n\n\
You have been warned, to activate this you need to\n\
restart XMMS.", "Ok", FALSE, NULL, NULL);
	}
}

void prefswin_edga_callback(GtkWidget * w, gpointer data)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) && !is_opening)
	{
		xmms_show_message("Warning",
				  "DGA access is a way for plugins to be able to write directly to\n\
the graphics cards video memory which results in much higher framerates.\n\
There are some bugs in some X servers that make XMMS crash on startup\n\
if you enable this option. If this happens change the line enable_dga = TRUE\n\
to enable_dga = FALSE in your ~/.xmms/config file.\n\n\
This also requires that you either run XMMS as root directly or with the suid\n\
bit set. (This should be safe because XMMS releases the superuser priveliges\n\
very early).\n\n\
You have been warned, to activate this you need to restart XMMS.", "Ok", FALSE, NULL, NULL);
	}
}

void prefswin_apply_changes(void)
{
	g_free(cfg.playlist_font);
	cfg.allow_multiple_instances = GTK_TOGGLE_BUTTON(prefswin_options_ami)->active;
	cfg.always_show_cb = GTK_TOGGLE_BUTTON(prefswin_options_asc)->active;
	cfg.convert_underscore = GTK_TOGGLE_BUTTON(prefswin_options_cus)->active;
	cfg.convert_twenty = GTK_TOGGLE_BUTTON(prefswin_options_cts)->active;
	cfg.show_numbers_in_pl = GTK_TOGGLE_BUTTON(prefswin_options_snp)->active;
	cfg.snap_windows = GTK_TOGGLE_BUTTON(prefswin_options_sw)->active;
	sscanf(gtk_entry_get_text(GTK_ENTRY(prefswin_options_sd_entry)), "%u", &cfg.snap_distance);
	cfg.save_window_position = GTK_TOGGLE_BUTTON(prefswin_options_swp)->active;
	cfg.dim_titlebar = GTK_TOGGLE_BUTTON(prefswin_options_dim)->active;
	cfg.playlist_font = g_strdup(gtk_entry_get_text(GTK_ENTRY(prefswin_options_font_entry)));
	cfg.save_playlist_position = GTK_TOGGLE_BUTTON(prefswin_options_pl_pos)->active;
	cfg.open_rev_order = GTK_TOGGLE_BUTTON(prefswin_options_oro)->active;
	cfg.get_info_on_load = GTK_TOGGLE_BUTTON(prefswin_options_giol)->active;
	cfg.get_info_on_demand = GTK_TOGGLE_BUTTON(prefswin_options_giod)->active;
	cfg.eq_doublesize_linked = GTK_TOGGLE_BUTTON(prefswin_options_edl)->active;
	cfg.sort_jump_to_file = GTK_TOGGLE_BUTTON(prefswin_options_s_jtf)->active;
	cfg.smooth_title_scroll = GTK_TOGGLE_BUTTON(prefswin_options_sts)->active;
	cfg.use_realtime = GTK_TOGGLE_BUTTON(prefswin_options_rt)->active;
	cfg.pause_between_songs = GTK_TOGGLE_BUTTON(prefswin_options_pbs)->active;
	cfg.pause_between_songs_time = atoi(gtk_entry_get_text(GTK_ENTRY(prefswin_options_pbs_entry)));
	cfg.use_backslash_as_dir_delimiter = GTK_TOGGLE_BUTTON(prefswin_options_ubsd)->active;
	cfg.enable_dga = GTK_TOGGLE_BUTTON(prefswin_options_edga)->active;
	
	cfg.use_eplugins = GTK_TOGGLE_BUTTON(prefswin_egplugins_euse_cbox)->active;
	cfg.mouse_change = (gint) GTK_ADJUSTMENT(prefswin_options_mouse_entry)->value;

	equalizerwin_set_doublesize(cfg.doublesize && cfg.eq_doublesize_linked);

	if (cfg.dim_titlebar)
	{
		mainwin_menubtn->pb_allow_draw = mainwin_focus;
		mainwin_minimize->pb_allow_draw = mainwin_focus;
		mainwin_shade->pb_allow_draw = mainwin_focus;
		mainwin_close->pb_allow_draw = mainwin_focus;
		equalizerwin_close->pb_allow_draw = equalizerwin_focus;
		playlistwin_shade->pb_allow_draw = playlistwin_focus;
		playlistwin_close->pb_allow_draw = playlistwin_focus;
	}
	else
	{
		mainwin_menubtn->pb_allow_draw = TRUE;
		mainwin_minimize->pb_allow_draw = TRUE;
		mainwin_shade->pb_allow_draw = TRUE;
		mainwin_close->pb_allow_draw = TRUE;
		equalizerwin_close->pb_allow_draw = TRUE;
		playlistwin_shade->pb_allow_draw = TRUE;
		playlistwin_close->pb_allow_draw = TRUE;
	}
	if (cfg.get_info_on_load)
		playlist_start_get_info_scan();

	if (mainwin_info->tb_timeout_tag)
	{
		textbox_set_scroll(mainwin_info, FALSE);
		textbox_set_scroll(mainwin_info, TRUE);
	}

	draw_main_window(TRUE);
	draw_playlist_window(TRUE);
	draw_equalizer_window(TRUE);
}

void prefswin_ok_cb(GtkWidget * w, gpointer data)
{
	prefswin_apply_changes();
	gtk_widget_hide(prefswin);
}

void prefswin_cancel_cb(GtkWidget * w, gpointer data)
{
	gtk_adjustment_set_value(GTK_ADJUSTMENT(prefswin_options_mouse_entry),cfg.mouse_change);
 	gtk_widget_hide(prefswin);
}

void prefswin_apply_cb(GtkWidget * w, gpointer data)
{
	prefswin_apply_changes();
}

void prefswin_font_browse_ok(GtkWidget * w, gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(prefswin_options_font_entry), gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(prefswin_options_fontsel)));
	gtk_widget_destroy(prefswin_options_fontsel);
}

void prefswin_font_browse_cb(GtkWidget * w, gpointer data)
{
	if (!prefswin_options_fontsel)
	{
		prefswin_options_fontsel = gtk_font_selection_dialog_new("Select playlist font:");
		gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(prefswin_options_fontsel), cfg.playlist_font);
		gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(prefswin_options_fontsel)->ok_button), "clicked", GTK_SIGNAL_FUNC(prefswin_font_browse_ok), NULL);
		gtk_signal_connect_object(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(prefswin_options_fontsel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(prefswin_options_fontsel));
		gtk_signal_connect(GTK_OBJECT(prefswin_options_fontsel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &prefswin_options_fontsel);
		gtk_widget_show(prefswin_options_fontsel);
	}
}

void prefswin_egplugins_euse_cb(GtkWidget * w, gpointer data)
{
	cfg.use_eplugins = GTK_TOGGLE_BUTTON(w)->active;
}

void prefswin_egplugins_guse_cb(GtkWidget * w, gpointer data)
{
	gint sel;
	GtkAdjustment *adj;
	gfloat pos;

	if (!(GTK_CLIST(prefswin_egplugins_glist)->selection) || updating_glist)
		return;

	sel = (gint) GTK_CLIST(prefswin_egplugins_glist)->selection->data;

	enable_general_plugin(sel, GTK_TOGGLE_BUTTON(w)->active);
	adj = gtk_clist_get_vadjustment(GTK_CLIST(prefswin_egplugins_glist));
	pos = adj->value;
	add_general_plugins();
	gtk_adjustment_set_value(adj, pos);
	gtk_clist_set_vadjustment(GTK_CLIST(prefswin_egplugins_glist), adj);
	gtk_clist_select_row(GTK_CLIST(prefswin_egplugins_glist), sel, 0);
}

void prefswin_vplugins_rescan(void)
{
	gint sel;
	GtkAdjustment *adj;
	gfloat pos;

	if(GTK_CLIST(prefswin_vplugins_list)->selection)
		sel = (gint) GTK_CLIST(prefswin_vplugins_list)->selection->data;
	else
		sel = -1;
	adj = gtk_clist_get_vadjustment(GTK_CLIST(prefswin_vplugins_list));
	pos = adj->value;
	add_vis_plugins();
	gtk_adjustment_set_value(adj, pos);
	gtk_clist_set_vadjustment(GTK_CLIST(prefswin_vplugins_list), adj);
	if(sel != -1)
		gtk_clist_select_row(GTK_CLIST(prefswin_vplugins_list), sel, 0);
}
		
void prefswin_vplugins_use_cb(GtkWidget * w, gpointer data)
{
	gint sel;

	if (!(GTK_CLIST(prefswin_vplugins_list)->selection) || updating_vlist)
		return;

	sel = (gint) GTK_CLIST(prefswin_vplugins_list)->selection->data;
	
	enable_vis_plugin(sel, GTK_TOGGLE_BUTTON(w)->active);
	
	prefswin_vplugins_rescan();
}


void prefswin_ip_ena_dis(GtkWidget * w, gpointer data)
{
	InputPlugin *selected;
	gint sel;
	GtkAdjustment *adj;
	gfloat pos;

	if (!(GTK_CLIST(prefswin_audio_ilist)->selection) || updating_ilist)
		return;

	sel = (gint) GTK_CLIST(prefswin_audio_ilist)->selection->data;

	selected = (InputPlugin *) (g_list_nth(get_input_list(), sel)->data);

	if (!(GTK_TOGGLE_BUTTON(w)->active))
		disabled_iplugins = g_list_append(disabled_iplugins, selected);
	else if (g_list_find(disabled_iplugins, selected))
		disabled_iplugins = g_list_remove(disabled_iplugins, selected);
	adj = gtk_clist_get_vadjustment(GTK_CLIST(prefswin_audio_ilist));
	pos = adj->value;
	add_input_plugins();
	gtk_adjustment_set_value(adj, pos);
	gtk_clist_set_vadjustment(GTK_CLIST(prefswin_audio_ilist), adj);
	gtk_clist_select_row(GTK_CLIST(prefswin_audio_ilist), sel, 0);
}

void create_prefs_window(void)
{
	GtkWidget *scrolled_win;
	gchar *input_titles[] =
	{"Input plugins"};
	gchar *general_titles[] =
	{"General plugins"};
	gchar *visualization_titles[] =
	{"Visualization plugins"};

	prefswin = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(prefswin), "Preferences");
	gtk_window_set_position(GTK_WINDOW(prefswin), GTK_WIN_POS_CENTER);
	gtk_window_set_policy(GTK_WINDOW(prefswin), FALSE, FALSE, FALSE);
	gtk_window_set_transient_for(GTK_WINDOW(prefswin), GTK_WINDOW(mainwin));
	gtk_signal_connect(GTK_OBJECT(prefswin), "delete_event", GTK_SIGNAL_FUNC(prefswin_delete_event), NULL);
	gtk_container_border_width(GTK_CONTAINER(prefswin), 10);

	prefswin_vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(prefswin), prefswin_vbox);
	prefswin_notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(prefswin_vbox), prefswin_notebook, TRUE, TRUE, 0);

	/*
	 * Audio I/O Page
	 */

	prefswin_audio_vbox = gtk_vbox_new(FALSE, 0);

	/*
	 * Input plugins
	 */

	prefswin_audio_iframe = gtk_frame_new("Input Plugins");
	gtk_container_border_width(GTK_CONTAINER(prefswin_audio_iframe), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_vbox), prefswin_audio_iframe, TRUE, TRUE, 0);

	prefswin_audio_ivbox = gtk_vbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(prefswin_audio_ivbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_audio_iframe), prefswin_audio_ivbox);

	prefswin_audio_ilist = gtk_clist_new_with_titles(1, input_titles);
	gtk_widget_set_usize(prefswin_audio_ilist, -1, 80);
	gtk_clist_column_titles_passive(GTK_CLIST(prefswin_audio_ilist));
	gtk_clist_set_selection_mode(GTK_CLIST(prefswin_audio_ilist), GTK_SELECTION_SINGLE);
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_ilist), "select_row", GTK_SIGNAL_FUNC(prefswin_ilist_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_ilist), "unselect_row", GTK_SIGNAL_FUNC(prefswin_ilist_clicked), NULL);
	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), prefswin_audio_ilist);
	gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ivbox), scrolled_win, TRUE, TRUE, 0);

	prefswin_audio_ihbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ivbox), prefswin_audio_ihbox, FALSE, FALSE, 5);

	prefswin_audio_ihbbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_audio_ihbbox), GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_audio_ihbbox), 10);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(prefswin_audio_ihbbox), 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ihbox), prefswin_audio_ihbbox, TRUE, TRUE, 0);

	prefswin_audio_iconfig = gtk_button_new_with_label("Configure");
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_iconfig), "clicked", GTK_SIGNAL_FUNC(prefswin_iconfigure), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ihbbox), prefswin_audio_iconfig, TRUE, TRUE, 0);
	prefswin_audio_iabout = gtk_button_new_with_label("About");
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_iabout), "clicked", GTK_SIGNAL_FUNC(prefswin_iabout), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ihbbox), prefswin_audio_iabout, TRUE, TRUE, 0);

	prefswin_audio_ie_cbox = gtk_check_button_new_with_label("Enable plugin");
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_ie_cbox), "toggled", GTK_SIGNAL_FUNC(prefswin_ip_ena_dis), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ihbox), prefswin_audio_ie_cbox, FALSE, FALSE, 10);

	/* 
	 * Output plugin
	 */

	prefswin_audio_oframe = gtk_frame_new("Output Plugin");
	gtk_container_border_width(GTK_CONTAINER(prefswin_audio_oframe), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_vbox), prefswin_audio_oframe, FALSE, FALSE, 0);

	prefswin_audio_ovbox = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(prefswin_audio_ovbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_audio_oframe), prefswin_audio_ovbox);

	prefswin_audio_olist = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ovbox), prefswin_audio_olist, TRUE, TRUE, 0);

	prefswin_audio_ohbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_audio_ohbox), GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_audio_ohbox), 10);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(prefswin_audio_ohbox), 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ovbox), prefswin_audio_ohbox, FALSE, FALSE, 0);

	prefswin_audio_oconfig = gtk_button_new_with_label("Configure");
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_oconfig), "clicked", GTK_SIGNAL_FUNC(prefswin_oconfigure), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ohbox), prefswin_audio_oconfig, TRUE, TRUE, 0);

	prefswin_audio_oabout = gtk_button_new_with_label("About");
	gtk_signal_connect(GTK_OBJECT(prefswin_audio_oabout), "clicked", GTK_SIGNAL_FUNC(prefswin_oabout), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_audio_ohbox), prefswin_audio_oabout, TRUE, TRUE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(prefswin_notebook), prefswin_audio_vbox, gtk_label_new("Audio I/O Plugins"));

	/*
	 * Plugins page
	 */

	prefswin_egplugins_vbox = gtk_vbox_new(FALSE, 0);

	/*
	 * Effect plugins
	 */

	prefswin_egplugins_eframe = gtk_frame_new("Effect Plugins");
	gtk_container_border_width(GTK_CONTAINER(prefswin_egplugins_eframe), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_vbox), prefswin_egplugins_eframe, FALSE, FALSE, 0);

	prefswin_egplugins_evbox = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(prefswin_egplugins_evbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_egplugins_eframe), prefswin_egplugins_evbox);

	prefswin_egplugins_elist = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_evbox), prefswin_egplugins_elist, TRUE, TRUE, 0);

	prefswin_egplugins_ehbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_egplugins_ehbox), GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_egplugins_ehbox), 10);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(prefswin_egplugins_ehbox), 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_evbox), prefswin_egplugins_ehbox, FALSE, FALSE, 0);

	prefswin_egplugins_econfig = gtk_button_new_with_label("Configure");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_econfig), "clicked", GTK_SIGNAL_FUNC(prefswin_econfigure), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ehbox), prefswin_egplugins_econfig, TRUE, TRUE, 0);

	prefswin_egplugins_eabout = gtk_button_new_with_label("About");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_eabout), "clicked", GTK_SIGNAL_FUNC(prefswin_eabout), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ehbox), prefswin_egplugins_eabout, TRUE, TRUE, 0);

	prefswin_egplugins_euse_cbox = gtk_check_button_new_with_label("Use plugins");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_euse_cbox), "toggled", GTK_SIGNAL_FUNC(prefswin_egplugins_euse_cb), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ehbox), prefswin_egplugins_euse_cbox, TRUE, TRUE, 0);

	/*
	 * General plugins
	 */

	prefswin_egplugins_gframe = gtk_frame_new("General Plugins");
	gtk_container_border_width(GTK_CONTAINER(prefswin_egplugins_gframe), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_vbox), prefswin_egplugins_gframe, TRUE, TRUE, 0);

	prefswin_egplugins_gvbox = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(prefswin_egplugins_gvbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_egplugins_gframe), prefswin_egplugins_gvbox);

	prefswin_egplugins_glist = gtk_clist_new_with_titles(1, general_titles);
	gtk_clist_column_titles_passive(GTK_CLIST(prefswin_egplugins_glist));
	gtk_clist_set_selection_mode(GTK_CLIST(prefswin_egplugins_glist), GTK_SELECTION_SINGLE);
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_glist), "select_row", GTK_SIGNAL_FUNC(prefswin_glist_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_glist), "unselect_row", GTK_SIGNAL_FUNC(prefswin_glist_clicked), NULL);
	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), prefswin_egplugins_glist);
	gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_gvbox), scrolled_win, TRUE, TRUE, 0);

	prefswin_egplugins_ghbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_egplugins_ghbox), GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_egplugins_ghbox), 10);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(prefswin_egplugins_ghbox), 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_gvbox), prefswin_egplugins_ghbox, FALSE, FALSE, 0);

	prefswin_egplugins_gconfig = gtk_button_new_with_label("Configure");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_gconfig), "clicked", GTK_SIGNAL_FUNC(prefswin_gconfigure), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ghbox), prefswin_egplugins_gconfig, TRUE, TRUE, 0);

	prefswin_egplugins_gabout = gtk_button_new_with_label("About");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_gabout), "clicked", GTK_SIGNAL_FUNC(prefswin_gabout), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ghbox), prefswin_egplugins_gabout, TRUE, TRUE, 0);

	prefswin_egplugins_guse_cbox = gtk_check_button_new_with_label("Enable plugin");
	gtk_signal_connect(GTK_OBJECT(prefswin_egplugins_guse_cbox), "toggled", GTK_SIGNAL_FUNC(prefswin_egplugins_guse_cb), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_egplugins_ghbox), prefswin_egplugins_guse_cbox, TRUE, TRUE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(prefswin_notebook), prefswin_egplugins_vbox, gtk_label_new("Effect/General Plugins"));

	/*
	 * Visualization plugins page
	 */
	
	prefswin_vplugins_box = gtk_vbox_new(FALSE, 0);
	
	prefswin_vplugins_frame = gtk_frame_new("Visualization Plugins");
	gtk_container_border_width(GTK_CONTAINER(prefswin_vplugins_frame), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_box), prefswin_vplugins_frame, TRUE, TRUE, 0);

	prefswin_vplugins_vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(prefswin_vplugins_vbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_vplugins_frame), prefswin_vplugins_vbox);

	prefswin_vplugins_list = gtk_clist_new_with_titles(1, visualization_titles);
	gtk_clist_column_titles_passive(GTK_CLIST(prefswin_vplugins_list));
	gtk_clist_set_selection_mode(GTK_CLIST(prefswin_vplugins_list), GTK_SELECTION_SINGLE);
	gtk_signal_connect(GTK_OBJECT(prefswin_vplugins_list), "select_row", GTK_SIGNAL_FUNC(prefswin_vlist_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(prefswin_vplugins_list), "unselect_row", GTK_SIGNAL_FUNC(prefswin_vlist_clicked), NULL);

	scrolled_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), prefswin_vplugins_list);
	gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_vbox), scrolled_win, TRUE, TRUE, 0);

	prefswin_vplugins_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_vplugins_hbox), GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_vplugins_hbox), 10);
	gtk_button_box_set_child_size(GTK_BUTTON_BOX(prefswin_vplugins_hbox), 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_vbox), prefswin_vplugins_hbox, FALSE, FALSE, 0);

	prefswin_vplugins_config = gtk_button_new_with_label("Configure");
	gtk_signal_connect(GTK_OBJECT(prefswin_vplugins_config), "clicked", GTK_SIGNAL_FUNC(prefswin_vconfigure), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_hbox), prefswin_vplugins_config, TRUE, TRUE, 0);

	prefswin_vplugins_about = gtk_button_new_with_label("About");
	gtk_signal_connect(GTK_OBJECT(prefswin_vplugins_about), "clicked", GTK_SIGNAL_FUNC(prefswin_vabout), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_hbox), prefswin_vplugins_about, TRUE, TRUE, 0);

	prefswin_vplugins_use_cbox = gtk_check_button_new_with_label("Enable plugin");
	gtk_signal_connect(GTK_OBJECT(prefswin_vplugins_use_cbox), "toggled", GTK_SIGNAL_FUNC(prefswin_vplugins_use_cb), NULL);
	gtk_box_pack_start(GTK_BOX(prefswin_vplugins_hbox), prefswin_vplugins_use_cbox, TRUE, TRUE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(prefswin_notebook), prefswin_vplugins_box, gtk_label_new("Visualization Plugins"));
	
	/*
	 * Options page
	 */

	prefswin_options_vbox = gtk_vbox_new(FALSE, 0);
	prefswin_options_frame = gtk_frame_new("Options");
	gtk_box_pack_start(GTK_BOX(prefswin_options_vbox), prefswin_options_frame, FALSE, FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(prefswin_options_frame), 5);
	prefswin_options_table = gtk_table_new(2, 10, FALSE);
	gtk_container_add(GTK_CONTAINER(prefswin_options_frame), prefswin_options_table);
	gtk_container_border_width(GTK_CONTAINER(prefswin_options_table), 5);

	prefswin_options_gi_box = gtk_hbox_new(FALSE, 5);
	prefswin_options_gi_label = gtk_label_new("Read info on");
	gtk_box_pack_start(GTK_BOX(prefswin_options_gi_box), prefswin_options_gi_label, FALSE, FALSE, 0);
	gtk_widget_show(prefswin_options_gi_label);
	prefswin_options_giod = gtk_check_button_new_with_label("demand");
	gtk_box_pack_start(GTK_BOX(prefswin_options_gi_box), prefswin_options_giod, FALSE, FALSE, 0);
	gtk_widget_show(prefswin_options_giod);
	prefswin_options_giol = gtk_check_button_new_with_label("load");
	gtk_box_pack_start(GTK_BOX(prefswin_options_gi_box), prefswin_options_giol, FALSE, FALSE, 0);
	gtk_widget_show(prefswin_options_giol);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_gi_box, 0, 1, 0, 1);
	prefswin_options_ami = gtk_check_button_new_with_label("Allow multiple instances");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_ami, 1, 2, 0, 1);

	prefswin_options_oro = gtk_check_button_new_with_label("Reverse file order in fileselector");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_oro, 0, 1, 1, 2);
	prefswin_options_asc = gtk_check_button_new_with_label("Always show clutterbar");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_asc, 1, 2, 1, 2);

	prefswin_options_cts = gtk_check_button_new_with_label("Convert %20 to space");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_cts, 0, 1, 2, 3);
	prefswin_options_swp = gtk_check_button_new_with_label("Save window positions");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_swp, 1, 2, 2, 3);

	prefswin_options_cus = gtk_check_button_new_with_label("Convert underscore to space");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_cus, 0, 1, 3, 4);
	prefswin_options_snp = gtk_check_button_new_with_label("Show numbers in playlist");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_snp, 1, 2, 3, 4);

	prefswin_options_dim = gtk_check_button_new_with_label("Dim titlebar when inactive");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_dim, 0, 1, 4, 5);
	prefswin_options_pl_pos = gtk_check_button_new_with_label("Save playlist position");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_pl_pos, 1, 2, 4, 5);

	prefswin_options_s_jtf = gtk_check_button_new_with_label("Sort \"Jump to file\" alphabetical");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_s_jtf, 0, 1, 5, 6);
	prefswin_options_edl = gtk_check_button_new_with_label("Equalizer doublesize linked");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_edl, 1, 2, 5, 6);

	prefswin_options_rt = gtk_check_button_new_with_label("Use realtime priority when available");
	gtk_signal_connect(GTK_OBJECT(prefswin_options_rt), "clicked", GTK_SIGNAL_FUNC(prefswin_rt_callback), NULL);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_rt, 0, 1, 6, 7);

	prefswin_options_sw_box = gtk_hbox_new(FALSE, 5);
	prefswin_options_sw = gtk_check_button_new_with_label("Snap windows at");
	gtk_box_pack_start(GTK_BOX(prefswin_options_sw_box), prefswin_options_sw, FALSE, FALSE, 0);
	prefswin_options_sd_entry = gtk_entry_new_with_max_length(3);
	gtk_widget_set_usize(prefswin_options_sd_entry, 30, -1);
	gtk_box_pack_start(GTK_BOX(prefswin_options_sw_box), prefswin_options_sd_entry, FALSE, FALSE, 0);
	prefswin_options_sd_label = gtk_label_new("pixels");
	gtk_box_pack_start(GTK_BOX(prefswin_options_sw_box), prefswin_options_sd_label, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_sw_box, 1, 2, 6, 7);

	prefswin_options_pbs_box = gtk_hbox_new(FALSE, 5);
	prefswin_options_pbs = gtk_check_button_new_with_label("Pause between songs for");
	gtk_box_pack_start(GTK_BOX(prefswin_options_pbs_box), prefswin_options_pbs, FALSE, FALSE, 0);
	prefswin_options_pbs_entry = gtk_entry_new_with_max_length(3);
	gtk_widget_set_usize(prefswin_options_pbs_entry, 30, -1);
	gtk_box_pack_start(GTK_BOX(prefswin_options_pbs_box), prefswin_options_pbs_entry, FALSE, FALSE, 0);
	prefswin_options_pbs_label = gtk_label_new("s");
	gtk_box_pack_start(GTK_BOX(prefswin_options_pbs_box), prefswin_options_pbs_label, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_pbs_box, 0, 1, 7, 8);
	prefswin_options_sts = gtk_check_button_new_with_label("Smooth title scroll");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_sts, 1, 2, 7, 8);

	prefswin_options_ubsd = gtk_check_button_new_with_label("Use \'\\\' as a directory delimiter");
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_ubsd, 0, 1, 8, 9);

	prefswin_options_mouse_box=gtk_hbox_new(FALSE, 5);
	prefswin_options_mouse_label=gtk_label_new("Mouse Wheel adjusts Volume by (%)");
	gtk_box_pack_start(GTK_BOX(prefswin_options_mouse_box),prefswin_options_mouse_label,FALSE,FALSE,0);
	temp_mouse_change=cfg.mouse_change;
        prefswin_options_mouse_entry = gtk_adjustment_new(temp_mouse_change, 1, 100,1, 1, 1);
	prefswin_options_mouse_spin= gtk_spin_button_new(GTK_ADJUSTMENT(prefswin_options_mouse_entry), 1, 0);
        gtk_widget_set_usize(prefswin_options_mouse_spin, 45, -1);
	gtk_box_pack_start(GTK_BOX(prefswin_options_mouse_box), prefswin_options_mouse_spin, FALSE, FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_mouse_box, 1, 2, 8,9);

	prefswin_options_edga = gtk_check_button_new_with_label("Enable DGA access when available");
	gtk_signal_connect(GTK_OBJECT(prefswin_options_edga), "clicked", GTK_SIGNAL_FUNC(prefswin_edga_callback), NULL);
	gtk_table_attach_defaults(GTK_TABLE(prefswin_options_table), prefswin_options_edga, 0, 1, 9, 10);
	
	prefswin_options_font_frame = gtk_frame_new("Playlist font");
	gtk_container_set_border_width(GTK_CONTAINER(prefswin_options_font_frame), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_options_vbox), prefswin_options_font_frame, FALSE, FALSE, 0);
	prefswin_options_font_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(prefswin_options_font_hbox), 5);
	gtk_container_add(GTK_CONTAINER(prefswin_options_font_frame), prefswin_options_font_hbox);
	prefswin_options_font_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(prefswin_options_font_hbox), prefswin_options_font_entry, TRUE, TRUE, 0);
	prefswin_options_font_browse = gtk_button_new_with_label("Browse");
	gtk_signal_connect(GTK_OBJECT(prefswin_options_font_browse), "clicked", GTK_SIGNAL_FUNC(prefswin_font_browse_cb), NULL);
	gtk_widget_set_usize(prefswin_options_font_browse, 85, 17);
	gtk_box_pack_start(GTK_BOX(prefswin_options_font_hbox), prefswin_options_font_browse, FALSE, TRUE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(prefswin_notebook), prefswin_options_vbox, gtk_label_new("Options"));

	/* 
	 * Ok, Cancel & Apply 
	 */

	prefswin_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(prefswin_hbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(prefswin_hbox), 5);
	gtk_box_pack_start(GTK_BOX(prefswin_vbox), prefswin_hbox, FALSE, FALSE, 0);

	prefswin_ok = gtk_button_new_with_label("Ok");
	gtk_signal_connect(GTK_OBJECT(prefswin_ok), "clicked", GTK_SIGNAL_FUNC(prefswin_ok_cb), NULL);
	GTK_WIDGET_SET_FLAGS(prefswin_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(prefswin_hbox), prefswin_ok, TRUE, TRUE, 0);
	prefswin_cancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(prefswin_cancel), "clicked", GTK_SIGNAL_FUNC(prefswin_cancel_cb), NULL);
	GTK_WIDGET_SET_FLAGS(prefswin_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(prefswin_hbox), prefswin_cancel, TRUE, TRUE, 0);
	prefswin_apply = gtk_button_new_with_label("Apply");
	gtk_signal_connect(GTK_OBJECT(prefswin_apply), "clicked", GTK_SIGNAL_FUNC(prefswin_apply_cb), NULL);
	GTK_WIDGET_SET_FLAGS(prefswin_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(prefswin_hbox), prefswin_apply, TRUE, TRUE, 0);
}

void prefswin_effect_cb(GtkWidget * w, gint item)
{
	EffectPlugin *cp;

	set_current_effect_plugin(item);
	cp = get_current_effect_plugin();

	if (cp->configure != NULL)
		gtk_widget_set_sensitive(prefswin_egplugins_econfig, 1);
	else
		gtk_widget_set_sensitive(prefswin_egplugins_econfig, 0);

	if (cp->about != NULL)
		gtk_widget_set_sensitive(prefswin_egplugins_eabout, 1);
	else
		gtk_widget_set_sensitive(prefswin_egplugins_eabout, 0);
}

void prefswin_output_cb(GtkWidget * w, gint item)
{
	OutputPlugin *cp;

	set_current_output_plugin(item);
	cp = get_current_output_plugin();

	if (cp->configure != NULL)
		gtk_widget_set_sensitive(prefswin_audio_oconfig, 1);
	else
		gtk_widget_set_sensitive(prefswin_audio_oconfig, 0);

	if (cp->about != NULL)
		gtk_widget_set_sensitive(prefswin_audio_oabout, 1);
	else
		gtk_widget_set_sensitive(prefswin_audio_oabout, 0);
}

void gen_module_description(gchar * file, gchar * desc, gchar ** full_desc)
{
	gchar *basename;

	basename = g_strdup(g_basename(file));
	(*full_desc) = (gchar *) g_malloc(strlen(desc) + strlen(basename) + 6);
	sprintf((*full_desc), "%s   [%s]", desc, basename);
	g_free(basename);
}

void add_output_plugins(void)
{
	GList *olist = get_output_list();
	GtkWidget *menu, *item;
	gchar *description;
	OutputPlugin *op, *cp = get_current_output_plugin();
	gint i = 0, history = 0;

	if (!olist)
	{
		gtk_widget_set_sensitive(prefswin_audio_olist, FALSE);
		gtk_widget_set_sensitive(prefswin_audio_oconfig, FALSE);
		gtk_widget_set_sensitive(prefswin_audio_oabout, FALSE);
		return;
	}

	menu = gtk_menu_new();
	while (olist)
	{
		op = (OutputPlugin *) olist->data;

		if (olist->data == cp)
			history = i;

		gen_module_description(op->filename, op->description, &description);
		item = gtk_menu_item_new_with_label(description);
		g_free(description);

		gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(prefswin_output_cb), (gpointer) i);
		gtk_widget_show(item);
		gtk_menu_append(GTK_MENU(menu), item);
		olist = olist->next;
		i++;
	}
	gtk_option_menu_remove_menu(GTK_OPTION_MENU(prefswin_audio_olist));
	gtk_option_menu_set_menu(GTK_OPTION_MENU(prefswin_audio_olist), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(prefswin_audio_olist), history);

	if (cp->configure != NULL)
		gtk_widget_set_sensitive(prefswin_audio_oconfig, TRUE);
	else
		gtk_widget_set_sensitive(prefswin_audio_oconfig, FALSE);

	if (cp->about != NULL)
		gtk_widget_set_sensitive(prefswin_audio_oabout, TRUE);
	else
		gtk_widget_set_sensitive(prefswin_audio_oabout, FALSE);

}

void add_effect_plugins(void)
{
	GList *elist = get_effect_list();
	GtkWidget *menu, *item;
	gchar *description;
	EffectPlugin *ep, *cp = get_current_effect_plugin();
	gint i = 0, history = 0;

	if (!elist)
	{
		gtk_widget_set_sensitive(prefswin_egplugins_elist, FALSE);
		gtk_widget_set_sensitive(prefswin_egplugins_euse_cbox, FALSE);
		return;
	}

	menu = gtk_menu_new();

	while (elist)
	{
		ep = (EffectPlugin *) elist->data;

		
		gen_module_description(ep->filename, ep->description, &description);

		item = gtk_menu_item_new_with_label(description);
		g_free(description);
		gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(prefswin_effect_cb), (gpointer) i);
		gtk_widget_show(item);
		gtk_menu_append(GTK_MENU(menu), item);
		if (elist->data == cp)
			history = i;
		elist = elist->next;
		i++;
	}

	gtk_option_menu_remove_menu(GTK_OPTION_MENU(prefswin_egplugins_elist));
	gtk_option_menu_set_menu(GTK_OPTION_MENU(prefswin_egplugins_elist), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(prefswin_egplugins_elist), history);

	if (cp->configure != NULL)
		gtk_widget_set_sensitive(prefswin_egplugins_econfig, 1);
	else
		gtk_widget_set_sensitive(prefswin_egplugins_econfig, 0);

	if (cp->about != NULL)
		gtk_widget_set_sensitive(prefswin_egplugins_eabout, 1);
	else
		gtk_widget_set_sensitive(prefswin_egplugins_eabout, 0);

}

void add_general_plugins(void)
{
	GList *glist = get_general_list();
	gchar *description, *temp;
	GeneralPlugin *gp;
	gint i = 0;

	gtk_clist_clear(GTK_CLIST(prefswin_egplugins_glist));

	while (glist)
	{
		gp = (GeneralPlugin *) glist->data;
		gen_module_description(gp->filename, gp->description, &description);
		if (general_enabled(i))
		{
			temp = g_strconcat(description, " (enabled)", NULL);
			g_free(description);
			description = temp;
		}

		gtk_clist_append(GTK_CLIST(prefswin_egplugins_glist), &description);
		g_free(description);
		glist = glist->next;
		i++;
	}
	gtk_widget_set_sensitive(prefswin_egplugins_guse_cbox, 0);
	gtk_widget_set_sensitive(prefswin_egplugins_gconfig, 0);
	gtk_widget_set_sensitive(prefswin_egplugins_gabout, 0);
}

void add_vis_plugins(void)
{
	GList *glist = get_vis_list();
	gchar *description, *temp;
	VisPlugin *vp;
	gint i = 0;

	gtk_clist_clear(GTK_CLIST(prefswin_vplugins_list));

	while (glist)
	{
		vp = (VisPlugin *) glist->data;
		gen_module_description(vp->filename, vp->description, &description);
		if (vis_enabled(i))
		{
			temp = g_strconcat(description, " (enabled)", NULL);
			g_free(description);
			description = temp;
		}

		gtk_clist_append(GTK_CLIST(prefswin_vplugins_list), &description);
		g_free(description);
		glist = glist->next;
		i++;
	}
	gtk_widget_set_sensitive(prefswin_vplugins_use_cbox, 0);
	gtk_widget_set_sensitive(prefswin_vplugins_config, 0);
	gtk_widget_set_sensitive(prefswin_vplugins_about, 0);
}

void add_input_plugins(void)
{
	GList *ilist = get_input_list();
	gchar *description, *temp;
	InputPlugin *ip;

	gtk_clist_clear(GTK_CLIST(prefswin_audio_ilist));
	while (ilist)
	{
		ip = (InputPlugin *) ilist->data;

		gen_module_description(ip->filename, ip->description, &description);
		if (g_list_find(disabled_iplugins, ip))
		{
			temp = g_strconcat(description, " (disabled)", NULL);
			g_free(description);
			description = temp;
		}
		gtk_clist_append(GTK_CLIST(prefswin_audio_ilist), (gchar **) & description);
		g_free(description);
		ilist = ilist->next;
	}
	gtk_widget_set_sensitive(prefswin_audio_ie_cbox, 0);
	gtk_widget_set_sensitive(prefswin_audio_iconfig, 0);
	gtk_widget_set_sensitive(prefswin_audio_iabout, 0);
}

void show_prefs_window(void)
{
	char temp[4];

	if (GTK_WIDGET_VISIBLE(prefswin))
	{
		gdk_window_raise(prefswin->window);
		return;
	}

	add_output_plugins();
	add_input_plugins();
	add_effect_plugins();
	add_general_plugins();
	add_vis_plugins();

	is_opening = TRUE;

	gtk_entry_set_text(GTK_ENTRY(prefswin_options_font_entry), cfg.playlist_font);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_ami), cfg.allow_multiple_instances);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_asc), cfg.always_show_cb);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_cus), cfg.convert_underscore);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_cts), cfg.convert_twenty);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_snp), cfg.show_numbers_in_pl);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_sw), cfg.snap_windows);
	sprintf(temp, "%u", cfg.snap_distance);
	gtk_entry_set_text(GTK_ENTRY(prefswin_options_sd_entry), temp);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_swp), cfg.save_window_position);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_dim), cfg.dim_titlebar);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_pl_pos), cfg.save_playlist_position);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_oro), cfg.open_rev_order);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_giol), cfg.get_info_on_load);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_giod), cfg.get_info_on_demand);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_edl), cfg.eq_doublesize_linked);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_s_jtf), cfg.sort_jump_to_file);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_sts), cfg.smooth_title_scroll);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_rt), cfg.use_realtime);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_pbs), cfg.pause_between_songs);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_ubsd), cfg.use_backslash_as_dir_delimiter);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_options_edga), cfg.enable_dga);
	sprintf(temp, "%u", cfg.pause_between_songs_time);
	gtk_entry_set_text(GTK_ENTRY(prefswin_options_pbs_entry), temp);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefswin_egplugins_euse_cbox), cfg.use_eplugins);

 	gtk_widget_show_all(prefswin);
	gtk_widget_grab_default(prefswin_ok);

	GDK_THREADS_LEAVE();
	while(g_main_iteration(FALSE));
	GDK_THREADS_ENTER();

	is_opening = FALSE;
	
}

void prefswin_show_vis_plugins_page(void)
{
	gtk_notebook_set_page(GTK_NOTEBOOK(prefswin_notebook), 2);
}


