#include "PicButton.h"

PicButton::PicButton(QWidget* parent, const char* name) : QButton(parent,name)
{
    pixmap = 0;
}

PicButton::~PicButton()
{
    delete pixmap;
}

void PicButton::drawButton(QPainter* painter)
{
    if (pixmap != 0)
        painter->drawPixmap(0,0,*pixmap);
}

void PicButton::setPixmap(const QPixmap & newPixmap)
{
    if (pixmap != 0)
        delete pixmap;
    pixmap = new QPixmap(newPixmap);
    repaint(false);
}
