#ifndef __aspell_amanager_hh_
#define __aspell_amanager_hh_

#include "manager.hh"
#include <slist>

namespace aspell {

  class Manager::DataSetCollection {
    friend Manager;
  public:
    struct Item {
      Item() {}
      DataSet        *word_set;
      bool            use_to_check;
      bool            use_to_suggest;
      bool            save_on_saveall;
      bool            own;
      SpecialId       special_id;

      Item(DataSet *w) : word_set(w), 
	use_to_check(false), use_to_suggest(false), 
	save_on_saveall(false), own(false), special_id(none_id)     {}
    };

  private:
    typedef slist<Item> WordLists; 
  public:
    typedef WordLists::const_iterator const_iterator;
    typedef const_iterator                  iterator;
    
    const_iterator begin() const {return wordlists_.begin();}
    const_iterator end()   const {return wordlists_.end();}

  private:


    WordLists wordlists_;

    typedef const_iterator            ConstIterator;
    typedef WordLists::iterator       Iterator;
    Iterator begin() {return wordlists_.begin();}
    Iterator end()   {return wordlists_.end();}

    struct Parms {
      typedef ConstIterator      Iterator;
      typedef DataSet *    Value;
      Iterator end_;
      Parms(Iterator e) : end_(e) {}
      Value deref(Iterator i) const {return i->word_set;}
      bool endf(Iterator i) const {return i == end_;}
      Value end_state() const {return 0;}
    };

    Iterator locate(const DataSet *to_find)
    {
      Iterator   i = wordlists_.begin();
      Iterator end = wordlists_.end();
      while (i != end && i->word_set != to_find) ++i;
      return i;
    }

    ConstIterator locate(const DataSet *to_find) const
    {
      ConstIterator   i = wordlists_.begin();
      ConstIterator end = wordlists_.end();
      while (i != end && i->word_set != to_find) ++i;
      return i;
    }

    Iterator locate(SpecialId to_find)
    {
      Iterator   i = wordlists_.begin();
      Iterator end = wordlists_.end();
      while (i != end && i->special_id != to_find) ++i;
      return i;
    }

    ConstIterator locate(SpecialId to_find) const
    {
      ConstIterator   i = wordlists_.begin();
      ConstIterator end = wordlists_.end();
      while (i != end && i->special_id != to_find) ++i;
      return i;
    }

  };
}

#endif
