
#include "as_config.h"

#include "language.hh"
#include "manager.hh"
#include <fstream>
#include <vector>

#include "config.hh"
#include "file_util.hh"
#include "split.hh"
#include "clone_ptr-t.hh"

namespace aspell {

  void Language::setup(string lang, const Config * config) 
  {
    if (!config)      config = new Config();
    if (lang.empty()) lang   = config->retrieve("lang");

    //
    // get_lang_info
    //

    StringMap data;
    data.read_in_file(add_possible_dir(config->retrieve("data-dir"), lang + ".dat"));
    data.insert("soundslike", "generic");

    name_         = data["name"];
    charset_      = data["charset"];

    vector<string> special_data = split(data["special"]);
    for (vector<string>::iterator i = special_data.begin();
	 i != special_data.end();
	 ++i) 
      {
	char c = (*i)[0];
	++i;
	special_[to_uchar(c)] = 
	  SpecialChar ((*i)[0] == '*',(*i)[1] == '*',(*i)[2] == '*');
      }
  
    //
    // fill_in_tables
    //
  
    ifstream char_data;
    open_file (char_data, 
	       add_possible_dir(config->retrieve("data-dir"),charset_ + ".dat"));

    string temp;
    getline(char_data,temp);
    getline(char_data,temp);
    for (int i = 0; i != 256; ++i) {
      char_data >> to_uni_[i];
      char_data >> temp;
      char_type_[i] = temp == "letter" ? letter 
	: temp == "space"  ? space 
	: other;
      int num;
      char_data >> num; to_lower_[i] = static_cast<char>(num);
      char_data >> num; to_upper_[i] = static_cast<char>(num);
      char_data >> num; to_title_[i] = static_cast<char>(num);
      char_data >> num; to_sl_[i] = static_cast<char>(num);
    }

    //
    // prep phonetic code
    //

    soundslike_ = new_soundslike(data.lookup("soundslike"), 
				 config->retrieve("data-dir"),
				 this);
    soundslike_chars_ = soundslike_->soundslike_chars();
  }

  Language::CasePattern Language::case_pattern (const char * i) const {
    bool first_upper_ = false;
    int  size = 0;
    int  upper_count = 0;
    if (*i) {
      ++size;
      if (is_title(*i) || is_upper(*i) ) {
	first_upper_ = true;
	++upper_count;
      }
    }
    for (;*i; ++i) {
      ++size;
      if (is_upper(*i)) ++upper_count;
    }

    if (upper_count == size)
      return all_upper;
    else if (first_upper_)
      return first_upper;
    else
      return all_lower;
  }

  string Language::fix_case (Language::CasePattern pattern, const char * word) const {
    switch (pattern) {
    case all_lower:
      return word;
    case first_upper:
      return to_title(word);
    case all_upper:
    default:
      return to_upper(word);
    }
  }

  bool Language::trim_n_try(const Manager & sc, const char * word) const {
    // assumes word is at least 1 char long
    string temp = word;
    if (special(temp[0]).begin) {
      temp.erase(0,1);
      if (sc.check_notrim(temp))
	return true;
      temp = word; 
    }
    if (special(temp[temp.size()-1]).end) {
      temp.erase(temp.size()-1, 1);
      if (sc.check_notrim(temp))
	return true;
      temp = word;
    }

    if (special(temp[0]).begin
	&& special(temp[temp.size()-1]).end 
	&& temp.size() > 2) 
      {
	temp.erase(temp.size()-1, 1);
	temp.erase(0,1);
	if (sc.check_notrim(temp))
	  return true;
      }
    return false;
  }

}
