/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * esisp.h,v 1.15 1999/01/22 02:08:05 joe Exp
 *
 * Author: 	Joe English
 * Created: 	Jan 1995
 * Description: Private definitions for libesis.
 *
 * Requires:	esis.h, strmap.h, pile.h
 *
 * 1999/01/22 02:08:05
 * 1.15
 */

#ifndef ESISP_H
#define ESIS_H 1

/*
 * Nodes:
 */
struct ESISNodeRec
{
    ESISNodeType	type;		/* type of this node */
    ESISToken		name;		/* GI, or attribute or entity name */
    ESISNode		attributes;	/* attributes & auxilliary nodes */
    strmap		properties;	/* application properties */

    /* Content: */
    ESISNode		children;	/* container nodes: first child */
    ESISNode		reference;	/* reference nodes: referenced node */
    ESISData		text; 		/* data nodes: character data */

    /* Tree structure: */
    ESISNode		parent;		/* parent or owner node */
    ESISNode		next;		/* next sibling */
    ESISNode		prev;		/* previous sibling */
    ESISNode		link;		/* ilink structure; see relation.c */

    /* Pathloc document position: */
    long		pathno, width;
    short		height, depth;
};
extern ESISNode esis_create_node(
	ESISNodeType, ESISToken name,
	ESISNode parent, ESISNode esib,
	int isatttribute);

/* Entities:
 * Replacement text of internal entities stored in child nodes 
 * %%%need: internal or external flag, entity type
 * Attributes:
 * if 'text' is NULL, attribute has #IMPLIED value. 
 * %%%need(?): attribute declared value/attribute type.
 * %%%need: LPD name for link attributes. 
 */

/*
 * Internal ESIS property names:
 * All begin with an RNI '#', to keep user's namespace free.
 */

/* External entities, subdocuments: */
#define ENTPROP_SYSID		"#sysid"	/* system identifier */
#define ENTPROP_PUBID		"#pubid"	/* public identifier */
/* External data entities: */
#define ENTPROP_NOTATION	"#notation"	/* notation for entities */
#define ENTPROP_NOTATION_SYSID	"#notsysid"	/* ntn system identifier */
#define ENTPROP_NOTATION_PUBID	"#notpubid"	/* ntn public identifier */


/*
 * Document structure:
 */
struct ESISDocumentRec
{
    ESISNode	rootnode;	/* document root */
    pile	datapile;	/* for data storage */

    /* need: 
     * doc x name->entity map,
     * doc x name->notation map,
     * current subdocument
     * Others???
     */
};

/*
 * Tree builder:
 */
struct ESISBuilderRec
{
    ESISNode	rootnode;	/* root of tree */
    ESISNode 	curnode;	/* currently open node */
    ESISNode	wrptr;		/* last closed node */
    long	pathno;		/* current path number */
    pile	datapile;	/* for data storage */
};

extern ESISBuilder esis_builder_start(void);
extern ESISDocument esis_builder_finish(ESISBuilder);

extern ESISNode esis_open_node(ESISBuilder, ESISNodeType);
extern ESISNode esis_close_node(ESISBuilder);
extern ESISNode esis_create_datanode
	(ESISBuilder, ESISNodeType, char *text);
extern ESISNode esis_create_attribute(ESISNode, ESISToken name, char *attval);
extern ESISNode esis_create_entity(ESISBuilder, ESISToken name);
extern ESISNode esis_find_entity(ESISBuilder, ESISToken name);

/* 
 * Input streams:
 */
struct ESISInputStreamRec
{
    /* input stream: */
    unsigned char *buf;		/* input buffer */
    int		bufsize;	/* buffer size */
    unsigned char *bufp;	/* input buffer pointer */
    int		bufcnt; 	/* #characters left in buffer */
    ESISIOproc	buffill;	/* I/O procedure */
    void	*bufclosure;	/* closure for I/O procedure */
};

/* extern int ESISgetc(ESISInputStream ep); */
#define ESISgetc(ep) \
    ((ep)->bufcnt ? (--(ep)->bufcnt, *(ep)->bufp++) : ESIS_fillbuf(ep))
extern int ESIS_fillbuf(ESISInputStream ep);

#endif /* ESISP_H */
