/*
 * GUI status-bar module
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "gdiff.h"
#include "gui.h"
#include "guiwin.h"


/**
 * statusbar_create:
 **/
void
statusbar_create(GDiffWindow *gdwin)
{
	GtkWidget *appbar;
	
	appbar = gnome_appbar_new(FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar(gdwin->app, appbar);
	gdwin->appbar = GNOME_APPBAR(appbar);
}

/**
 * statusbar_update:
 * 'default' implies that the message will remains on status-bar.
 **/
void
statusbar_update(GDiffWindow *gdwin, const char *msg)
{
	gnome_appbar_set_default(gdwin->appbar, msg);
}
