/*
 * Copyright (c) 1997, 1999  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#include <eb/eb.h>
#include <eb/text.h>

#include "hostname.h"
#include "ident.h"
#include "linebuf.h"
#include "permission.h"

#include "ndtpd.h"

/*
 * The maximum length of path name.
 */
#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX        MAXPATHLEN
#else /* not MAXPATHLEN */
#define PATH_MAX        1024
#endif /* not MAXPATHLEN */
#endif /* not PATH_MAX */

/*
 * Actual program name (argv[0]).
 */
const char *invoked_name;

/*
 * Generic name of the program.
 */
const char *program_name;

/*
 * Program version.
 */
const char *program_version;

/*
 * Path to a working directory.
 */
char work_path[PATH_MAX + 1];

/*
 * Configuration filename.
 */
char configuration_filename[PATH_MAX + 1];

/*
 * Server name with a domain name.
 */
char server_name[MAXLEN_HOSTNAME + 1];

/*
 * Port number the server listens to.
 */
int listening_port;
int old_listening_port;

/*
 * File descriptor for the server to listen to the port.
 */
int listening_file;

/*
 * File descriptor to communicate with a client.
 */
int accepted_file;

/*
 * User ID of the server process.
 */
uid_t user_id;

/*
 * Group ID of the server process.
 */
gid_t group_id;

/*
 * Filename to log the process ID of the server.
 */
char pid_filename[PATH_MAX + 1];
char old_pid_filename[PATH_MAX + 1];

/*
 * Lock filename and ticket stock to count connections to the server.
 */
char connection_lock_filename[PATH_MAX + 1];
Ticket_Stock connection_ticket_stock;

/*
 * The maximum number of connections to the server at once.
 */
int max_clients;

/*
 * The number of the current connections.
 */
int connection_count;

/*
 * Seconds the server closes an idle connection.
 */
int idle_timeout;

/*
 * Clients the server uses IDENT protocol for.
 */
Permission identifications;

/*
 * Seconds the server give up to identify a remote user by Identification
 * protocol.
 */
int identification_timeout;

/*
 * Host permission list.
 */
Permission permissions;

/*
 * Book registry.
 */
Book *book_registry;
Book *book_registry_tail;
int book_count;

/*
 * Current book.
 */
Book *current_book;

/*
 * The number of hit entries the server give up searching.
 */
int max_hits;

/*
 * The maximum size of text the server may send as a response to a client.
 */
size_t max_text_size;

/*
 * Hookset for processing text in CD-ROM books.
 */
EB_Hookset text_hookset;

/*
 * Hostname of the client.
 */
char client_hostname[MAXLEN_HOSTNAME + 1];

/*
 * Address of the client.
 */
char client_address[MAXLEN_HOSTNAME + 1];

/*
 * User name of the client.
 */
char client_user[MAXLEN_USER_ID + 1];

/*
 * Running mode of the server.
 * (SERVER_MODE_STANDALONE or SERVER_MODE_INETD)
 */
int server_mode;

/*
 * Syslog facility.
 */
int syslog_facility;

/*
 * Line buffer to comunicate with a client.
 */
Line_Buffer line_buffer;

/*
 * Canonical name of the `EIWA' alias.
 */
char alias_eiwa[MAXLEN_BOOK_NAME + 1 + EB_MAXLEN_BASENAME + 1];

/*
 * Canonical name of the `WAEI' alias.
 */
char alias_waei[MAXLEN_BOOK_NAME + 1 + EB_MAXLEN_BASENAME + 1];

/*
 * Canonical name of the `KOJIEN' alias.
 */
char alias_kojien[MAXLEN_BOOK_NAME + 1 + EB_MAXLEN_BASENAME + 1];
