#!/usr/bin/perl
#
#  rpmaction.py - Execute build commands.
#
#  $Id: rpmaction.py,v 1.3 1998/10/17 20:21:21 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#


"""
NAME

    rpmaction.py - Execute SGMLtools build commands.

SYNOPSIS

    % python rpmaction.py <action> <package>

DESCRIPTION

    This subroutine reads the package list, and for each package executes
    the indicated command. If a package is specified, it'll execute the
    command for that package only.

    The script expects to be called from the top-level directory of
    the full SGMLtools distribution.

    action refers to one of the RPM action blocks, like "prep", "build"
    or "install".

DESCRIPTION

    In order to take dependencies into account, you should not call this 
    script directly, but rather use the top-level Makefile.

"""

import sys, os, stat, tempfile, string
import whence
from readpackagelist import readpackagelist
from genspec import genspec
from SpecFile import SpecFile
from findTeX import findTeX

#
#  Get command name and take some special effort for sanity checking
#  install. 
#
command = sys.argv[1]
if command == 'install':
    os.umask(022)

    #
    #  You can install if ALL dirs are writeable. We create these
    #  directories on-the-fly and check for writability.
    #
    checkdirs = (
	os.environ['SGML_BIN_DIR'],
	os.environ['SGML_SHARE_DIR'],
	os.environ['SGML_DOC_DIR'],
	os.environ['SGML_MAN_DIR'],
	os.environ['SGML_ETC_DIR'],
	os.environ['TEXMF_DIR']
    );
    for dir in checkdirs:
	try:
	    os.mkdir(dir, 0755)
	except:
	    pass
	if whence.iswriteable(dir):
	    continue

	print """
Error: install command given, but no write access for directory
    %s

Please run this command as root:
    make %s-%s
and then continue whatever you were doing.

""" % (dir, sys.argv[1], sys.argv[2])
	sys.exit(1)

#
#  Load the package file.
#
packagelist = readpackagelist('packages/packagelist');

if len(sys.argv) > 1:
    packagelist = { 
	sys.argv[2] : packagelist[sys.argv[2]],
	'KEYS' : [ sys.argv[2] ]
    }

#
#  Loop through the packages.
#
for package in packagelist['KEYS']:
    print command  + ' ' + package + ':'

    if packagelist[package]['flags'].has_key('noinstall'):
	print ' => encountered noinstall flag, skipping.'
	continue
    if not os.path.isdir('packages/cvs/' + package):
	print ' => directory not there, skipping.'
	continue

    #
    #  Generate the .spec file and read the generated file if it is
    #  outdated.
    #
    vers = packagelist[package]['version']
    bld  = packagelist[package]['build']
    os.chdir('packages/SPECS')
    template = '%s.template' % (package)
    specfile = '%s-%s.spec' % (package, vers)

    tpl_mtime = os.stat(template)[stat.ST_MTIME]
    try:
	spc_mtime = os.stat(specfile)[stat.ST_MTIME]
    except:
	spc_mtime = 0
    if tpl_mtime > spc_mtime:
       print 'Regenerating ' + specfile
       genspec (package, vers, bld)

    rpmfile = SpecFile(specfile)
    os.chdir('../..')

    linearray = rpmfile.getSection(command)
    if linearray == None:
	continue
    lines = ''
    for line in linearray:
	lines = lines + line + '\n'


    #
    #  Munch the lines a bit. We're working from the CVS environment, so
    #  we can safely skip the setup and patch stages. Docs are often
    #  installed under @VERSION@, so munch that too. Yes, this needs
    #  cleanup, redesign, and quite likely we need to fire the chief
    #  architect, too :-)
    #
    #  This is a /tmp race, isn't it? I haven't followed the /tmp race
    #  discussions very well (shame on me), so if somebody could please
    #  fix this...
    #
    texmf = findTeX()
    lines = """
RPM_ROOT_DIR=
RPM_PACKAGE_NAME=%s
export RPM_ROOT_DIR RPM_PACKAGE_NAME
set -ex
%s
""" % (package, lines)

    lines = string.replace(lines, '%setup', 'echo setup')
    lines = string.replace(lines, '%patch', 'echo patch')

    shfile = tempfile.mktemp()
    sh = open (shfile, 'w')
    sh.write('cd packages/cvs/%s\n' % (package))
    sh.write(lines)
    sh.write('\ncd ../../../\n')
    sh.close()

    retval = os.system('/bin/sh ' + shfile)
    if retval:
	print 'error %s running RPM command' % (retval)
	sys.exit(1)
    os.unlink(shfile)

