#include <time.h>

/* 2 Dimensional Link List */

typedef struct list
{
   char *name;   /* Name of File/Directory */
   int type;     /* Descriptor type: File = 0, Directory = 1 */
   int root;     /* Root Dir Flag: rootdir = 1; non rootdir = 0 */
   int empty;    /* If an empty dir: emtpy = 1; not empty = 0 */   
   int name_len;
   time_t mod_time;
   off_t fsize;
   struct list *up;
   struct list *down;
   struct list *left;
   struct list *right;
   struct list2 *dir_info;
   
} dir_item;

typedef struct list2
{
   char *name;
   int type;
   int name_len;
   int delete;
   time_t mod_time;
   off_t fsize;
   struct list2 *next;
   struct list2 *prev;
} dest_item;

extern dir_item *init_2D_list();
extern dest_item *init_dest_list();
extern dest_item *add_next(dest_item *destptr);
extern dir_item *add_right(dir_item *listptr);
extern dir_item *add_down(dir_item *listptr);
extern dir_item *free_right(dir_item *listptr);
extern dir_item *free_dirinfo(dir_item *listptr);
