/******************************************************************************\
 gnofin/gnofin.c   $Revision: 1.14 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "gnofin.h"

#include <gnome.h>
#include <stdio.h>
#include <stdarg.h>

#include "account.h"
#include "view.h"
#include "file.h"

#include "imp-qif.h"

#include "exp-text.h"
#include "exp-html.h"
#include "exp-latex.h"

/* project globals */
gchar * prog = NULL;


static FinView * view = NULL;

static struct poptOption options[] = {
  {NULL, '\0', 0, NULL, 0}
};

int main(int argc, char **argv)
{
  char ** cl_files;
  poptContext ctx;

  fin_trace("");

  /* initialize program */
  prog = g_basename(argv[0]);
  gnome_init_with_popt_table(prog, FIN_VERSION, argc, argv, options, 0, &ctx);

  /* create listview */
  view = fin_view_new();

  /* this is necessary to work around what seems like a GTK+ bug
   * the notebook tabs were not being drawn properly when created
   * before calling gtk_main -- anyways it shouldn't hurt */
  /* THIS DOESNT SEEM TO BE NECESSARY ANYMORE -- Jul 20, DWF
  while (gtk_events_pending())
    gtk_main_iteration();
  */

  // load import filters
  fin_view_load_import_filter(view, &FinImport_QIF);

  /* load export filters */
  fin_view_load_export_filter(view, &FinExport_TEXT);
  fin_view_load_export_filter(view, &FinExport_HTML);
  fin_view_load_export_filter(view, &FinExport_LaTeX);

  /* process command line */
  cl_files = poptGetArgs(ctx);
  if (cl_files && *cl_files)
    fin_view_load_file(view, *cl_files);
  poptFreeContext(ctx);

  /* run message loop */
  gtk_main();

  return 0;
}

#ifdef FIN_SAFE_LIST_ENABLE
gboolean
fin_check_list (gpointer list, const gchar * file, gint lineno)
{
  if (list == NULL)
  {
    printf("(list-exception) attempt to access data of NULL list node!!\n==> %s(%i)\n",
      file,lineno);
    return FALSE;
  }
  else
    return TRUE;
}
#endif

#ifdef FIN_TRACE_ENABLE
void
fin_pause()
{
  printf("pausing...");
  fflush(stdout);
  sleep(2);
  printf(" done\n");
}
void
fin_real_trace(const char * fname, char * fmt, ... )
{
  char buf[512];
  va_list ap;
  va_start(ap, fmt);
  sprintf(buf, "<%s> %s\n", fname, fmt);
  vprintf(buf, ap);
  va_end(ap);
}
#endif


/* Dialog stuff */

void
fin_message_dialog (GtkWidget   * parent,
		    const gchar * message_type,
		    const gchar * message, ...)
{
  char message_buf[256] = {0};
  GtkWidget * dialog;
  va_list ap;

  fin_trace("");

  /* generate message string */
  va_start(ap, message);
  vsnprintf(message_buf, 256, message, ap);
  va_end(ap);

  fin_trace("%s", message_buf);

  dialog = gnome_message_box_new(message_buf,
  				 message_type,
				 GNOME_STOCK_BUTTON_OK,
				 NULL);
  
  if (parent)
    gnome_dialog_set_parent(GNOME_DIALOG(dialog), GTK_WINDOW(parent));
  
  gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}

gint
fin_question_dialog (GtkWidget   * parent,
		     const gchar * message)
{
  GtkWidget * dialog;

  fin_trace("");

  dialog = gnome_message_box_new(message,
  				 GNOME_MESSAGE_BOX_QUESTION,
				 GNOME_STOCK_BUTTON_YES,
				 GNOME_STOCK_BUTTON_NO,
				 GNOME_STOCK_BUTTON_CANCEL,
				 NULL);
  
  if (parent)
    gnome_dialog_set_parent(GNOME_DIALOG(dialog), GTK_WINDOW(parent));

  gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
  return gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}

/* filename dialog */

typedef struct {
  GtkFileSelection * filesel;
  gchar            * filename;
  gint               protect;
} FinFileSelectInfo;

static void
fin_on_filesel_ok (GtkWidget * widget, FinFileSelectInfo * info)
{
  gchar * filename;

  g_return_if_fail(info);
  g_return_if_fail(GTK_IS_FILE_SELECTION(info->filesel));

  filename = gtk_file_selection_get_filename(info->filesel);

  if (info->protect && fin_file_exists(filename))
  {
    gchar buf[PATH_MAX+64];

    snprintf(buf, sizeof(buf), "Overwrite existing file '%s'?", filename);

    switch (fin_question_dialog(GTK_WIDGET(info->filesel), buf))
    {
    case FIN_YES:
      break;
    case FIN_NO:
      return;
    case FIN_CANCEL:
      gtk_main_quit();
      return;
    }
  }

  /* store copy of filename + quit dialog */
  info->filename = g_strdup(filename);
  gtk_main_quit();
}

gchar *
fin_get_filename_dialog (GtkWidget   * parent,
  			 const gchar * title,
			 const gchar * def_filename,
			 gint          protect)
{
  static FinFileSelectInfo info = {0, 0};

  fin_trace("");

  if (info.filesel == NULL)
  {
    info.filesel = GTK_FILE_SELECTION(gtk_file_selection_new(title));
    gtk_file_selection_hide_fileop_buttons(info.filesel);

    gtk_signal_connect(GTK_OBJECT(info.filesel), "delete_event",
		       GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_signal_connect(GTK_OBJECT(info.filesel->ok_button), "clicked",
		       GTK_SIGNAL_FUNC(fin_on_filesel_ok), &info);
    gtk_signal_connect(GTK_OBJECT(info.filesel->cancel_button), "clicked",
		       GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  }

  /* initialize */
  info.filename = NULL;
  info.protect = protect;

  if (def_filename && strlen(def_filename) > 0)
    gtk_file_selection_set_filename(info.filesel, def_filename);
  
  /* THIS DOESN'T SEEM TO WORK CORRECTLY
  if (parent)
    gtk_widget_set_parent(GTK_WIDGET(info.filesel), GTK_WIDGET(parent));
   */

  gtk_window_set_modal(GTK_WINDOW(info.filesel), TRUE);
  gtk_widget_show(GTK_WIDGET(info.filesel));
  gtk_main();
  gtk_window_set_modal(GTK_WINDOW(info.filesel), FALSE);
  gtk_widget_hide(GTK_WIDGET(info.filesel));

  return info.filename;
}


void
fin_date_stringize (gchar * buf, gint len, GDate * date)
{
  fin_trace("");

  g_return_if_fail(date);
  g_return_if_fail(buf);

  g_date_strftime(buf, len, "%d %b %Y", date);
}

