

#ifndef MATCHER_H__
#define MATCHER_H__

#include <stdio.h>
#include <regex.h>

enum match_type_t { MATCH_FIXED, MATCH_EXACT, MATCH_REGEX };

union pattern_t {
  const char * fixed;
  regex_t * regex;
};

struct matcher_t {
  enum match_type_t type;
  int case_sensitive; /* flag */
  int show_fieldnames; /* flag */
  int exact_match; /* flag */
  int inverse; /* flag: true iff print those paras that don't match */
  const char * field;
  union pattern_t pattern;
};

/* Return true if all went well. */
int
grep_control (struct matcher_t * matcher, FILE * f, char * show_fields [],
              const char * fname);

char *
get_regerror (int errcode, regex_t *compiled);

#endif /* MATCHER_H__ */
