/*
 * Hardware tuning for the Intel 82439TX PCI bridges.
 *	82439TX MTXC
 */

#include "82439.h"
#define Intel_82439_TWEAKSIZE sizeof(Intel_82439_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_Intel_82439TX(struct pci_dev *current_dev)
{
	return Intel_82439_TWEAKSIZE;
}

void init_Intel_82439TX(struct pci_dev *current_dev)
{
	init_tweaks(Intel_82439_TWEAKSIZE, Intel_82439_Tweaks, current_dev);
}

void tune_Intel_82439TX(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_82439_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_82439TX(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_82439_TWEAKSIZE, Intel_82439_Tweaks, current_dev);
}
