;;; -*- Mode:Emacs-Lisp -*-

;; Runtime support for the new optimizing byte compiler.  
;; By Jamie Zawinski <jwz@lucid.com>.
;; Last Modified: 12-jun-92.
;;
;; The code in this file should always be loaded, because it defines things 
;; like "defsubst" which should work interpreted as well.  The code in 
;; bytecomp.el and byte-optimize.el can be loaded as needed.
;;
;; This should be loaded by loadup.el or startup.el.  If you can't modify
;; those files, load this from your .emacs file.  But if you are using
;; emacs18, this file must be loaded before any .elc files which were
;; generated by the new compiler without emacs18 compatibility turned on.
;; If this file is loaded, certain emacs19 binaries will run in emacs18.
;; Meditate on the meanings of byte-compile-generate-emacs19-bytecodes and
;; byte-compile-emacs18-compatibility.


;; Copyright (C) 1985, 1986, 1987, 1992 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;; emacs-18 compatibility.

(if (fboundp 'make-byte-code)
    nil
  ;;
  ;; To avoid compiler bootstrapping problems, this temporary uncompiled
  ;; make-byte-code is needed to load the compiled one.  Ignore the warnings.
  (fset 'make-byte-code
	'(lambda (arglist bytestring constants stackdepth doc)
	   (list 'lambda arglist doc
		 (list 'byte-code bytestring constants stackdepth))))
  ;;
  ;; Now get a compiled version.
  (defun make-byte-code (arglist bytestring constants stackdepth
				 &optional doc &rest interactive)
    "For compatibility with Emacs19 ``.elc'' files."
    (nconc (list 'lambda arglist)
	   ;; #### Removed the (stringp doc) for speed.  Because the V19
	   ;;	make-byte-code depends on the args being correct, it won't
	   ;;	help to make a smarter version for V18 alone.
	   ;;	Btw, it should have been (or (stringp doc) (natnump doc)).  
	   (if doc (list doc))
	   (if interactive
	       (list (cons 'interactive (if (car interactive) interactive))))
	   (list (list 'byte-code bytestring constants stackdepth)))))


;;; interface to selectively inlining functions.
;;; This only happens when source-code optimization is turned on.

;; Redefined in byte-optimize.el.
(fset 'inline 'progn)
(put 'inline 'lisp-indent-hook 0)


;;; Interface to inline functions.

(defmacro proclaim-inline (&rest fns)
  "Cause the named functions to be open-coded when called from compiled code.
They will only be compiled open-coded when byte-compile-optimize is true."
  (cons 'eval-and-compile
	(mapcar '(lambda (x)
		   (or (memq (get x 'byte-optimizer)
			     '(nil byte-compile-inline-expand))
		       (error
			"%s already has a byte-optimizer, can't make it inline"
			x))
		   (list 'put (list 'quote x)
			 ''byte-optimizer ''byte-compile-inline-expand))
		fns)))


(defmacro proclaim-notinline (&rest fns)
  "Cause the named functions to no longer be open-coded."
  (cons 'eval-and-compile
	(mapcar '(lambda (x)
		   (if (eq (get x 'byte-optimizer) 'byte-compile-inline-expand)
		       (put x 'byte-optimizer nil))
		   (list 'if (list 'eq (list 'get (list 'quote x) ''byte-optimizer)
				   ''byte-compile-inline-expand)
			 (list 'put x ''byte-optimizer nil)))
		fns)))

;; This has a special byte-hunk-handler in bytecomp.el.
(defmacro defsubst (name arglist &rest body)
  "Same syntax as defun, but the defined function will always be open-coded,
so long as byte-compile-optimize is true."
  (list 'prog1
	(cons 'defun (cons name (cons arglist body)))
	(list 'proclaim-inline name)))

(defun make-obsolete (fn new)
  "Make the byte-compiler warn that FUNCTION is obsolete,
and NEW should be used instead.  If NEW is a string, then that is the
`use instead' message."
  (interactive "aMake function obsolete: \nxObsoletion replacement: ")
  (let ((handler (get fn 'byte-compile)))
    (if (eq 'byte-compile-obsolete handler)
	(setcar (get fn 'byte-obsolete-info) new)
      (put fn 'byte-obsolete-info (cons new handler))
      (put fn 'byte-compile 'byte-compile-obsolete)))
  fn)

(defun make-obsolete-variable (var new)
  "Make the byte-compiler warn that VARIABLE is obsolete,
and NEW should be used instead.  If NEW is a string, then that is the
`use instead' message."
  (interactive
   (list
    (let ((str (completing-read "Make variable obsolete: " obarray 'boundp t)))
      (if (equal str "") (error ""))
      (intern str))
    (car (read-from-string (read-string "Obsoletion replacement: ")))))
  (put var 'byte-obsolete-variable new)
  var)

(put 'dont-compile 'lisp-indent-hook 0)
(defmacro dont-compile (&rest body)
  "Like progn, but the body will always run interpreted (not compiled).
If you think you need this, you're probably making a mistake somewhere."
  (list 'eval (list 'quote (if (cdr body) (cons 'progn body) (car body)))))


;;; interface to evaluating things at compile time and/or load time
;;; these macro must come after any uses of them in this file, as their
;;; definition in the file overrides the magic definitions on the
;;; byte-compile-macro-environment.

(put 'eval-when-compile 'lisp-indent-hook 0)
(defmacro eval-when-compile (&rest body)
  "Like progn, but evaluates the body at compile-time.  The result of the
body appears to the compiler as a quoted constant."
  ;; Not necessary because we have it in b-c-initial-macro-environment
  ;; (list 'quote (eval (cons 'progn body)))
  (cons 'progn body))

(put 'eval-and-compile 'lisp-indent-hook 0)
(defmacro eval-and-compile (&rest body)
  "Like progn, but evaluates the body at compile-time as well as at load-time."
  ;; Remember, it's magic.
  (cons 'progn body))


;;; Interface to file-local byte-compiler parameters.
;;; Redefined in bytecomp.el.

(put 'byte-compiler-options 'lisp-indent-hook 0)
(defmacro byte-compiler-options (&rest args)
  "Set some compilation-parameters for this file.  This will affect only the
file in which it appears; this does nothing when evaluated, and when loaded
from a .el file.

Each argument to this macro must be a list of a key and a value.

  Keys:		  Values:		Corresponding variable:

  verbose	  t, nil		byte-compile-verbose
  optimize	  t, nil, source, byte	byte-compile-optimize
  warnings	  list of warnings	byte-compile-warnings
		      Legal elements: (callargs redefine free-vars unresolved)
  file-format	  emacs18, emacs19	byte-compile-emacs18-compatibility
  new-bytecodes	  t, nil		byte-compile-generate-emacs19-bytecodes

For example, this might appear at the top of a source file:

    (byte-compiler-options
      (optimize t)
      (warnings (- free-vars))		; Don't warn about free variables
      (file-format emacs19))"
  nil)
