/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/stat.c,v 1.10 1997/08/13 12:24:58 werner Rel $
 *
 * Statistik-Modul
 *
 ***************************************************************************/


#include "ytree.h"



static void PrettyPrintNumber(int y, int x, long unsigned int number);


void DisplayDiskStatistic(void)
{
  const char *fmt= "[%-14s]";
  char buff[17];
  *buff = '\0';
  
  sprintf( buff, fmt, statistic.file_spec);
  PrintMenuOptions( stdscr, 2, COLS - 15, buff, MENU_COLOR, HIMENUS_COLOR);
  *buff = '\0';
  sprintf( buff, fmt, statistic.disk_name);
  PrintMenuOptions( stdscr, 4, COLS - 15, buff, MENU_COLOR, HIMENUS_COLOR);
  PrettyPrintNumber( 6,  COLS - 13, statistic.disk_space );
  PrintOptions( stdscr, 8,  COLS - 21, "[DISK Statistics]" );
  PrettyPrintNumber( 10, COLS - 13, statistic.disk_total_files );
  PrettyPrintNumber( 11, COLS - 13, statistic.disk_total_bytes );
  PrettyPrintNumber( 13, COLS - 13, statistic.disk_matching_files );
  PrettyPrintNumber( 14, COLS - 13, statistic.disk_matching_bytes );
  PrettyPrintNumber( 16, COLS - 13, statistic.disk_tagged_files );
  PrettyPrintNumber( 17, COLS - 13, statistic.disk_tagged_bytes );
  PrintOptions( stdscr, 18, COLS - 20, "[Current Directory ]");
  wnoutrefresh( stdscr );
  return;
}



void DisplayAvailBytes(void)
{
  PrettyPrintNumber( 6,  COLS - 13, statistic.disk_space );
  wnoutrefresh( stdscr );
}




void DisplayFileSpec(void)
{
  mvwprintw( stdscr, 2,  COLS - 15, "%-14s", statistic.file_spec );

  wnoutrefresh( stdscr );
}




void DisplayDirStatistic(DirEntry *dir_entry)
{
  char format[10];
  char buffer[PATH_LENGTH + 1];
  char auxbuff[PATH_LENGTH + 1];

  *auxbuff = *buffer = '\0';
  (void) sprintf( format, "[%%-%ds]", COLS - 7 );
  (void) GetPath( dir_entry, statistic.path );
  if (dir_entry -> not_scanned)
     strcat(statistic.path,"*");
  sprintf(auxbuff, format, FormFilename( buffer, statistic.path, COLS - 7 ));
  PrintMenuOptions( stdscr, 0, 6, auxbuff, MENU_COLOR, HIMENUS_COLOR);
  PrintOptions( stdscr, 8,  COLS - 21, "[DIR Statistics ]" );
  PrettyPrintNumber( 10, COLS - 13, dir_entry->total_files );
  PrettyPrintNumber( 11, COLS - 13, dir_entry->total_bytes );
  PrettyPrintNumber( 13, COLS - 13, dir_entry->matching_files );
  PrettyPrintNumber( 14, COLS - 13, dir_entry->matching_bytes );
  PrettyPrintNumber( 16, COLS - 13, dir_entry->tagged_files );
  PrettyPrintNumber( 17, COLS - 13, dir_entry->tagged_bytes );
  PrintOptions( stdscr, 18, COLS - 20, "[Current File     ]" );
  wnoutrefresh( stdscr );
  return;
}





void DisplayDirTagged(DirEntry *dir_entry)
{
  PrettyPrintNumber( 16, COLS - 13, dir_entry->tagged_files );
  PrettyPrintNumber( 17, COLS - 13, dir_entry->tagged_bytes );
  
  wnoutrefresh( stdscr );
}



void DisplayDiskTagged(void)
{
  PrettyPrintNumber( 16, COLS - 13, statistic.disk_tagged_files );
  PrettyPrintNumber( 17, COLS - 13, statistic.disk_tagged_bytes );
  
  wnoutrefresh( stdscr );
}



void DisplayDirParameter(DirEntry *dir_entry)
{
  char *p, *f;
  char format[10];
  char buffer[PATH_LENGTH + 1];
  char auxbuff[PATH_LENGTH + 1];

  p = strrchr( dir_entry->name, FILE_SEPARATOR_CHAR ); 
 
  if( p == NULL ) f = dir_entry->name;
  else            f = p + 1;
 
  (void) sprintf( format, "[%%-%ds]", COLS - 7 );
  (void) GetPath( dir_entry, statistic.path );
  if (dir_entry -> not_scanned)
     strcat(statistic.path,"*");
  sprintf(auxbuff, format, FormFilename(buffer,statistic.path,COLS-7));
  PrintMenuOptions( stdscr,0,6,auxbuff, MENU_COLOR, HIMENUS_COLOR);
  *auxbuff = '\0';
  sprintf(auxbuff, "[%-17s]", CutFilename(buffer, f, 17));
  PrintMenuOptions( stdscr, 19, COLS - 19, auxbuff, MENU_COLOR, HIMENUS_COLOR);
  PrettyPrintNumber( 20, COLS - 13, (unsigned long) dir_entry->total_bytes );
  wnoutrefresh( stdscr );
}






void DisplayGlobalFileParameter(FileEntry *file_entry)
{
  char buffer1[PATH_LENGTH+1];
  char buffer2[PATH_LENGTH+1];
  char format[10];

  (void) sprintf( format, "[%%-%ds]", COLS - 7 );
  (void) GetPath( file_entry->dir_entry, buffer1 );
  FormFilename( buffer2, buffer1, COLS - 7 );
  sprintf(buffer1, format, buffer2);
  PrintMenuOptions( stdscr, 0, 7, buffer1, GLOBAL_COLOR, HIGLOBAL_COLOR);
  CutFilename( buffer1, file_entry->name, 17 );
  sprintf( buffer2, "[%-17s]", buffer1 );
  PrintMenuOptions( stdscr, 19, COLS - 19, buffer2, GLOBAL_COLOR, HIGLOBAL_COLOR);
  PrettyPrintNumber( 20, COLS - 13, (unsigned long) file_entry->stat_struct.st_size );
  wnoutrefresh( stdscr );
}




void DisplayFileParameter(FileEntry *file_entry)
{
  char buffer[18];
  char auxbuff[19];
  sprintf( auxbuff, "[%-17s]", CutFilename( buffer, file_entry->name, 17 ) );
  PrintMenuOptions( stdscr, 19, COLS - 19, auxbuff, MENU_COLOR, HIMENUS_COLOR);
  PrettyPrintNumber( 20, COLS - 13, (unsigned long) file_entry->stat_struct.st_size );
  wnoutrefresh( stdscr );
}



void PrettyPrintNumber(int y, int x, long unsigned int number)
{
  char buffer[16];
  long billion, million, thousand, one;
  
  *buffer = 0;
  billion  = (long) ( number / 1000000000L );
  million  = (long) ( number / 1000000L );
  thousand = (long) ( ( number % 1000000L ) / 1000L );
  one      = (long) ( number % 1000L );

  if( billion ){
     sprintf( buffer, "[%2ld%03ld%03ld%03ld]", billion, million, thousand, one);
     PrintMenuOptions( stdscr, y, x, buffer, MENU_COLOR, HIMENUS_COLOR);
     }
  else if( million ) {
     sprintf( buffer, "[%3ld.%03ld.%03ld]", million, thousand, one);
     PrintMenuOptions( stdscr, y, x, buffer, MENU_COLOR, HIMENUS_COLOR);
     }
  else if( thousand ) {
     sprintf( buffer, "[    %3ld.%03ld]", thousand, one);
     PrintMenuOptions( stdscr, y, x, buffer, MENU_COLOR, HIMENUS_COLOR);
     }
  else {
     sprintf( buffer, "[        %3ld]", one);
     PrintMenuOptions( stdscr, y, x, buffer, MENU_COLOR, HIMENUS_COLOR);
     }
 return;
}



