<?php

##
## Copyright (c) 1999 Daniel J. Lashua <djl@inkshop.org>
## 
## $Id: ct_informix.inc,v 1.1 1999/11/03 17:26:33 kk Exp $
##
## PHPLIB Data Storage Container using an Informix Server 
##

class CT_Informix {
  ##
  ## Define these parameters by overwriting or by
  ## deriving your own class from it (recommened)
  ##
  
  var $database_host = "";
  var $database_name = "";
  var $database_username = "";
  var $database_password = "";
  var $database_table = "";

  ## end of configuration

  var $linkid;
  var $db;

  function ac_start() {
    $this->linkid = ifx_pconnect($this->database_name . "@" . $this->database_host,$this->database_username,$this->database_password);
  }

  function ac_get_lock() {
  }

  function ac_release_lock() {
  }

  function ac_gc($gc_time, $name) {
    $timeout = time();
    $sqldate = date("YmdHis", $timeout - ($gc_time * 60));
    ifx_query(sprintf("DELETE FROM %s ".
          "WHERE changed < '%s' AND name = '%s'",
          $this->database_table, 
          $sqldate,
          $name),$this->linkid);
  }

  function ac_store($id, $name, $str) {
    $ret = true;
    $name = addslashes($name);
    $blobid = ifx_create_blob(1,0,0);
    $blobidary[] = $blobid;
    ifx_update_blob($blobid,$str);  
    $resid = @ifx_query(sprintf("UPDATE %s SET val=?, changed='%s' ".
          "WHERE sid='%s' AND name='%s'",
          $this->database_table,
          $now = date("YmdHis", time()),
          $id,
          $name),$this->linkid,$blobidary);
    if(ifx_affected_rows($resid) == 0 &&
      !ifx_query(sprintf("INSERT INTO %s " .
            " (sid,name,val,changed) " .
            "VALUES ".
            "('%s','%s',?,'%s')",
            $this->database_table,
            $id,
            $name,
            $now),$this->linkid,$blobidary)) {
        $ret = false;
    }
    return $ret;
  }

  function ac_delete($id, $name) {
    ifx_query(sprintf("DELETE FROM %s ".
          "WHERE name = '%s' AND sid = '%s'",
          $this->database_table,
          addslashes($name),
          $id),$this->linkid);
  }

  function ac_get_value($id, $name) {
    ifx_textasvarchar(0);
    $resid = ifx_query(sprintf("SELECT val FROM %s ".
              "WHERE sid  = '%s' AND name = '%s'",
          $this->database_table,
          addslashes($id),
          addslashes($name)),$this->linkid);
    if($data = @ifx_fetch_row($resid)) {
      return ifx_get_blob($data["val"]);
    } else {
      return "";
    }
  }

  function ac_newid($str, $name) {
    return $str;
  }

  function ac_halt($s) {
  }



}
?>
