#ifndef HTML_H
#define HTML_H

/* html elements */
static gchar* html_tags[] = {
	"!--", "!doctype", "a", "abbr", "acronym", "address", "applet",
	"area", "b", "base", "basefont", "bdo", "big", "blockquote", "body",
	"br", "button",	"caption", "center", "cite", "code", "col", 
	"colgroup", "dd", "del", "dfn", "dir", "div", "dl", "dt", "em",
	"fieldset", "font", "form", "frame", "frameset", "h1", "h2", "h3",
	"h4", "h5", "h6", "head", "hr", "html", "i", "iframe", "img", "input", 
	"ins", "isindex", "kdb", "label", "legend", "li", "link", "map", 
	"menu", "meta",	"noframes", "noscript", "object", "ol", "optgroup",
	"option", "p", "param", "pre", "q", "s", "samp", "script", "select",
	"small", "span", "strike", "strong", "style", "sub", "table", "tbody",
	"td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt",
	"u", "ul", "var", NULL
};

typedef enum _CloseState {
	OPTIONAL = 1,
	REQUIRED = 2,
	FORBIDDEN = 0
} CloseState;

static const CloseState html_tags_close[] = {
	FORBIDDEN, FORBIDDEN, REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED,
	FORBIDDEN, REQUIRED, FORBIDDEN, FORBIDDEN, REQUIRED, REQUIRED, 
	REQUIRED, OPTIONAL, FORBIDDEN, REQUIRED, REQUIRED, REQUIRED, 
	REQUIRED, REQUIRED, FORBIDDEN, OPTIONAL, OPTIONAL, REQUIRED,
	REQUIRED, REQUIRED, REQUIRED, REQUIRED, OPTIONAL, REQUIRED,
	REQUIRED, REQUIRED, REQUIRED, FORBIDDEN, REQUIRED, REQUIRED,
	REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED, OPTIONAL,
	FORBIDDEN, OPTIONAL, REQUIRED, REQUIRED, FORBIDDEN, FORBIDDEN,
	REQUIRED, FORBIDDEN, REQUIRED, REQUIRED, REQUIRED, OPTIONAL,
	FORBIDDEN, REQUIRED, REQUIRED, FORBIDDEN, REQUIRED, REQUIRED,
	REQUIRED, REQUIRED, REQUIRED, OPTIONAL, OPTIONAL, FORBIDDEN,
	REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED,
	REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED, REQUIRED,
	REQUIRED, OPTIONAL, OPTIONAL, REQUIRED, OPTIONAL, OPTIONAL, OPTIONAL,
	REQUIRED, OPTIONAL, REQUIRED, REQUIRED, REQUIRED, REQUIRED
};

/* 93 but we start counting at 0 */
static const int html_tags_size = 92;

/* 
   attribute popup menus for the html tags 
   format:
   <attribute name>, value, value, value, ..., NULL
   if value = "*" then it means that the entry is a submenu
   if no values its because the range of possibilities is so large, eg text
   or hex values for colours etc.
 */

/* sub menus */
static gchar* core_attributes[] = {
	"id=", NULL,
	"class=", NULL,
	"style=", NULL,
	"title=", NULL,
	NULL
};

static gchar* i18n_attributes[] = {
	"lang=", NULL,
	"dir=", "ltr", "rtl", NULL,
	NULL
};
static gchar* event_attributes[] = {
	"onclick=", NULL,
	"ondblclick=", NULL,
	"onkeydown=", NULL,
	"onkeypress=", NULL,
        "onkeyup=", NULL,
	"onmousedown=", NULL,
	"onmousemove=", NULL,
	"onmouseout=", NULL,
	"onmouseover=", NULL,
	"onmouseup=", NULL,
	NULL
};
/* tag menus */
static gchar* A_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=", NULL,
	"charset=", NULL,
        "coords=", NULL,
        "href=", NULL,
	"hreflang=", NULL,
	"name=", NULL,
	"onblur=", NULL,
	"onfocus=", NULL,
        "rel=", NULL,
	"rev=", NULL,
        "shape=", "rect", "circle", "poly", "default", NULL,
	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
	"target=", NULL,
	"type=", NULL,
	NULL
};
static gchar* standard_tag_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	NULL
};
static gchar* APPLET_popup[] = {
	"Core", "*",
	"align=", "top", "middle", "bottom", "left", "right", NULL,
	"alt=", NULL,
	"archive=", NULL,
        "code=", NULL,
        "codebase=", NULL,
        "height=", NULL,
	"hspace=", NULL,
	"object=", NULL,
        "vspace=", NULL,
	NULL
};
static gchar* AREA_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=", NULL,
        "alt=", NULL,
	"href=", NULL,
	"nohref", NULL,
	"onblur=", NULL,
        "onfocus=", NULL,
	"shape=", "rect", "circle", "poly", "default", NULL,
	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
        "target=", NULL,
	NULL
};
static gchar* BASE_popup[] = {
	"href=", NULL,
	"target=", NULL,
	NULL
};
static gchar* BASEFONT_popup[] = {
	"color=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"face=", NULL,
	"id=", NULL,
	"size=", NULL,
     	NULL
};
static gchar* BDO_popup[] = {
	"Core", "*",
	"i18n", "*",
	NULL
};
static gchar* QUOTE_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"cite=", NULL,
        NULL
};
static gchar* BODY_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"alink=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"background=", NULL,
	"bgcolor=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"link=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"onload=", NULL,
	"onunload=", NULL,
	"text=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"vlink=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	NULL
};
static gchar* BR_popup[] = {
	"Core", "*",
	"clear=", "none", "left", "right", "all", NULL,
        NULL
};
static gchar* BUTTON_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=", NULL,
        "disabled", NULL,
	"name=", NULL,
        "onblur=", NULL,
	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
	"value=", NULL,
        NULL
};
static gchar* CAPTION_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "top", "bottom", "left", "right", NULL,
	NULL
};
static gchar* COL_COLGROUP_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "left", "center", "right", "justify", "char", NULL,
	"char=", NULL,
	"charoff=", NULL,
	"span=", NULL,
	"valign=", "top", "middle", "bottom", "baseline", NULL,
	"width=", NULL,
	NULL
};
static gchar* DEL_INS_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"cite=", NULL,
	"datetime=", NULL,
        NULL
};
static gchar* DIR_MENU_DL_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"compact", NULL,
	NULL
};
static gchar* DIV_H_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "left", "center", "right", "justify", NULL,
	NULL
};
static gchar* FONT_popup[] = {
	"Core", "*",
	"i18n", "*",
	"color=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"face=", NULL,
	"size=", NULL,
	NULL
};
static gchar* FORM_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accept-charset=", NULL,
	"action=", NULL,
        "enctype=", NULL,
        "method=", "GET", "POST", NULL,
        "onreset=", NULL,
        "onsubmit=", NULL,
	NULL
};
static gchar* FRAME_popup[] = {
	"Core", "*",
	"frameborder=", "1", "0", NULL,
	"longdesc=", NULL,
	"marginheight=", NULL,
	"marginwidth=", NULL,
        "name=", NULL,
	"noresize", NULL,
	"scrolling=", "yes", "no", "auto", NULL,
	"src=", NULL,
	NULL
};
static gchar* FRAMESET_popup[] = {
	"Core", "*",
	"cols=", NULL,
	"onload=", NULL,
	"onunload=", NULL,
	"rows=", NULL,
	NULL
};
static gchar* HEAD_popup[] = {
	"i18n", "*",
	"profile=", NULL,
	NULL
};
static gchar* HR_popup[] = {
	"Core", "*",
	"Events", "*",
	"align=", "left", "center", "right", NULL,
	"noshade", NULL,
	"size=", NULL,
	"width=", NULL,
	NULL
};
static gchar* HTML_popup[] = {
	"i18n", "*",
	"version=", NULL,
        NULL
};
static gchar* IFRAME_popup[] = {
	"Core", "*",
	"align=", "left", "center", "right", "justify", "char", NULL,
	"frameborder=", "1", "0", NULL,
        "height=", NULL,
        "longdesc=", NULL,
        "marginheight=", NULL,
	"marginwidth=", NULL,
        "name=", NULL,
        "scrolling", "yes", "no", "auto", NULL,
        "src=", NULL,
        "width=", NULL,
	NULL
};
static gchar* IMG_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "top", "middle", "bottom", "left", "right", NULL,
	"alt=", NULL,
        "border=", NULL,
	"height=", NULL,
	"hspace=", NULL,
	"ismap", NULL,
        "longdesc=", NULL,
        "src=", NULL,
        "usemap=", NULL,
        "vspace=", NULL,
        "width=", NULL,
        NULL
};
static gchar* INPUT_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accept=", NULL,
        "accesskey=", NULL,
	"align=", "left", "center", "right", "justify", NULL,
        "alt=", NULL,
        "checked", NULL,
        "disabled", NULL,
        "maxlength=", NULL,
	"name=", NULL,
        "onblur=", NULL,
	"onchange=", NULL,
        "onselect=", NULL,
	"readonly", NULL,
        "size=", NULL,
	"src=", NULL,
      	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
	"type=", "text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button", NULL,
	"value=", NULL,
        NULL
};
static gchar* ISINDEX_popup[] = {
	"Core", "*",
	"i18n", "*",
	"prompt=", NULL,
        NULL
};
static gchar* LABEL_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=", NULL,
	"for=", NULL,
        "onblur=", NULL,
        "onfocus", NULL,
        NULL
};
static gchar* LEGEND_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=", NULL,
	"align=", "top", "bottom", "left", "right", NULL,
	NULL
};
static gchar* LI_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"type=", "disc", "square", "circle", "1", "a", "A", "i", "I", NULL,
	"value=", NULL,
        NULL
};
static gchar* LINK_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"href=", NULL,
	"hreflang=", NULL,
        "media=", NULL,
	"rel=", NULL,
	"rev=", NULL,
        "target=", NULL,
	"type=", NULL,
        NULL
};
static gchar* MAP_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"name=", NULL,
	NULL
};
static gchar* META_popup[] = {
	"i18n", "*",
	"content=", NULL,
	"http-equiv=", NULL,
	"name=", NULL,
	"scheme=" , NULL,
	NULL
};
static gchar* OBJECT_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "top", "middle", "bottom", "left", "right", NULL,
	"archive=", NULL,
	"border=", NULL,
	"classid=", NULL,
	"codebase=", NULL,
        "codetype=", NULL,
	"data=", NULL,
	"declare", NULL,
	"height=", NULL,
	"hspace=", NULL,
	"name=", NULL,
	"standby=", NULL,
	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
	"type=", NULL,
	"usemap=", NULL,
	"vspace=", NULL,
	"width=", NULL,
	NULL
};
static gchar* OL_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"compact", NULL,
	"type=", "1", "a", "A", "i", "I",NULL,
	NULL
};
static gchar* OPTGROUP_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"disabled", NULL,
	"label=", NULL,
	NULL
};
static gchar* OPTION_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"disabled", NULL,
	"label=", NULL,
	"selected", NULL,
	"value=", NULL,
	NULL
};
static gchar* PARAM_popup[] = {
	"Events", "*",
	"id=", NULL,
        "name=", NULL,
	"type=", NULL,
	"value=", NULL,
	"valuetype", "DATA", "REF", "OBJECT", NULL,
        NULL
};
static gchar* PRE_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"width=", NULL,
        NULL
};
static gchar* SCRIPT_popup[] = {
	"charset=", NULL,
        "defer", NULL,
	"language=", NULL,
        "src=",  NULL,
	"type=", NULL,
	NULL
};
static gchar* SELECT_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"disabled", NULL,
	"multiple", NULL,
	"name=", NULL,
	"onblur=", NULL,
        "onchange=", NULL,
        "onfocus=", NULL,
	"size=", NULL,
	NULL
};
static gchar* STYLE_popup[] = {
	"i18n", "*",
	"media=", NULL,
	"title=", NULL,
	"type=", NULL,
	NULL
};
static gchar* TABLE_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "left", "center", "right", NULL,
	"bgcolor=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
        "border=", NULL,
        "cellpadding=", NULL,
        "cellspacing=", NULL,
        "frame=", "void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border", NULL,
        "rules=", "none", "groups", "rows", "cols", "all", NULL,
	"summary=", NULL,
	"width=", NULL,
	NULL
};
static gchar* TBODY_TFOOT_THEAD_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "left", "center", "right", "justify", "char", NULL,
	"char=", NULL,
	"charoff=", NULL,
	"valign=", "top", "middle", "bottom", "baseline", NULL,
	NULL
};
static gchar* TD_TH_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"abbr=", NULL,
	"align=", "left", "center", "right", "justify", "char", NULL,
	"axis=", NULL,
	"bgcolor=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua", NULL,
	"char=", NULL,
	"charoff=", NULL,
	"colspan=", NULL,
	"headers=", NULL,
	"height=", NULL,
	"nowrap", NULL,
	"rowspan=", NULL,
	"scope=", "row", "col", "rowgroup", "colgroup", NULL,
	"valign=", "top", "middle", "bottom", "baseline", NULL,
        "width=", NULL,
	NULL
};
static gchar* TEXTAREA_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"accesskey=",  NULL,
        "cols=", NULL,
        "disabled", NULL,
	"name=", NULL,
	"onblur=", NULL,
	"onchange=", NULL,
	"onfocus=", NULL,
	"onselect=", NULL,
        "readonly", NULL,
	"rows=", NULL,
	"tabindex=", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", NULL,
	NULL
};
static gchar* TITLE_popup[] = {
	"lang=", NULL,
	"dir=", "ltr", "rtl", NULL,
	NULL
};
static gchar* TR_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"align=", "left", "center", "right", "justify", "char", NULL,
	"bgcolor=", "Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua",NULL,
	"char=", NULL,
	"charoff=", NULL,
	"valign=", "top", "middle", "bottom", "baseline", NULL,
	NULL
};
static gchar* UL_popup[] = {
	"Core", "*",
	"i18n", "*",
	"Events", "*",
	"compact", NULL,
	"type", "disc", "square", "circle", NULL,
        NULL
};

/* complete array of tag popups */
static gchar** html_tag_popups[] = {
	NULL, NULL, A_popup, standard_tag_popup, standard_tag_popup,
	standard_tag_popup, APPLET_popup, AREA_popup, standard_tag_popup,
	BASE_popup, BASEFONT_popup, BDO_popup, standard_tag_popup,
	QUOTE_popup, BODY_popup, BR_popup, BUTTON_popup, 
	CAPTION_popup, standard_tag_popup, standard_tag_popup,
	standard_tag_popup, COL_COLGROUP_popup, COL_COLGROUP_popup,
	standard_tag_popup, DEL_INS_popup, standard_tag_popup,
	DIR_MENU_DL_popup, DIV_H_popup, DIR_MENU_DL_popup, standard_tag_popup,
	standard_tag_popup, standard_tag_popup, FONT_popup, FORM_popup,
	FRAME_popup, FRAMESET_popup, DIV_H_popup, DIV_H_popup, 
	DIV_H_popup, DIV_H_popup, DIV_H_popup, DIV_H_popup, HEAD_popup,
	HR_popup, HTML_popup, standard_tag_popup, IFRAME_popup, IMG_popup,
	INPUT_popup, DEL_INS_popup, ISINDEX_popup, standard_tag_popup,
	LABEL_popup, LEGEND_popup, LI_popup, LINK_popup, MAP_popup,
	DIR_MENU_DL_popup, META_popup, standard_tag_popup, standard_tag_popup,
	OBJECT_popup, OL_popup, OPTGROUP_popup, OPTION_popup, DIV_H_popup,
	PARAM_popup, PRE_popup, QUOTE_popup, standard_tag_popup,
	standard_tag_popup, SCRIPT_popup, SELECT_popup,	standard_tag_popup,
	standard_tag_popup, standard_tag_popup,	standard_tag_popup,
	STYLE_popup, standard_tag_popup, TABLE_popup, TBODY_TFOOT_THEAD_popup,
	TD_TH_popup, TEXTAREA_popup, TBODY_TFOOT_THEAD_popup, TD_TH_popup,
	TBODY_TFOOT_THEAD_popup, TITLE_popup, TR_popup, standard_tag_popup,
	standard_tag_popup, UL_popup, standard_tag_popup
};

/* html entities */
static gchar* ISO_8859_1[] = {
	"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar",
	"sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg",
	"macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro",
	"para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14",
	"frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc",
	"Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave",
	"Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc",
	"Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde",
	"Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml",
	"Yacute", "THORN", "szlig", "agrave", "aacute", "acirc",
	"atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute",
	"ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth",
	"ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide",
	"oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn",
	"yuml", NULL
};
static gchar* MATH_GREEK_SYMBOLIC[] = {
	"fnof", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta",
	"Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron",
	"Pi", "Rho", "Sigma", "Tau", "Uplsilon", "Phi", "Chi", "Psi", "Omega",
	"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta",
	"iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho",
	"sigmaf","sigma", "tau", "upsilon", "phi", "chi", "psi", "omega",
	"thetasym", "upsih", "piv", "bull", "hellip", "prime", "Prime",
	"oline", "frasl", "weierp", "image", "real", "trade", "alefsym",
	"larr", "uarr", "rarr", "darr", "harr", "crarr", "lArr", "uArr",
	"rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla",
	"isin" "notin", "ni", "prod", "sum", "minus", "lowast", "radic", 
	"prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4",
	"sim", "cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup",
	"nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot", "lceil",
	"rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs",
	"hearts", "diams", NULL
};

static gchar* MARKUP_INTL[] = {
	"quot", "amp", "lt", "gt", "OElig", "oelig", "Scaron", "scaron",
	"Yuml", "circ", "tilde", "ensp", "emsp", "thinsp", "zwnj", "zwj", 
	"lrm", "rlm", "ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo",
	"rdquo", "bdquo", "dagger", "Dagger", "permil", "lsaquo", "rsaquo",
	"euro",	NULL
};

static gchar** HTML_ENTITIES[] = {
	ISO_8859_1,
	MATH_GREEK_SYMBOLIC,
	MARKUP_INTL,
	NULL
};


/* html tag groups */

static gchar* GLOBAL_STRUCTURE[] = { 
	N_( "Document Structure" ),
	"!--",
	"--",
	"!doctype",
	"body",
	"html",
	"head",
	"meta",
	"title",
	NULL
};

static gchar* BODY_STRUCTURE[] = {
	N_( "Body Structure" ),
	"address",
	"center",
	"div",
	"h1",
	"h2",
	"h3",
	"h4",
	"h5",
	"h6",
	"span",
	NULL
};

static gchar* TEXT_DIRECTION[] = {
	N_( "Text Direction" ),
	"bdo",
	NULL
};

static gchar* TEXT_STRUCTURE[] = {
	N_( "Text Structure" ),
	"abbr",
	"acronym",
	"blockquote",
	"cite",
	"code",
	"dfn",
	"em",
	"kbd",
	"q",
	"samp",
	"strong",
	"sub",
	"sup",
	"var",
	NULL
};

static gchar* TEXT_PARAGRAPHS[] = {
	N_( "Lines / Paragraphs" ),
	"br",
	"hr",
	"p",
	"pre",
	NULL
};

static gchar* TEXT_CHANGES[] = {
	N_( "Text changes markup" ),
	"del",
	"ins",
	NULL
};

static gchar* LISTS[] = {
	N_( "Lists" ),
	"dd",
	"dir",
	"dl",
	"dt", 
	"li",
	"menu",
	"ol",
	"ul",
	NULL
};

static gchar* TABLES[] = {
	N_( "Tables" ),
	"caption",
	"col",
	"colgroup",
	"table",
	"tbody",
	"td",
	"tfoot",
	"th",
	"thead",
	"tr", 
	NULL
};

static gchar* LINKS[] = {
	N_( "Links" ),
	"a", 
	"base",
	"link",
	NULL
};

static gchar* OBJECTS[] = {
	N_( "Images and other objects" ),
	"applet",
	"area",
	"img",
	"map",
	"object",
	"param",
	NULL
};

static gchar* STYLE_SHEETS[] = {
	N_( "Style sheets" ),
	"style",
	NULL
};

static gchar* FONTS[] = {
	N_( "Font style" ),
	"b",
	"basefont",
	"big",
	"font",
	"i", 
	"s", 
	"small",
	"strike",
	"tt",
	"u",
	NULL
};

static gchar* FRAMES[] = {
	N_( "Frames" ),
	"frame",
	"frameset",
	"iframe",
	"noframes",
	NULL
};

static gchar* FORMS[] = {
	N_( "Forms" ),
	"button", 
	"fieldset",
	"form",
	"input",
	"isindex",
	"label",
	"legend",
	"optgroup",
	"option",
	"select",
	"textarea",
	NULL
};

static gchar* SCRIPTS[] = {
	N_( "Scripts" ),
	"noscript",
	"script",
	NULL
};

static gchar* JSP[] = {
	N_( "JSP Scriptlets" ),
	"?",
	NULL
};

static gchar* unknown_tags = N_( "Unknown Tags" );

static gchar** TAG_GROUPS[] = {
	GLOBAL_STRUCTURE,
        BODY_STRUCTURE,
        TEXT_DIRECTION,
        TEXT_STRUCTURE,
        TEXT_PARAGRAPHS,
        TEXT_CHANGES,
        LISTS,
        TABLES,
        LINKS,
        OBJECTS,
        STYLE_SHEETS,
        FONTS,
        FRAMES,
        FORMS,
        SCRIPTS,
	JSP,
	NULL
};


#endif
