/*  Screem:  tableWizard.c
 *  The html table layout wizard, converted to being a g_module
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gmodule.h>
#include <gnome.h>

#include "site.h"
#include "page.h"
#include "editor.h"

extern GtkWidget *app;
extern Site *current_site;
extern Page *current_page;

typedef struct _TableWiz{
	GtkWidget *rows;
	GtkWidget *cols;
        /* Used to make decent spin buttons for the rows & columns */
        GtkAdjustment *rows_adj;
	GtkAdjustment *cols_adj;
   
	GtkWidget *left;
	GtkWidget *centre;
	GtkWidget *right;

	GtkWidget *caption;
	GtkWidget *above;
	GtkWidget *below;

	GtkWidget *border;
        GtkAdjustment *bwidth_adj;
        GtkWidget *borderPixels;

	GtkWidget *cellSpacing;
        GtkAdjustment *spacing_adj;
        GtkWidget *cellPadding;
        GtkAdjustment *padding_adj;
   
	GtkWidget *setWidth;
	GtkWidget *width;
	GtkWidget *wPixels;
        GtkWidget *wPercent;

	GtkWidget *setHeight;
	GtkWidget *height;
	GtkWidget *hPixels;
	GtkWidget *hPercent;
        /* Used for the table width and height adjustments */
        GtkAdjustment *tmp_wadj;
        GtkAdjustment *tmp_hadj;

	GtkWidget *useColour;
	GtkWidget *colour;

	GtkWidget *useImage;
	GtkWidget *image;
} TableWiz;

static TableWiz *tableWiz;

void tableWizard();

G_MODULE_EXPORT const gchar*
g_module_check_init( GModule *module )
{
	g_print("tableWizard: check-init\n");
	return NULL;
}

G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
	g_print( "tableWizard: unloaded\n" );
}

G_MODULE_EXPORT void 
init() 
{
	GtkWidget *tableButton;
	GtkWidget *toolbar;

	GnomeUIInfo menuinfo[] = { 
		{
			GNOME_APP_UI_ITEM, N_( "Table..." ),
			N_( "Insert a Table" ),
			tableWizard, NULL, NULL,
			GNOME_APP_PIXMAP_STOCK,
			GNOME_STOCK_MENU_BLANK,
			0,
			GDK_CONTROL_MASK, NULL
		},
		GNOMEUIINFO_END
	};

	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "wizardbar" );


	/* place menu item after image under insert */
	gnome_app_insert_menus( GNOME_APP( app ),
				_("_Insert/"), menuinfo);

	/* place a button on the wizards toolbar */
	tableButton = gnome_stock_new_with_icon(GNOME_STOCK_PIXMAP_TABLE_FILL);
	gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), "",
				 _("Table Wizard"), "", tableButton ,
				 tableWizard, 0 );

	g_print( "tableWizard: initialised\n" );
}
/******************************************************************/

/* Next 2 functions added by Lee Mallabone used in converting the relevant
 * gtk_entry widgets into spin buttons */

/* this one rewritten by David to remove the if statement as it served no
 * purpose
 */
void change_state (GtkWidget *widget, gpointer data)
{
	gtk_widget_set_sensitive( widget, !GTK_WIDGET_IS_SENSITIVE( widget ) );
}


/* made messy to suite my style, David */
void change_adjustment (GtkWidget *widget, gchar *data )
{
	/* The abstraction here isn't very nice, but I can't think of a
	 * better way to do this without a big revamp. */
	
	if( ! data )
		return;
	
	if( ! strcmp( data, "width-pixel" ) ) {
		tableWiz->tmp_wadj = (GtkAdjustment *)gtk_adjustment_new(300.0,0.0, 1280.0, 1.0, 10.0, 1.0);
		gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON( tableWiz->width ), (GtkAdjustment *)tableWiz->tmp_wadj);
		gtk_spin_button_update( GTK_SPIN_BUTTON( tableWiz->width ) );
	} else if( ! strcmp( data, "width-percent" ) ) {
		tableWiz->tmp_wadj = (GtkAdjustment *)gtk_adjustment_new( 90.0,0.0, 100.0, 1.0, 5.0, 1.0);
		gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON( tableWiz->width ), (GtkAdjustment *)tableWiz->tmp_wadj);
		gtk_spin_button_update( GTK_SPIN_BUTTON( tableWiz->width ) );
	} else if( ! strcmp( data, "height-pixel" ) ) {
		tableWiz->tmp_hadj = (GtkAdjustment *)gtk_adjustment_new( 300.0, 0.0, 1280.0, 1.0, 10.0, 1.0);
		gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON( tableWiz->height ), (GtkAdjustment *)tableWiz->tmp_hadj);
		gtk_spin_button_update( GTK_SPIN_BUTTON( tableWiz->height ) );
	} else if( ! strcmp( data, "height-percent" ) ) {
		tableWiz->tmp_hadj = (GtkAdjustment *)gtk_adjustment_new( 90.0,0.0, 100.0, 1.0, 5.0, 1.0 );
		gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON( tableWiz->height ), (GtkAdjustment *)tableWiz->tmp_hadj);
		gtk_spin_button_update( GTK_SPIN_BUTTON( tableWiz->height ) );
	}
}

static void tableWizDestroy( GtkWidget *widget, GdkEvent *event,gpointer data )
{
	gpointer *dialog = gtk_object_get_data( GTK_OBJECT( widget ), 
						"dialog" );
        *dialog = NULL;
        g_free( data );
}

static void tableWizClicked( GtkWidget *widget, gint button, gpointer data )
{
	gchar *text = NULL;
	gchar *caption = NULL;
	gint border = 0;
	gchar *dimensions = NULL;
	gchar *elements = NULL;
	gchar *align = NULL;
	gint width_value = 300;
	gint height_value = 300;
	gchar *width = NULL;
	gchar *height = NULL;
	gchar *colour = NULL;
	gchar *image = NULL;
	gchar *temp;
	GtkPropertyMark mark;
	gboolean captionTop = FALSE;
	gint cellSpacing;
	gint cellPadding;
	gint rows;
	gint cols;
	gint c;
	guint8 r, g, b, a;
	gint pos;
	gpointer *dialog = gtk_object_get_data( GTK_OBJECT( widget ), 
						"dialog" );

        /* Used to grab the gtk_entry from the gnome file_entry */
        GtkWidget *tmp;
   
	if( button < 2 ) { /* applied or ok'ed */
		
		/* do we have a caption? */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->caption ) ) )
			caption = g_strdup( "<caption> </caption>" );

		/* do we have a border? */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->border ) ) )
			border = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (tableWiz->borderPixels));

		text = g_strdup( "<table" );
		temp = text;
		text = g_strdup_printf( "%s border=%d", text, border );
		g_free( temp );
		
		/* alignement */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->left ) ) )
			align = g_strdup( " align=\"left\"" );
		else if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->centre ) ) )
			align = g_strdup( " align=\"center\"" );
		else
			align = g_strdup( " align=\"right\"" );

		/* find cellspacing/padding */
	        cellSpacing = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(tableWiz->cellSpacing));
	        cellPadding = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(tableWiz->cellPadding));

		/* find rows and cols */
	   
	        rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(tableWiz->rows));
	        cols = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(tableWiz->cols));

		/* table width set? */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->setWidth ) ) ) {
			width_value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tableWiz->width));

			if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->wPercent ) ) )
				width = g_strdup_printf( "width=%d%%", width_value );
			else
				width = g_strdup_printf( "width=%d", width_value );
		}

		/* table height set? */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->setHeight ) ) ) {
			height_value=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tableWiz->height));

			if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->hPercent ) ) )
				height = g_strdup_printf("height=%d%%",height_value);
			else
				height = g_strdup_printf( "height=%d", height_value);
		}

		/* background colour? Yes I know CSS should be used but
		   I don't know anything about them */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->useColour ) ) ) {
			gnome_color_picker_get_i8( GNOME_COLOR_PICKER( tableWiz->colour ), &r, &g, &b, &a);
			colour = g_strdup_printf( "bgcolor=\"#%.2x%.2x%.2x\"",r,g,b);
		}

		/* background image? */
		if( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->useImage ) ) ) {
		        tmp = gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY(tableWiz->image));
		        image = gtk_entry_get_text(GTK_ENTRY(tmp));
		}

		/* insert all options for table tag */
		temp = text;
		text = g_strdup_printf( "%s %s rows=%i cols=%i cellspacing=%i cellpadding=%i",
					text, align, rows, cols, cellSpacing, cellPadding );
		g_free( align );
		g_free( temp );

		if( width ) {
			temp = text;
			text = g_strdup_printf( "%s %s", temp, width );
			g_free( width );
			g_free( temp );
		}
		if( height ) {
			temp = text;
			text = g_strdup_printf( "%s %s", temp, height );
			g_free( height );
			g_free( temp );
		}

		if( colour ) {
			temp = text;
			text = g_strdup_printf( "%s %s", temp,
						colour );
			g_free( colour );
			g_free( temp );
		}

		if( image ) {
			temp = text;
			text = g_strdup_printf( "%s background=\"%s\"", temp,
						image );
			g_free( temp );
		}

		temp = text;
		text = g_strdup_printf( "%s>", temp );
		g_free( temp );

		/* if we have a caption is it for the top? */
		if( caption ) {
			captionTop = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( tableWiz->above ) );
			temp = text;
			if( captionTop ) {
				text = g_strdup_printf( "%s\n%s", text,
							caption );
				g_free( temp );
				g_free( caption );
				caption = NULL;
			}
		}

		/* insert rows/cols */
		for( ; rows; rows -- ) {
			if( elements ) {
				temp = elements;
				elements = g_strdup_printf( "%s\n<tr>\n",
							    temp );
				g_free( temp );
			} else
				elements = g_strdup( "<tr>\n" );
			for( c = 0; c < cols; c ++ ) {
				temp = elements;
				elements = g_strdup_printf("%s<td> </td>",
							   temp );
				g_free( temp );
			}
			temp = elements;
			elements = g_strdup_printf( "%s\n</tr>",
						    temp );
			g_free( temp );
		}

		if( elements ) {
			temp = text;
			text = g_strdup_printf( "%s\n%s", text, elements );
			g_free( temp );
			g_free( elements );
		}

		/* we got a caption? if yes then it must be at the bottom */
		if( caption ) {
			temp = text;
			text = g_strdup_printf( "%s\n%s", text, caption );
			g_free( temp );
			g_free( caption );
		}

		temp = text;
		text = g_strdup_printf( "%s\n%s", text, "</table>" );
		g_free( temp );

		pos = screem_editor_get_pos();
		screem_editor_insert( pos, text );
		screem_editor_set_pos( pos + strlen( text ) );

		if( text )
			g_free( text );
	}

	if( button == 2 || button == 0 ) { /* ok or close clicked */
		gtk_widget_destroy( widget );
		*dialog = NULL;
		g_free( data );
	}
}

void tableWizard()
{
	GtkWidget *box;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *frame;

	static GtkWidget *dialog = NULL;

	GSList *group = NULL;
	Page *page;

	if( current_site )
		page = screem_site_get_current_page( current_site );
	else
		page = current_page;

	g_return_if_fail( page != NULL );

	if( dialog ) {
		gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
	}

	tableWiz = (TableWiz*)g_malloc( sizeof( TableWiz ) );

	box = gtk_vbox_new( FALSE, 0 );

	/*****************************************************************/
	/* rows and columns part */
	table = gtk_table_new( 1, 4, FALSE );
	gtk_box_pack_start( GTK_BOX( box ), table, FALSE, FALSE, 0 );

	label = gtk_label_new( _("Number of rows: ") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->rows_adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 1.0, 
								   1000.0, 1.0, 
								   10.0, 1.0);
        tableWiz->rows = gtk_spin_button_new (GTK_ADJUSTMENT(tableWiz->rows_adj),
					      1.0, 0);

	gtk_widget_set_usize( tableWiz->rows, 64, -1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->rows, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

	label = gtk_label_new( _("Number of cols: ") );
	gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->cols_adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 1.0, 
								   1000.0, 1.0, 
								   10.0, 1.0);

        tableWiz->cols = gtk_spin_button_new (GTK_ADJUSTMENT(tableWiz->cols_adj),
					      1.0, 0);

	gtk_widget_set_usize( tableWiz->cols, 64, -1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->cols, 3, 4, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	/*****************************************************************/
	/* table alignement part */
	frame = gtk_frame_new( _("Table alignment") );
	gtk_box_pack_start( GTK_BOX( box ), frame, FALSE, FALSE, 0 );

	table = gtk_table_new( 1, 3, FALSE );
	gtk_container_add( GTK_CONTAINER( frame ), table );

	tableWiz->left = gtk_radio_button_new_with_label( group, _("Left") );
        group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->left ) );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->left, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->centre = gtk_radio_button_new_with_label( group, _("Center") );
        group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->centre ) );
      	gtk_table_attach( GTK_TABLE( table ), tableWiz->centre, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->right = gtk_radio_button_new_with_label( group, _("Right") );
        group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->right ) );
      	gtk_table_attach( GTK_TABLE( table ), tableWiz->right, 2, 3, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	/*****************************************************************/
	/* attributes part */
	frame = gtk_frame_new( _("Attributes") );
	gtk_box_pack_start( GTK_BOX( box ), frame, FALSE, FALSE, 0 );

	table = gtk_table_new( 4, 7, FALSE );
	gtk_container_add( GTK_CONTAINER( frame ), table );

	group = NULL;

	tableWiz->caption =gtk_check_button_new_with_label( _("Include caption") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->caption, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	
	tableWiz->above = gtk_radio_button_new_with_label( group, _("above") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->above ) );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->above, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_widget_set_sensitive (tableWiz->above, FALSE);
   
	tableWiz->below = gtk_radio_button_new_with_label(group, _("below table") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->below ) );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->below, 2, 3, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_widget_set_sensitive (tableWiz->below, FALSE);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->caption), "toggled",
				   change_state, (gpointer) tableWiz->below);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->caption), "toggled",
				   change_state, (gpointer) tableWiz->above);
   
	tableWiz->border =gtk_check_button_new_with_label( _("Border line width") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->border, 0, 1, 1, 2,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->bwidth_adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 0.0, 
								     20.0, 1.0, 
								     4.0, 1.0);
        tableWiz->borderPixels = gtk_spin_button_new (GTK_ADJUSTMENT (tableWiz->bwidth_adj),
						      1.0, 0);

	gtk_widget_set_usize( tableWiz->borderPixels, 64, - 1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->borderPixels, 1, 2, 
			  1, 2, GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

	label = gtk_label_new( _("pixels") );
	gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 1, 2,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_widget_set_sensitive (tableWiz->borderPixels, FALSE);
        gtk_widget_set_sensitive (label, FALSE);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->border), "toggled",
				   change_state, (gpointer) tableWiz->borderPixels);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->border), "toggled",
				   change_state, (gpointer) label);

	label = gtk_label_new( _("Cell spacing") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->spacing_adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 0.0, 
								      60.0, 1.0, 
								      5.0, 1.0);
        tableWiz->cellSpacing = gtk_spin_button_new (GTK_ADJUSTMENT (tableWiz->spacing_adj),
						     1.0, 0);
	gtk_widget_set_usize( tableWiz->cellSpacing, 64, - 1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->cellSpacing, 1, 2,
			  2, 3, GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

	label = gtk_label_new( _("pixels between cells") );
	gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 2, 3,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

	label = gtk_label_new( _("Cell padding") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->padding_adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 0.0,
								      60.0, 1.0, 
								      5.0, 1.0);
        tableWiz->cellPadding = gtk_spin_button_new (GTK_ADJUSTMENT (tableWiz->padding_adj),
						     1.0, 0);
   
	gtk_widget_set_usize( tableWiz->cellPadding, 64, - 1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->cellPadding, 1, 2,
			  3, 4, GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

	label = gtk_label_new( _("pixels between cells") );
	gtk_table_attach( GTK_TABLE( table ), label, 2, 3, 3, 4,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );


	group = NULL;
	tableWiz->setWidth = gtk_check_button_new_with_label( _("Table width") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->setWidth, 0, 1, 4, 5,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->tmp_wadj = (GtkAdjustment *) gtk_adjustment_new (300.0, 0.0,
								   1280.0, 1.0, 
								   10.0, 1.0);
        tableWiz->width = gtk_spin_button_new (GTK_ADJUSTMENT (tableWiz->tmp_wadj),
					       1.0, 0);
	gtk_widget_set_usize( tableWiz->width, 64, - 1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->width, 1, 2, 
			  4, 5, GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	
	tableWiz->wPixels = gtk_radio_button_new_with_label( group, _("pixels") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->wPixels ));
	gtk_table_attach( GTK_TABLE( table ), tableWiz->wPixels, 2, 3, 4, 5,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_signal_connect (GTK_OBJECT (tableWiz->wPixels), "toggled",
			    GTK_SIGNAL_FUNC (change_adjustment), "width-pixel");
   
	tableWiz->wPercent = gtk_radio_button_new_with_label( group, 
							      _("% of window") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON(tableWiz->wPercent ));
	gtk_table_attach( GTK_TABLE( table ), tableWiz->wPercent, 3, 4, 4, 5,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_signal_connect (GTK_OBJECT (tableWiz->wPercent), "toggled",
			    GTK_SIGNAL_FUNC (change_adjustment), "width-percent");
        gtk_widget_set_sensitive (tableWiz->width, FALSE);
        gtk_widget_set_sensitive (tableWiz->wPercent, FALSE);
        gtk_widget_set_sensitive (tableWiz->wPixels, FALSE);
        
        /* Ensure that the right widgets are enabled/disabled when toggled */
   
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setWidth), "toggled",
				   change_state, (gpointer) tableWiz->width);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setWidth), "toggled",
				   change_state, (gpointer) tableWiz->wPixels);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setWidth), "toggled",
				   change_state, (gpointer) tableWiz->wPercent);

        group = NULL;
	tableWiz->setHeight = gtk_check_button_new_with_label( _("Table min. height") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->setHeight, 0, 1, 6, 7,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );

        tableWiz->tmp_hadj = (GtkAdjustment *) gtk_adjustment_new (300.0, 0.0,
								     1280.0, 1.0, 
								     10.0, 1.0);
        tableWiz->height = gtk_spin_button_new (GTK_ADJUSTMENT (tableWiz->tmp_hadj),
						1.0, 0);
	
	gtk_widget_set_usize( tableWiz->height, 64, - 1 );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->height, 1, 2, 
			  6, 7, GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	
	tableWiz->hPixels = gtk_radio_button_new_with_label( group, _("pixels") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( tableWiz->hPixels ));
	gtk_table_attach( GTK_TABLE( table ), tableWiz->hPixels, 2, 3, 6, 7,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_signal_connect (GTK_OBJECT (tableWiz->hPixels), "toggled",
			    GTK_SIGNAL_FUNC (change_adjustment), "height-pixel");

	tableWiz->hPercent = gtk_radio_button_new_with_label( group, 
							      _("% of window") );
	group = gtk_radio_button_group( GTK_RADIO_BUTTON(tableWiz->hPercent ));
	gtk_table_attach( GTK_TABLE( table ), tableWiz->hPercent, 3, 4, 6, 7,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_signal_connect (GTK_OBJECT (tableWiz->hPercent), "toggled",
			    GTK_SIGNAL_FUNC (change_adjustment), "height-percent");

        /* Ensure that the right widgets are enabled/disabled when toggled */
        gtk_widget_set_sensitive (tableWiz->height, FALSE);
        gtk_widget_set_sensitive (tableWiz->hPercent, FALSE);
        gtk_widget_set_sensitive (tableWiz->hPixels, FALSE);

        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setHeight), "toggled",
				   change_state, (gpointer) tableWiz->height);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setHeight), "toggled",
				   change_state, (gpointer) tableWiz->hPixels);
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->setHeight), "toggled",
				   change_state, (gpointer) tableWiz->hPercent);
   
	/*****************************************************************/
	/* background part */
	frame = gtk_frame_new( _("Background") );
	gtk_box_pack_start( GTK_BOX( box ), frame, FALSE, FALSE, 0 );

	table = gtk_table_new( 2, 2, FALSE );
	gtk_container_add( GTK_CONTAINER( frame ), table );

	tableWiz->useColour = gtk_check_button_new_with_label( _("Use Colour:") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->useColour, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	tableWiz->colour = gnome_color_picker_new();
	gnome_color_picker_set_title( GNOME_COLOR_PICKER( tableWiz->colour ),
				      _("Background colour for table") );
        gtk_widget_set_sensitive (tableWiz->colour, FALSE);
	gtk_table_attach( GTK_TABLE( table ), tableWiz->colour, 1, 2, 0, 1,
			  0, 0, 0, 0 );
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->useColour), "toggled",
				   change_state, (gpointer) tableWiz->colour);

	tableWiz->useImage = gtk_check_button_new_with_label( _("Use Image:") );
	gtk_table_attach( GTK_TABLE( table ), tableWiz->useImage, 0, 1, 1, 2,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
	tableWiz->image = gnome_file_entry_new("table_images",
					       _("Choose an image to place on the table's background.") );
        gtk_widget_set_sensitive (tableWiz->image, FALSE);
	gtk_table_attach( GTK_TABLE( table ), tableWiz->image, 1, 2, 1, 2,
			  GTK_EXPAND | GTK_FILL,
			  GTK_FILL, 0, 0 );
        gtk_signal_connect_object (GTK_OBJECT (tableWiz->useImage), "toggled",
				   change_state, (gpointer) tableWiz->image);

	/*****************************************************************/
	dialog = gnome_dialog_new(_("Table wizard"),
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_APPLY,
				  GNOME_STOCK_BUTTON_CLOSE,
				  NULL ); 
	gtk_object_set_data( GTK_OBJECT( dialog ), "dialog", 
			     (gpointer)&dialog );
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dialog )->vbox ),
			    box, TRUE, TRUE, GNOME_PAD);
	gtk_widget_show_all( dialog );

	gtk_signal_connect( GTK_OBJECT( dialog ), "delete_event",
			    tableWizDestroy, tableWiz );
	gtk_signal_connect( GTK_OBJECT( dialog ), "clicked", 
                            tableWizClicked, tableWiz );

}
