/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_wchar_h
#define nls_wchar_h

#include <NLS/enter-scope.h>
#include <hyperg/OS/enter-scope.h>

const unsigned char     esc_ =  '\033';
const unsigned char     bs_  =  '\010';
const unsigned char     ht_  =  '\011';
const unsigned char     lf_  =  '\012';
const unsigned char     vt_  =  '\013';
const unsigned char     ff_  =  '\014';
const unsigned char     cr_  =  '\015';
const unsigned char     sp_  =  '\040';
const unsigned char     del_  = '\177';

class WChar {
  public:
    WChar()			{ value_ = 0; }
    WChar(int c)		{ value_ = c; }
    WChar(int c, CharSet_T cs)	{ value_ = (cs << 16) | c; }

  public:
    int charcode() const;
    CharSet_T charset() const;
    int value() const;

  public:
    void set (int charcode, CharSet_T charset);

  public:
    const WChar & operator =(const WChar&);
    boolean operator ==(const WChar&) const;
    boolean operator !=(const WChar&) const;
    boolean operator <(const WChar&) const;
    boolean operator >(const WChar&) const;
    boolean operator <=(const WChar&) const;
    boolean operator >=(const WChar&) const;

  public:
    /* ascii character interface */
    const WChar & operator =(int);
    boolean operator ==(int) const;
    boolean operator !=(int) const;
    boolean operator <(int) const;
    boolean operator >(int) const;
    boolean operator <=(int) const;
    boolean operator >=(int) const;

  private:
    WChar_T value_;
};

inline int WChar::charcode() const {
    return value_ & 0xffff;
}

inline CharSet_T WChar::charset() const {
    return value_ >> 16;
}

inline int WChar::value() const {
    return int(value_);
}

inline void WChar::set(int charcode, CharSet_T charset) {
    value_ = (charset << 16) | charcode;
}

inline const WChar& WChar::operator =(const WChar& c) {
    value_ = c.value_;
    return *this;
}

inline boolean WChar::operator ==(const WChar& c) const {
    return value_ == c.value_;
}

inline boolean WChar::operator !=(const WChar& c) const {
    return value_ != c.value_;
}

inline boolean WChar::operator < (const WChar& c) const {
    return value_ < c.value_;
}

inline boolean WChar::operator > (const WChar& c) const {
    return value_ > c.value_;
}

inline boolean WChar::operator <= (const WChar& c) const {
    return value_ <= c.value_;
}

inline boolean WChar::operator >= (const WChar& c) const {
    return value_ >= c.value_;
}

inline const WChar& WChar::operator =(int c) {
    value_ = c;
    return *this;
}

inline boolean WChar::operator ==(int c) const {
    return value_ == c;
}

inline boolean WChar::operator !=(int c) const {
    return value_ != c;
}

inline boolean WChar::operator < (int c) const {
    return value_ < c;
}

inline boolean WChar::operator > (int c) const {
    return value_ > c;
}

inline boolean WChar::operator >= (int c) const {
    return value_ >= c;
}

inline boolean WChar::operator <= (int c) const {
    return value_ <= c;
}

#endif
