/* this file is a part of Ami software, (C) Hwang chi-deok 1999 */

/* Author: Han Ji-Ho <hanjiho@penta.co.kr>  */
/* With code from wmxmms, gnomex11amp and battery_meter */

#include "config.h"


#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "cp.h"
#include "ami.h"
#include "hangulinput.h"
#include "handler.h"

#include "ami-h.xpm"
#include "ami-e.xpm"
#include "ami-d.xpm"

/*   */
static GtkWidget *d_area;
static GdkGC     *gc;
static GdkPixmap *pixmap_e, *pixmap_h, *pixmap_d;
static GdkFilterReturn e_event_translate(XEvent *xev, GdkEvent *ev, gpointer data);
static gboolean e_is_running(void);

/*  Լ */
void draw_applet_image(gint hangul_mode)
{
  if(ami_run_mode == AMI_NORMAL_RUN) {
      static int old_mode = -3;
      if ((!unique_han && support_status) || old_mode == hangul_mode) return;
      if (hangul_mode == 0) {
	 gdk_window_set_icon_name(cp_win->window, ": ƹ");
      } else if (hangul_mode == 1) {
	 gdk_window_set_icon_name(cp_win->window, "ѱ: ƹ");
      } else {
	 gdk_window_set_icon_name(cp_win->window, "ƹ ");
      }
      old_mode = hangul_mode;
      return;
  }
  switch(hangul_mode) {
      case 0:
	  gdk_draw_pixmap(d_area->window,gc,pixmap_e,0,0,0,0,-1,-1);
	  break;
      case 1:
	  gdk_draw_pixmap(d_area->window,gc,pixmap_h,0,0,0,0,-1,-1);
	  break;
      default :
	  gdk_draw_pixmap(d_area->window,gc,pixmap_d,0,0,0,0,-1,-1);
  }

  return;
}

void expose_cb(GtkWidget *w, GdkEventExpose *event, gpointer data)
{
  if(current_focus_ic==NULL) 
    draw_applet_image(-1);
  else if((current_focus_ic->composing_hangul))
    draw_applet_image(1);
  else
    draw_applet_image(0);
  return;
}

gint cp_delete_cb( GtkWidget *widget, void *data )
{
    gtk_widget_hide(widget); /* hide cp_win */
    return TRUE;
}

#ifdef GNOME_APPLET
#include <gnome.h>
#include <applet-widget.h>

static void about (AppletWidget *applet, gpointer data)
{
  static const char *authors[] = { "Ȳ ġ", NULL};
  GtkWidget *about_box;

  about_box = gnome_about_new("ƹ ø", VERSION,
	  "Copyright (C) Ȳ ġ 1999",
	  authors,
	  "ѱԷ± ƹ ׳ ø." ,NULL);

  gtk_widget_show(about_box);
}


gint prop_destroy_cb( GtkWidget *widget, void *data )
{
  cp_win = NULL;
  return FALSE;
}

static void properties (AppletWidget *applet, gpointer data)
{
   GtkWidget *box, *vbox, *label, *frame;
  
   if( cp_win ){
     gtk_widget_show(cp_win);
     gdk_window_raise(cp_win->window);
     return;
   }

  cp_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(cp_win), "ƹ ");
  gtk_container_add(GTK_CONTAINER(cp_win), cp);

  gtk_signal_connect( GTK_OBJECT(cp_win),
		      "delete_event", GTK_SIGNAL_FUNC(cp_delete_cb), NULL );

  gtk_widget_show_all(cp_win);
}


int ami_gnome_main(int argc, char *argv[], char* rc_file)
{
  GtkWidget *applet, *frame;
  GdkBitmap *mask;
  gint i, j;
  
  /* applet_widget_init  ϴ argv  */
  for (i = 1; i < argc; i++) {
      if (!strcmp(argv[i], "-debug") || !strcmp(argv[i], "-gnome") || 
          !strcmp(argv[i], "-wm")) {
	  argc--;
	  for(j = i;j < argc;j++) argv[j] = argv[j+1];
	  if(argc <= 1) break;
	  i--;
	  continue;
      }
  }

  applet_widget_init("ami_applet", VERSION, argc, argv,
	  NULL, 0, NULL);
  gtk_rc_parse(rc_file);
  applet = applet_widget_new("ami_applet");
  gtk_widget_realize(applet);

  applet_widget_register_stock_callback (APPLET_WIDGET (applet),
	  "about", GNOME_STOCK_MENU_ABOUT,
	  " α׷...", about, NULL);
  applet_widget_register_stock_callback (APPLET_WIDGET (applet),
	  "properties", GNOME_STOCK_MENU_ABOUT,
	  "Ӽ...", properties, NULL);

  d_area = gtk_drawing_area_new();
  gtk_widget_set_app_paintable(d_area,TRUE);
  gtk_widget_set_usize(d_area,48,48);

  gtk_widget_set_events(d_area, GDK_EXPOSURE_MASK );
  gtk_signal_connect(GTK_OBJECT(d_area),"expose_event",
	  GTK_SIGNAL_FUNC(expose_cb),NULL);

  gdk_window_clear(applet->window);
  gc = gdk_gc_new(applet->window);
  applet_widget_add(APPLET_WIDGET(applet),d_area);
  gtk_widget_show_all(applet);	

  pixmap_h = gdk_pixmap_create_from_xpm_d(applet->window,&mask,NULL,
	  ami_h_xpm);
  pixmap_e = gdk_pixmap_create_from_xpm_d(applet->window,&mask,NULL,
	  ami_e_xpm);
  pixmap_d = gdk_pixmap_create_from_xpm_d(applet->window,&mask,NULL,
	  ami_d_xpm);

  ami_init_im(d_area);

  cp = create_cp();

  XBell(gdk_display, 0);
  applet_widget_gtk_main();
  IMCloseIM(xims);
  
  return 0;
}

#endif /* GNOME_APPLET */


/**********************************************************************/


void wm_destroy_cb( GtkWidget *widget, void *data )
{
    IMCloseIM(xims);
    gtk_exit(0);
}

void wm_button_press_cb(GtkWidget * w, GdkEventButton * event, gpointer data)
{
    if(event->type != GDK_2BUTTON_PRESS) return; /*  Ŭ */
    if(cp_win) {
	gtk_widget_show(cp_win);
	gdk_window_raise(cp_win->window);
	return;
    }
    cp_win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(cp_win), "ƹ ");
    gtk_container_add(GTK_CONTAINER(cp_win), cp);
    gtk_signal_connect(GTK_OBJECT(cp_win), "delete_event", GTK_SIGNAL_FUNC(cp_delete_cb), NULL);
    gtk_widget_show_all(cp_win);
}

int 
ami_wm_main(int argc, char *argv[], char *rc_file)
{
    GdkColor bg_color;
    GtkWidget *icon_win;
    GdkWindow *leader;
    GdkPixmap *pixmap;
    GdkGC *dock_gc;
    GdkGC *mask_gc;
    GdkBitmap *mask, *dock_mask;
    XWMHints hints;
    gint i, w, h;

    gtk_init(&argc, &argv);
    gtk_rc_parse(rc_file);


    icon_win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_widget_set_app_paintable(icon_win, TRUE);
    gtk_widget_set_usize(icon_win, 64, 64);

    gtk_widget_set_events(icon_win, GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK);
    gtk_signal_connect(GTK_OBJECT(icon_win), "expose_event", GTK_SIGNAL_FUNC(expose_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(icon_win), "button_press_event", GTK_SIGNAL_FUNC(wm_button_press_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(icon_win), "destroy", GTK_SIGNAL_FUNC(wm_destroy_cb), NULL);

    gtk_widget_realize(icon_win);
    dock_gc = gdk_gc_new(icon_win->window);

    pixmap_h = gdk_pixmap_new(icon_win->window, 64, 64, -1);
    pixmap_e = gdk_pixmap_new(icon_win->window, 64, 64, -1);
    pixmap_d = gdk_pixmap_new(icon_win->window, 64, 64, -1);

    dock_mask = gdk_pixmap_new(icon_win->window, 64, 64, 1);
    mask_gc = gdk_gc_new(dock_mask);
    bg_color.pixel = 0;
    gdk_gc_set_foreground(mask_gc, &bg_color);
    gdk_draw_rectangle(dock_mask, mask_gc, TRUE, 0, 0, -1, -1);

    /* make 3 pixmaps */
    pixmap = gdk_pixmap_create_from_xpm_d(icon_win->window, &mask, NULL, ami_d_xpm);
    gdk_window_get_size(pixmap, &w, &h);
    if (w > 64) w = 64;
    if (h > 64) h = 64;
    gdk_draw_pixmap(pixmap_d, dock_gc, pixmap, 0, 0, 32 - (w / 2), 32 - (h / 2), w, h);
    gdk_draw_pixmap(dock_mask, mask_gc, mask, 0, 0, 32 - (w / 2), 32 - (h / 2), w, h);
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);

    pixmap = gdk_pixmap_create_from_xpm_d(icon_win->window, &mask, NULL, ami_h_xpm);
    gdk_window_get_size(pixmap, &w, &h);
    if (w > 64) w = 64;
    if (h > 64) h = 64;
    gdk_draw_pixmap(pixmap_h, dock_gc, pixmap, 0, 0, 32 - (w / 2), 32 - (h / 2), w, h);
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);

    pixmap = gdk_pixmap_create_from_xpm_d(icon_win->window, &mask, NULL, ami_e_xpm);
    gdk_window_get_size(pixmap, &w, &h);
    if (w > 64) w = 64;
    if (h > 64) h = 64;
    gdk_draw_pixmap(pixmap_e, dock_gc, pixmap, 0, 0, 32 - (w / 2), 32 - (h / 2), w, h);
    gdk_pixmap_unref(pixmap);
    gdk_bitmap_unref(mask);

    gdk_gc_unref(mask_gc);

    gtk_widget_shape_combine_mask(icon_win, dock_mask, 0, 0);

    d_area = icon_win;
    if (e_is_running()) {
	/* E  dock  */
	/* E WindowMaker ſ ٸ  dock mechanism Ѵ.*/
	gdk_window_add_filter(NULL, (GdkFilterFunc)e_event_translate, NULL); 
	hints.initial_state = WithdrawnState;
	hints.window_group = GDK_WINDOW_XWINDOW(icon_win->window);
	hints.icon_x = 0;
	hints.icon_y = 0;
	hints.flags = StateHint | WindowGroupHint | IconPositionHint;
	XSetWMHints(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(icon_win->window), &hints);
	XMapRaised(gdk_display, GDK_WINDOW_XWINDOW(icon_win->window));
    } else {
	hints.initial_state = WithdrawnState;
	hints.icon_window = GDK_WINDOW_XWINDOW(icon_win->window);
	hints.window_group = gdk_leader_window;
	hints.flags = WindowGroupHint | StateHint | IconWindowHint;
	XSetWMHints(GDK_DISPLAY(), gdk_leader_window, &hints);
	XMapRaised(gdk_display, gdk_leader_window);
    }

    ami_init_im(icon_win);
    cp = create_cp();

    /* for draw_applet_image() */
    gc = dock_gc;
    d_area = icon_win;

    XBell(gdk_display, 0);
    gtk_main();

    return 0;
}

static GdkFilterReturn 
e_event_translate(XEvent *xev, GdkEvent *ev, gpointer data)
{
    if (xev->xany.send_event && xev->type == ButtonPress && 
    	gdk_window_lookup(xev->xbutton.window) == NULL) {
	/* E icon window button pressȣ ؼ ڽ window .
	   ڽſ ʿ  ̰ SendEvent  츮
	   event  ̶ xbutton window  ״
	    gtk+ ڱⰡ   event Ƿ
	    ۵ ϰԵȴ.
	    츮 ⿡ window ùٸ Ƽ ٽ
	   X ۷ .
	   GDK_FILTER_TRANSLATE window translation Ƿ
	    
	   gdk_event_put  double click ʱ⶧ Ұ.
	   wmtimeͰ α׷  E ۵ϴ  
	   windowü ˻ʰ ״ callback
	   θǷ ̷  ߻ʾҴ.*/
        xev->xbutton.window = GDK_WINDOW_XWINDOW(d_area->window);
        XPutBackEvent(gdk_display, xev);
	return GDK_FILTER_REMOVE;
    }
    return GDK_FILTER_CONTINUE;
}

static gboolean
e_is_running(void)
{
    GdkAtom en = gdk_atom_intern("ENLIGHTENMENT_COMMS", TRUE);
    GdkAtom type;
    gint format, length;
    guchar *root_data = NULL;
    guchar *win_data = NULL;
    long eid;
    gboolean ret;
    unsigned long nitems, after;
    GdkAtom string_atom;

    if (en == None) return FALSE;
    string_atom = gdk_atom_intern("STRING", FALSE);
    if (XGetWindowProperty(gdk_display, gdk_root_window, en, 0, 256, False, string_atom,
    	&type, &format, &nitems, &after, &root_data) != Success) return FALSE;
    if (!root_data) return FALSE;
    if (sscanf(root_data, "WINID %lx", &eid) != 1) return FALSE;
    gdk_error_trap_push ();
    if (XGetWindowProperty(gdk_display, eid, en, 0, 256, False, string_atom,
    	&type, &format, &nitems, &after, &win_data) != Success) {
	XFree(root_data);
	return FALSE;
    }
    if (gdk_error_trap_pop () || !win_data) {
	XFree(root_data);
	return FALSE;
    }
    ret = !strcmp(root_data, win_data);
    XFree(root_data); XFree(win_data);
    return ret;
}
