
################################################################################################
# decor routines  context
#####################################################################################

{

my($junk,$key);
my (@w); # Entry and Radiobutton refs
my $d = $CONFIG{Decors};

my @vars = qw( 
	     Justification 
	     TitleHeight 
	     WindowFont 
	     BorderActivePixmap 
	     BorderInactivePixmap 
	     TitleActiveUp 
	     TitleActiveDown 
	     TitleInactive 
	     HilightColorFore  
	     HilightColorBack  
	     TitleReliefAUp
             TitleReliefADown
             TitleReliefIA
	     HiddenHandles
	     NoInset
 	     );
##############################################################

#######################################################
sub initialize_decor_panel {
    foreach (@vars){
#	debug 0, "initializing $_";
	$d->{$DECOR}->{$_}->initialize_panel;
    }
}
###########################################################################
sub put_decor_values_on_panel {
    my $i=0;
    set_current_button_style() ;
    return unless Exists $SETDECOR;
    foreach (@vars){
	$d->{$DECOR}->{$_}->put_panel_ref($w[$i++]);
	$d->{$DECOR}->{$_}->put_value_on_panel();
    }

}

#############################################################################
sub get_decor_values_from_panel {
    foreach (@vars) {$d->{$DECOR}->{$_}->get_value_from_panel;
#		     debug 0, "getting $_: ";
    }
}
###################################################################


##############################################################
sub set_decor {

    $SETDECOR->destroy if Exists($SETDECOR);
    $SETDECOR = $MW->Toplevel(@topcon);
    my $w = $SETDECOR ;
    $w->title('Decor');

my $fsome = make_help_dismiss($w,'File:DecorPanel');
my $f2 = $fsome->Frame(@fracon);
$f2->pack();
$f2->Label(@labcon,-textvariable => \$DECOR)->pack(-side=>'right',);
$f2->Label(@labcon, -text => " Decor: ")->pack(-side=>'right' ,);
$f2->Label(@labcon,-textvariable => \$CONFFILE)->pack(-side=>'right',);
$f2->Label(@labcon, -text => "Config: ")->pack(-side=>'right' ,);
$CONFIG{Decors}= {} unless exists $CONFIG{Decors};

    my $p = 20; # padding width
#    foreach(@vars) { 
#	$d->{$DECOR}->{$_}->set_panel_toplevel($w)}
    initialize_decor_panel ();

  my $f = $w->Frame(@fracon,-relief=>'groove');
  $f->pack(-fill => 'both');
  $f->Button(@butcon,-text => 'Select Decor',
	     -command => \&change_decor)->pack(-side => 'left', -fill => 'both');

  my $apply = $f->Button(
			 @butcon,
			 -text => 'Apply',
			    -activebackground=> $applybg,
			 -command =>sub { 
			        get_decor_values_from_panel();
				execute_decor($DECOR,0);
				update_decor($DECOR);
				set_unsaved();
				      } );
   $apply->pack(-side => 'right', -fill => 'both');


    my $f0 = $w->Frame(@fracon);
    $f0->pack(-expand=>'y', -fill =>'both');
    $f0->Label(@labcont,-text=>'   Title   ')->pack(-pady=> '10');

($junk,$w[2]) = labentlist($w,'L', pad('Font',$p-15),'E',42,
			$d->{$DECOR}->{WindowFont});


($junk,$w[0]) = radlablist($w,pad('Justification',$p),
	       $d->{$DECOR}->{Justification}->get_panel_ref,
	       'Centered', 'Centered',
	       'Left', 'LeftJustified',
	       'Right ', 'RightJustified'
	       );

($junk,$w[10]) = radlablist($w,pad('Active-Up Relief',$p),
	       $d->{$DECOR}->{TitleReliefAUp}->get_panel_ref,
	       'sunken  ', 'sunken',
	       'flat', 'flat',
	       'raised', 'raised'
	       );

($junk,$w[11]) = radlablist($w,pad('Active-Down Relief',$p),
	       $d->{$DECOR}->{TitleReliefADown}->get_panel_ref,
	       'sunken  ', 'sunken',
	       'flat', 'flat',
	       'raised', 'raised'
	       );

($junk,$w[12]) = radlablist($w,pad('Inactive Relief',$p),
	       $d->{$DECOR}->{TitleReliefIA}->get_panel_ref,
	       'sunken  ', 'sunken',
	       'flat', 'flat',
	       'raised', 'raised'
	       );

($junk,$w[1]) = labentlist($w,'L', pad('Height',$p),'File:titleheight',
			   'E',6,
			$d->{$DECOR}->{TitleHeight});

my $len1 = 27;
($junk,$w[8]) = labentlist($w,'L', pad('Hilight Color Fore ',$p),'File:HilightColor','E',$len1,
			$d->{$DECOR}->{HilightColorFore});

($junk,$w[9]) = labentlist($w,'L', pad('Hilight Color Back ',$p),'File:HilightColor','E',$len1,
			$d->{$DECOR}->{HilightColorBack});




($junk,$w[5]) = labentlist($w,'L', pad('Active-Up Col/Pix',$p),'File:TitleColor','E',$len1,
			$d->{$DECOR}->{TitleActiveUp});

($junk,$w[6]) = labentlist($w,'L', pad('Active-Down Col/Pix',$p),'File:TitleColor','E',$len1,
			$d->{$DECOR}->{TitleActiveDown});

($junk,$w[7]) = labentlist($w,'L', pad('Inactive Col/Pix',$p),'File:TitleColor','E',$len1,
			$d->{$DECOR}->{TitleInactive});

    my $f1 = $w->Frame(@fracon);
    $f1->pack(-expand=>'y', -fill =>'both');
    $f1->Label(@labcont,-text=>'   Border   ')->pack(-pady=> '10');
($junk,$w[3]) = labentlist($w,'L', pad('Active Image',$p),'File:borderim',
			   ,'E',$len1,
			$d->{$DECOR}->{BorderActivePixmap});

($junk,$w[4]) = labentlist($w,'L', pad('Inactive Image',$p),'File:borderim',
			   ,'E',$len1,
			$d->{$DECOR}->{BorderInactivePixmap});


($junk,$w[13]) = radlablist($w,pad('Hidden Handles',$p),
	       $d->{$DECOR}->{HiddenHandles}->get_panel_ref,
		'Yes','HiddenHandles',
		'No','!HiddenHandles',
	       );

($junk,$w[14]) = radlablist($w,pad('No Inset',$p),
	       $d->{$DECOR}->{NoInset}->get_panel_ref,
		'Yes','NoInset',
		'No','!NoInset',
	       );

put_decor_values_on_panel();

}
# end set_decor
##############################################################

##############################################################


sub change_decor {
    $MAKENEWDECOR->destroy if Exists($MAKENEWDECOR);
    $MAKENEWDECOR = $SETDECOR->Toplevel(@topcon);
    my $w = $MAKENEWDECOR ;
    $w->title('Select Decor');
    make_help_dismiss($w,'File:changedecor');
    my ($key,@stlist);
    @stlist = sort keys %$d;
    my $f0 = $w->Frame(@fracon, );
    $f0->pack(-side => 'top', -expand => 'no', -fill => 'both');
    $f0->Label(-text=>'Decors')->pack();
    my $f = $w->Frame(@fracon, );
    $f->pack(-side => 'top', -expand => 'yes', -fill => 'both');
    my $s = $f->Scrollbar(@scalcon);
    my $l = $f->Listbox(@liscon,-yscrollcommand => ['set', $s], -setgrid => 1,
				     -width => $maxwidth, -height => 10);
    $s->configure(-command => ['yview', $l]);
    $s->pack(-side => 'right', -fill => 'y');
    $l->pack(-side => 'left', -expand => 'yes', -fill => 'both');
    $l->insert(0,sort @stlist);
    my $reread = sub { @stlist = sort keys %$d;
		       $l->delete('0','end');
		       $l->insert(0,sort @stlist);};	       
    my $e = $w->Entry(@entcon,-width => $style_entry_width);
    $e->pack(-side => 'top');
    my $f2 = $w->Frame(@fracon);
    my $loadsub = sub {
                        $DECOR = $e->get();
                  create_decor_variables($DECOR)  unless exists $d->{$DECOR};
		     initialize_decor_panel();
			put_decor_values_on_panel();
                        link_change('Decors',$DECOR);
			put_history_vars_on_panel();
                         &$reread;
                   # $w->destroy;
            };

     $e->bind('<Return>' => $loadsub);
     $l->bind('<Button-1>' =>
	     sub {
		 my $i = $l->curselection();
		 $e->delete('0','end');
		 $e->insert('0',$stlist[$i]);
	     });
     $l->bind('<Double-Button-1>' => $loadsub);
    $f2->pack(-fill => 'both');
    $f2->Button(@butcon,-text=>'Load',
          -command =>  $loadsub )->pack(-side=>'left');

    $f2->Button(@butcon,-text=>'Copy',-activebackground=>'yellow',
          -command => sub {
	      my $entry = $e->get;
	      if(exists $d->{$entry} ) {
		  copy_decor($entry,$DECOR);
		  put_decor_values_on_panel();
		  put_history_vars_on_panel();
	      }
	      else { beep();}
	  }
    )->pack(-side=>'left');
    $f2->Button(@butcon,-activebackground => 'red',-text=>'Delete',
          -command =>sub{
                     my $st = $e->get;
		     if($st eq 'default') { beep();return;}
		     delete  $d->{$st} if exists $d->{$st};
		     if ($st eq $DECOR) {
			 $DECOR = 'default';
			 $e->delete('0','end');
			 initialize_decor_panel();
			 put_decor_values_on_panel();
			 put_history_vars_on_panel();
		     }
		     &$reread;
		    })->pack(-side=>'right');
    
}
# end change_decor
##############################################################


}
# end set decor context
###################################################################################################################
###################################################################################################################
