/* GKrellM
|  Copyright (C) 1999 Bill Wilson
|
|  Author:	Bill Wilson		bill@gkrellm.net
|  Latest versions might be found at:
|		http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation, Inc.,
|  59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/


/* Global extern declarations and function prototypes.
*/
extern GtkWidget	*top_window;

extern struct tm	current_tm;

extern gchar		*exec_theme_path;

extern gint			smp_cpus;
extern gint			label_font_ascent;

void create_hostname(GtkWidget *);
void create_clock(GtkWidget *);
void create_cpu(GtkWidget *);
void create_proc(GtkWidget *);
void create_disk(GtkWidget *);
void create_inet(GtkWidget *);
void create_net(GtkWidget *);
void create_meminfo(GtkWidget *);
void create_fs(GtkWidget *);
void create_apm(GtkWidget *);
void create_uptime(GtkWidget *);
void create_mailcheck(GtkWidget *);

void update_clock(void);
void update_uptime(void);
void update_stat(void);
void update_inet(void);
void update_net(void);
void update_meminfo(void);
void update_fs(void);
void update_apm(void);
void update_mailcheck(void);

void insert_spacer(GtkWidget *);

void alloc_chart_data(Chart *);
void clear_chart(Chart *);
void store_chart_data(Chart *, unsigned long, unsigned long, unsigned long);
void store_proc_chart_data(Chart *, gint, gint);
void draw_chart(Chart *);
void draw_proc_chart(Chart *);

char *im_file(gchar *);

void create_chart(GtkWidget *, Chart *, gint);
void create_panel_area(GtkWidget *, Panel *, GdkImlibImage *);
void configure_panel(Panel *, gchar *, Style *);
void draw_panel_label(Panel *, GdkImlibImage *);
void default_textstyle(TextStyle *, gint);

void destroy_chart(Chart *);
void destroy_panel(Panel *);
void destroy_krell(Krell *);

void gkrellmrc_config(void);
int read_user_config(void);

void load_inet_data(void);
void save_inet_data(void);

void load_images(void);

gchar	*fixup_name(gchar *);

void pack_side_frames();

void draw_krell_stencil(Panel *, Krell *);
void push_krell_pixmap(Panel *, Krell *);

void create_krell(gchar *, GdkImlibImage *, Krell **, Style *);
void update_krell(Panel *, Krell *, unsigned long);
void draw_layers(Panel *);
void draw_decal(Panel *, Decal *, gint);

gint effect_string_value(gchar *);

void create_display(void);

void create_config_window(void);
void close_config(void);

void set_on_top(gint);
void init_on_top_hint(void);
void restart_gkrellm(void);

int enable_visibility(int, int *, GtkWidget *, gint);

void apply_clock_config(void);
void apply_hostname_config(void);
void apply_fs_config(void);
void apply_inet_config(void);
void apply_net_config(void);
void apply_sensors_config(void);
void apply_stat_config(void);
void apply_mail_config(void);


GtkWidget *create_tab(GtkWidget *, gchar *);
void create_fs_tab(GtkWidget *);
void create_inet_tab(GtkWidget *);
void create_mail_tab(GtkWidget *);
void create_net_tab(GtkWidget *);
void create_sensors_tab(GtkWidget *);

void reset_chart(Chart *);

gchar *homedir(void);
gint isdir(gchar *);

void start_timer(void);

GtkWidget *create_popup_menu(void);

void save_user_config(void);
void write_net_config(FILE *);
void load_net_config(gchar *);
gint store_net_config(gchar *, gint, gint);

void write_inet_config(FILE *);
void load_inet_config(gchar *);

void write_mail_config(FILE *);
void load_mail_config(gchar *);

void write_fs_config(FILE *);
void load_fs_config(gchar *);

void register_sensors(void);
void write_sensor_config(FILE *);
void load_sensor_config(gchar *);
gint read_temperature(gchar *);

void draw_string(GdkDrawable *, GdkFont *, GdkColor *,
				gint, gint, gint, gchar *);
gint draw_chart_label(Chart *, GdkFont *, gint, gint, gchar *);

int map_1_2_5(gint, gint *, gint);

gint computed_index(Chart *, gint);
