/***************************************************************************
                          miscpage.h  -  tabbed dialog page for misc ingr.
                             -------------------                                         
    begin                : Wed Oct 20 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef MISCPAGE_H
#define MISCPAGE_H

#include <qcheckbox.h>

#include "miscingredient.h"
#include "ingredientpage.h"

/**
  *@author David Johnson
  */
class MiscPage : public IngredientPage  {
   Q_OBJECT
public:
	/** constructor */
	MiscPage(QWidget *parent, const char *name, QObject *doc, QObject *calc);
	/** destructor */
	~MiscPage();

protected slots:
	/** received if add clicked */	
	void slotAddMiscIngredient();	
	/** received if remove clicked */	
	void slotRemoveMiscIngredient();	
	/** received if apply clicked */	
	void slotApplyMiscIngredient();	
	/** receives if document has changed */
	void slotDocumentChanged();
	/** update the widgets in the entry area */
	void slotUpdateEntryItems(const QString &name);
	/** received if an ingredient was selected */
	void slotItemSelected(QListViewItem *item);
private:
	/** update the list view */
	void updateListView();
	
private:
	QLabel *notesLabel;
	QLineEdit *notesEdit;
	MiscIngredientListItem *currentItem;	
};

#endif







