/***************************************************************************
                          style.h  -  style element and list
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef STYLE_H
#define STYLE_H

#include <qstring.h>

/**
  * AHA-like style guidelines
  */
class Style {
public:
	/** constructor */
	Style();
	/** full constructor */
	Style(const unsigned &oglow, const unsigned &oghi,
		const unsigned &ibulow, const unsigned &ibuhi,
		const unsigned &srmlow, const unsigned &srmhi);
	/** copy constructor */
	Style(const Style &s);
	/** assignment operator */
	Style operator=(const Style &s);
	/** destructor */
	~Style();
	
	/** return OGhi */
	unsigned getOGHi();
	/** return OGlow */
	unsigned getOGLow();
	/** return IBUhi */
	unsigned getIBUHi();
	/** return IBUlow */
	unsigned getIBULow();
	/** return SRMhi */
	unsigned getSRMHi();
	/** return SRMlow */
	unsigned getSRMLow();
	
	/** return object as string, for serialization */
	QString serializeOut();
	/** set object to string, for serialization */
	void serializeIn(const QString &s);
	
private:
	unsigned OGlow, OGhi;
	unsigned IBUlow, IBUhi;
	unsigned SRMlow, SRMhi;
};

#endif




