/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#include "commun.h"
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/socket.h>


char *socket_name = "/tmp/.sfm";
char *defaultCreateDirectoryName = "-new-directory-";
char *defaultCreateFileName = "-new-file-";
char *optionPaste = "--optionPaste";
char *optionCdm = "--cdm";

/* for line_by_line_read */
static char *buffer = NULL;
static char *current;


extern void pchar_free(char **p, int size) { int i; for (i = 0; i < size; i++) FREE_NULL(p[i]); }
extern void char_replace(char **p, char *a) { FREE_NULL(*p); *p = a; }

extern boolean makeboolean(int b) { return b ? true : false; }
extern int myCeil(int i, int a) { return (i + a-1) / a; }


extern void warn(char *msg)
{
  char p[tmpSize];
  sprintf(p, "warning: %s (%s)", strerror(errno), msg);
  /*view_warn(p);*/
}
extern void die(char *msg)
{
  perror(msg);
  exit(1);
}

#define MY_SWAP(a, b, type) { type c; c = *a; *a = *b; *b = c; }

extern void char_swap(char **a, char **b) { MY_SWAP(a, b, char *); }

extern boolean streq(char *a, char *b) { return strcmp(a, b) == 0; }

extern boolean strput(char *p, char *a, char *b, int size)
{
  int la = strlen(a);
  int lb = strlen(b);
  if (la + lb > size) return false;
  memcpy(p, a, la);
  memcpy(p + la, b, lb);
  p[la + lb] = '\0';
  return true;
}

extern boolean strput3(char *p, char *a, char *b, char *c, int size)
{
  int la = strlen(a);
  int lb = strlen(b);
  int lc = strlen(c);
  if (la + lb > size) return false;
  memcpy(p, a, la);
  memcpy(p + la, b, lb);
  memcpy(p + la + lb, c, lc);
  p[la + lb + lc] = '\0';
  return true;
}

extern boolean strbeginswith(char *a, char *prefix)
{
  return memcmp(a, prefix, strlen(prefix)) == 0;
}

extern boolean strendswith(char *a, char *suffix)
{
  return streq(strend(a) - strlen(suffix), suffix);
}

extern boolean strendswith_nocase(char *a, char *suffix)
{
  return strcasecmp(strend(a) - strlen(suffix), suffix) == 0;
}

extern char *pchar2char(char **tab, int nb, char *sep)
{
  char *p, *r;
  int i;

  if (nb == 0) return NULL;
  r = strdup(tab[0]);

  for (i = 1; i < nb; i++) {
    p = r;
    r = strconcat3(p, sep, tab[i]);
    free(p);
  }
  return r;
}


extern void chop(char *p)
{
  int lp = strlen(p);
  if (lp > 0) p[lp - 1] = '\0';
}

extern char *strend(char *a)
{
  return a + strlen(a);
}

extern int lastchar(char *a)
{
  if (a == strend(a)) return -1;
  return strend(a)[-1];
}

extern int common_chars(char *a, char *b)
{
  int l = MAX(strlen(a), strlen(b));
  int i;
  for (i = 0; i < l && a[i] == b[i]; i++);
  return i;
}

extern char *expandEnvVars(char *a)
{
  char tampon[tmpSize], tmp[tmpSize];
  char *p, *q;
  char *r, *env;
  int free, l;
  
  p = a;
  r = tampon;
  free = tmpSize - 1;
  if (*p == '~' && (env = getenv("HOME"))) 
    {
      l = MIN(strlen(env), free);
      memcpy(r, env, l);
      p++; r += l; free -= l;
    }

  while ((q = strchr(p, '$'))) {
    l = MIN(q - p, free);
    memcpy(r, p, l);
    r += l; free -= l;
    p = ++q;
    strncpy(tmp, q, tmpSize);
    while (tmp[0] && getenv(tmp) == NULL) chop(tmp);
    if ((env = getenv(tmp))) {
      l = MIN(strlen(env), free);
      memcpy(r, env, l);
      p += strlen(tmp); r += l; free -= l;      
    } else if (free--) *r++ = '$';
  }
  l = MIN(strlen(p), free);
  memcpy(r, p, l);
  r[l] = '\0';
  return strdup(tampon);
}


extern char *skip_spaces(char *p)
{
  for (; *p && (*p == ' ' || *p == '\t'); p++);
  return p;
}

extern char *remove_bording_spaces(char *p)
{
  char *q, *r;

  p = skip_spaces(p);
  for (q = strend(p) - 1; 
       q > p && (*q == ' ' || *q == '\t'); 
       q--);
  q++;
  r = char_malloc(q - p + 1);
  memcpy(r, p, q - p);
  r[q - p] = '\0';
  return r;
}


extern void init_line_by_line_read()
{
  if (buffer == NULL) buffer = char_malloc(tmpSize);
  current = buffer;
  buffer[0] = '\0';
}

extern void end_line_by_line_read()
{
  FREE_NULL(buffer);
}

extern char *line_by_line_read(int fd)
{
  char *p, *q;
  int nb, nb2;
  
  while ((p = strchr(current, '\n')) == NULL) {
    nb = strlen(current);
    if (nb + 1 == tmpSize) die("line too long (maybe tmpSize is too small...)");
    memmove(buffer, current, nb);
    current = buffer;
    nb2 = read(fd, buffer + nb, tmpSize - nb - 1);
    if (nb2 <= 0) die("no line to read");
    buffer[nb + nb2] = '\0';
  }
  *p = '\0';
  q = current; current = p + 1;
  /*printf("line_by_line_read %s\n", q);*/
  return q;
}


extern void send_msg(int fd, char *msg)
{
  if (write(fd, msg, strlen(msg)) == -1) die("write");
}

extern void send_int(int fd, int val)
{
  char tmp[tmpSize];
  sprintf(tmp, "%d\n", val);
  send_msg(fd, tmp);
}

extern boolean connect_server(int *fd)
{
  struct sockaddr_un addr;
  int size;
  
  addr.sun_family=AF_UNIX;
  strcpy(addr.sun_path, socket_name);
  size = offsetof(struct sockaddr_un, sun_path) + strlen (socket_name) + 1;

  if ((*fd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) die("socket");
  return connect(*fd, (struct sockaddr *) &addr, size) != -1;
}

extern void X_exit(int status)
{
  char *args[2];

  args[0] = (status == 0) ? "true": "false";
  args[1] = NULL;
  execvp(args[0], args);
  fprintf(stderr, "oops %s not found (it's gonna be tough)\n", args[0]);
  exit(1);
}

extern void supprDoubleSlashes(char *p)
{
  char *q;

  while ((q = strstr(p, "//"))) {
    memmove(q, q + 1, strlen(q));
  }
}

extern void install_signal_handler(int signal, void (*handler)(int))
{
  struct sigaction new_action;  

  new_action.sa_handler = handler;
  sigemptyset (&new_action.sa_mask);
  new_action.sa_flags = SA_RESTART;
  sigaction (signal, &new_action, NULL);
}

/*
static void mask_or_unmask_it(int block_or_unblock)
{
  sigset_t s;
  sigemptyset(&s);
  sigaddset(&s, SIGCHLD);
  if (sigprocmask(block_or_unblock, &s, NULL)) die("sigprocmask");
}
extern void mask_sigchild() { mask_or_unmask_it(SIG_BLOCK); }
extern void unmask_sigchild() { mask_or_unmask_it(SIG_UNBLOCK); }
*/
