#!/usr/bin/perl -w
#
#  gen_scale_alias.pl v1.2  (Tuesday, 2000-05-13)
#
#  A Perl script to generate xfonts-arphic-*.{scale,alias}
#  for the Debian GNU/Linux system
#
#  GNU GPL v2, Copyright (C) 1999-2000, Anthony Fok <foka@debian.org>
#
#  Special thanks to the Chinese GNU/Linux Extension (CLE) Team
#  for the sample *.scale and *.alias files.

# Define meta-information

@fonts = qw/bsmi bkai gbsn gkai/;

# The following was used in 1.0:  Way too many just to fix the glitch
# in Netscape 4.x!
# @sizes = ( 8..20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 48,
# 	   54, 60, 72, 80, 96, 108, 144 );

# The following are the sizes used in GTK
@sizes = ( 8..14, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40, 48, 56, 64, 72 );

$foundry = 'Arphic';

# Define font-specific information

%bsmi = ( typeface => 'bsmi00lp',
	  familyname => 'AR PL Mingti2L Big5',
	  chinesename => '幩PLӤW',
	  defaultname => 'ming',
	  charset => 'big5-0' );

%bkai = ( typeface => 'bkai00mp',
	  familyname => 'AR PL KaitiM Big5',
	  chinesename => '幩PL',
	  defaultname => 'kai',
	  charset => 'big5-0' );

%gbsn = ( typeface => 'gbsn00lp',
	  familyname => 'AR PL SungtiL GB',
	  chinesename => 'ĶPL',
	  defaultname => 'song',
	  charset => 'gb2312.1980-0' );

%gkai = ( typeface => 'gkai00mp',
	  familyname => 'AR PL KaitiM GB',
	  chinesename => 'ĶPLп',
	  defaultname => 'kai',
	  charset => 'gb2312.1980-0' );

# Main program body

for $f (@fonts) {
    $i = 0;
    $bin_package = "xfonts-arphic-" . $$f{typeface};
    open(SCALE, ">$bin_package.scale.in\n");
    open(ALIAS, ">$bin_package.alias\n");

    # Generate scale file
    #
    for $c ($$f{charset}, qw/iso8859-1 iso8859-15 iso10646-1/) {
	for $w (qw/medium bold/) {
	    for $s (qw/r i/) {
		print SCALE $c =~ /^iso8859-/ ? 'bw=0.5:' : '';
		print SCALE $w eq 'bold' ? 'ds=y:' : '';
		print SCALE $s eq 'i' ? 'ai=0.167:' : '';
		print SCALE "vl=y:$$f{typeface}.ttf ";
		print SCALE "-$foundry-$$f{familyname}-$w-$s-normal-";
		print SCALE "-0-0-0-0-c-0-$c\n";
		$i++;

		# Don't need these aliases: too many.
		#
		#for $size (@sizes) {
		#    print ALIAS "\"-$foundry-$$f{familyname}-$w-$s-normal-";
		#    print ALIAS "-$size-${size}0-72-72-c-";
		#    print ALIAS $c =~ /^iso8859-/
		#	? $size % 2 == 0
		#	    ? $size * 5 : ($size + 1) * 5
		#	: $size * 10;
		#    print ALIAS "-$c\" ";
		#    print ALIAS "\"-$foundry-$$f{familyname}-$w-$s-normal-";
		#    print ALIAS "-$size-${size}0-0-0-c-0-$c\"\n";
		#}

	    }
	}
    }

# No, we don't need Chinese aliases either.  Can't read them anyways.
#    # Generate Chinese aliases
#    #
#    for $w (qw/medium bold/) {
#	for $s (qw/r i/) {
#	    print ALIAS "\"-$foundry-$$f{chinesename}-$w-$s-normal-";
#	    print ALIAS "-0-0-0-0-c-0-$$f{charset}\" ";
#	    print ALIAS "\"-$foundry-$$f{familyname}-$w-$s-normal-";
#	    print ALIAS "-0-0-0-0-c-0-$$f{charset}\"\n";
#	}
#    }

    # Generate aliases: -default-ming-*, -default-kai-*, and -default-song-*
    #
    for $w (qw/medium bold/) {
	for $s (qw/r i/) {
	    print ALIAS "-default-$$f{defaultname}-$w-$s-normal-";
	    print ALIAS "-0-0-0-0-c-0-$$f{charset} ";
	    print ALIAS "\"-$foundry-$$f{familyname}-$w-$s-normal-";
	    print ALIAS "-0-0-0-0-c-0-$$f{charset}\"\n";
	}
    }

    # Generate -default-{ming,kai,song}-* aliases, just for Netscape 4.x.
    #
    for $w (qw/medium bold/) {
	for $s (qw/r i/) {
	    for $size (@sizes) {
		print ALIAS "-default-$$f{defaultname}-$w-$s-normal-";
		print ALIAS "-$size-${size}0-72-72-c-${size}0-$$f{charset} ";
		print ALIAS "\"-$foundry-$$f{familyname}-$w-$s-normal-";
		print ALIAS "-$size-${size}0-0-0-c-0-$$f{charset}\"\n";
	    }
	}
    }

    # Wrapping up...

    close(SCALE);
    close(ALIAS);
    open(SCALEI, ">$bin_package.scale\n");
    print SCALEI "$i\n";
    close(SCALEI);
    system("cat $bin_package.scale.in >> $bin_package.scale");
    unlink("$bin_package.scale.in");
}
