CORBA_INTERFACES = echo seq2 seq3 seq4 seq5 seq6 seq7 seq8 seq9 seq10 \
                   seq1 shutdown

.ifdef INITIALIZE_MMS

all ::

.else

CXXSRCS = t_string.cc t_seq_long.cc t_seq_string.cc \
          t_objref.cc t_seq_objref.cc \
          client.cc server.cc 

DIR_FIRSTACTIONS = define/nolog common [-.common]

.default
	@ !

# The stub of seq1 takes a long time and lots of resources to compile with
# optimisation. Set CXXDEBUGFLAGS to null to remove the optimisation flag.
#!!!CXXDEBUGFLAGS =

COMMON_OBJS = [-.common]common$(DebugSuffix).olb

OBJ_LIBS = $(COMMON_OBJS) $(CORBA_LIB)
OBJ_LIB_DEPEND = $(COMMON_OBJS) $(CORBA_LIB_DEPEND)

t_string      = t_string$(DebugSuffix).exe
t_seq_long    = t_seq_long$(DebugSuffix).exe
t_seq_string  = t_seq_string$(DebugSuffix).exe
t_objref      = t_objref$(DebugSuffix).exe
t_seq_objref  = t_seq_objref$(DebugSuffix).exe
client        = client$(DebugSuffix).exe
server        = server$(DebugSuffix).exe

all :: $(client) $(server)

all :: $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref) $(t_seq_objref)

t_string.obj : t_string.cc
t_seq_long.obj : t_seq_long.cc
t_seq_string.obj : t_seq_string.cc
t_objref.obj : t_objref.cc
t_seq_objref.obj : t_seq_objref.cc
client.obj : client.cc
server.obj : server.cc

$(t_string) : t_string.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(t_seq_long) : t_seq_long.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(t_seq_string) : t_seq_string.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(t_objref) : t_objref.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(t_seq_objref) : t_seq_objref.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(client) : client.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(server) : server.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

clean ::
	@ $(RM) $(client) $(server)
	@ $(RM) $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref)
	@ $(RM) $(t_seq_objref)

.endif
