// -*-c++-*-

#ifndef __INTERFACE_H
#define __INTERFACE_H

#include "DisplayDevice.h"

class InterfaceElement {
protected:
    const char * text;
    int c1, c2;
    int selectable;
    int selected;
public:
    InterfaceElement(const char * t, int c1, int c2, int sel) : 
	text(t), c1(c1), c2(c2), selectable(sel), selected(0) {
    }

    virtual void display(int line);
    virtual int do_key(int key);

    friend class Interface;
    friend class InterfaceList;
    friend class InterfaceCoreOption;
};

class InterfaceElementOption : public InterfaceElement {
    Option * option;
    int inc1, inc2, inc3;
public:
    InterfaceElementOption(const char * fmt, Option * opt, int i1=1, int i2=1, int i3=1) : 
	InterfaceElement(fmt, TEXT_COLOR_NORMAL, TEXT_COLOR_HIGHLIGHT, 1),
	option(opt), inc1(i1), inc2(i2), inc3(i3) {}

    void display(int line);
    int do_key(int key);
};


//
// a line of text
//
class InterfaceElementText : public InterfaceElement {
public:
    InterfaceElementText(const char * t) : 
	InterfaceElement(t, TEXT_COLOR_NORMAL, TEXT_COLOR_NORMAL, 0) {}
    virtual void display(int line);
};

//
// the title line
//
class InterfaceElementTitle : public InterfaceElement {
public:
    InterfaceElementTitle(const char * t) : 
	InterfaceElement(t, TEXT_COLOR_NORMAL, TEXT_COLOR_HIGHLIGHT, 1) {}

    int do_key(int key);
};





//
// The user interface
//
class Interface {
public:
    static Interface * interfaces[];
    static Interface * current;

protected:
    InterfaceElement ** elements;
    int nElements;

    int sel;
    int nr;

    static int showStatus;

    virtual int do_key(int key);
public:
    Interface(InterfaceElement ** el, int nEl, int pos);
    
    virtual void run();
    virtual void display();

    virtual void msg(char *) {}			// a silence message (ignored most of the time)

    static void set(Interface * interface);
    static void next();
    static void prev();

    friend class InterfaceElement;
    friend int main(int argc, char *argv[]);	// for server

    friend int init_mixer();
};

class InterfaceMain : public Interface {
    char * silenceMsg;
    double silenceLine;
    int save;
public:
    InterfaceMain(int p);
    InterfaceMain(InterfaceElement ** el, int nEl, int p) :
	Interface(el, nEl, p), silenceMsg(NULL) {}
    virtual int do_key(int key);
    virtual void display();
    virtual void msg(char * msg);
};


extern Interface * interfaceCoreOption;
extern Interface * interfaceOptions;
extern Interface * interfaceCredits;
extern Interface * interfaceServer;

void initInterfaceLists();


//
// an error message
//
class ErrorMessages {
    char msgs[128][128];
    int on_screen[128];
    int nMsgs;
public:
    ErrorMessages() : nMsgs(0) {}

    void addMessage(const char * text);
    void display();
};


extern ErrorMessages errors;

#endif








