/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  struct AF_opt *AFoptions (void)

Purpose:
  Get a pointer to the audio file options stucture

Description:
  This routine returns a pointer to the Audio file options structure.
      #include <libtsp/AFpar.h>          structure definitions
      ...
      struct AF_opt *AFopt;
      ...
      AFopt = AFoptions ();
  The options structure is defined in the header file AFpar.h:
      struct AF_opt {
        int ErrorHalt;
	int NsampND;
	int RAccess;
        int Ftype;
        struct AF_NHpar NHpar;
	lont int Nframe;
      };
  Normally the only option values that should be set directly are ErrorHalt,
  RAccess and NsampND.  Routines are provided to set the other parameters
  using symbolic values.
  Error Control (ErrorHalt):
    The top level AF routines (AFopenRead, AFopenWrite, AFreadData, etc.)
    normally print an error message and halt when an error is passed from a
    lower level routine.  Optionally, errors can also be signalled by a return
    value such as NULL file pointer or other error flag.  The error options are
    as follows.
      0 - Continue on error, returning an error code
      1 - Stop on error (default behaviour)
  Number of samples (NsampND):
    The number of samples in a speech file opened for read is normally
    returned by AFopenRead.  In some cases, the number of samples can only
    be determined from the actual number of records in the file.  This
    determination is not possible for input streams which are not random
    access.  For such cases, the number of samples value can be set to a value
    which indicates that this value is not available.  The NsampND options are
    as follows.
      0 - Always return the number of samples in the file.
          An error condition exists if the number of samples cannot be
	  determined (default behaviour).
      1 - Return the number of samples if the file is seekable or the
          number of samples is specified in the file header, otherwise
          return a "not available" value (AF_NSAMP_UNDEF).
  Random access requirement (RAccess):
    Some programs require the ability to reposition the file to an earlier
    position (to reread data, for instance).  This parameter controls whether
    a file will be opened if it does not support random access (viz. file
    streams from a pipe are not random access).
      0 - Allow input files which are not random access.  If an attempt is
          made to reposition such a file during a read operation, an error
	  condition will occur.
      1 - Do not open input audio files which are not random access.
  File Type (Ftype):
    Input audio file type.  This parameter can be set with symbolic parameters
    using the routine AFsetFileType.
  No header file parameters (struct AF_NHpar):
    Parameters for noheader audio files.  These parameters can be set with
    symbolic values using the routine AFsetNHpar.
  Number of frames (long int Nframe):
    This value specifies the number of frames in an output audio file.  This
    value is used to set the number of frames information in a file header when
    opening the file.  It is used for non-random access output files which
    cannot update the header after writing the audio data.  If this value is
    AF_NFRAME_UNDEF, the number of frames is not defined.  For some types of
    output files, this setting means that the output file must be
    random-acesss.

Parameters:
  <-  struct AF_opt *
      Pointer to the option structure

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.4 $  $Date: 1997/10/24 14:05:03 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFoptions.c 1.4 1997/10/24 libtsp-v3r0 $";

#include <libtsp/AFheader.h>
#include <libtsp/AFpar.h>

struct AF_opt *
AFoptions ()

{
  /* Initialize to default values */
  static struct AF_opt AFopt = AF_OPT_DEFAULTS;

  return &AFopt;
}
